/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents all of the information that is required to create a theme.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThemeData implements SdkPojo, Serializable, ToCopyableBuilder<CreateThemeData.Builder, CreateThemeData> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateThemeData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<ThemeValues>> VALUES_FIELD = SdkField
            .<List<ThemeValues>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(CreateThemeData::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThemeValues> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThemeValues::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ThemeValues>> OVERRIDES_FIELD = SdkField
            .<List<ThemeValues>> builder(MarshallingType.LIST)
            .memberName("overrides")
            .getter(getter(CreateThemeData::overrides))
            .setter(setter(Builder::overrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThemeValues> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThemeValues::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateThemeData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD,
            OVERRIDES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<ThemeValues> values;

    private final List<ThemeValues> overrides;

    private final Map<String, String> tags;

    private CreateThemeData(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.overrides = builder.overrides;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the theme.
     * </p>
     * 
     * @return The name of the theme.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that deﬁnes the properties of the theme.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return A list of key-value pairs that deﬁnes the properties of the theme.
     */
    public final List<ThemeValues> values() {
        return values;
    }

    /**
     * For responses, this returns true if the service returned a value for the Overrides property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOverrides() {
        return overrides != null && !(overrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the properties that can be overriden to customize an instance of the theme.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrides} method.
     * </p>
     * 
     * @return Describes the properties that can be overriden to customize an instance of the theme.
     */
    public final List<ThemeValues> overrides() {
        return overrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more key-value pairs to use when tagging the theme data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more key-value pairs to use when tagging the theme data.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrides() ? overrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThemeData)) {
            return false;
        }
        CreateThemeData other = (CreateThemeData) obj;
        return Objects.equals(name(), other.name()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && hasOverrides() == other.hasOverrides()
                && Objects.equals(overrides(), other.overrides()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateThemeData").add("Name", name()).add("Values", hasValues() ? values() : null)
                .add("Overrides", hasOverrides() ? overrides() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        case "overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("values", VALUES_FIELD);
        map.put("overrides", OVERRIDES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateThemeData, T> g) {
        return obj -> g.apply((CreateThemeData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateThemeData> {
        /**
         * <p>
         * The name of the theme.
         * </p>
         * 
         * @param name
         *        The name of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of key-value pairs that deﬁnes the properties of the theme.
         * </p>
         * 
         * @param values
         *        A list of key-value pairs that deﬁnes the properties of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<ThemeValues> values);

        /**
         * <p>
         * A list of key-value pairs that deﬁnes the properties of the theme.
         * </p>
         * 
         * @param values
         *        A list of key-value pairs that deﬁnes the properties of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(ThemeValues... values);

        /**
         * <p>
         * A list of key-value pairs that deﬁnes the properties of the theme.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder#build()} is called
         * immediately and its result is passed to {@link #values(List<ThemeValues>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<ThemeValues>)
         */
        Builder values(Consumer<ThemeValues.Builder>... values);

        /**
         * <p>
         * Describes the properties that can be overriden to customize an instance of the theme.
         * </p>
         * 
         * @param overrides
         *        Describes the properties that can be overriden to customize an instance of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(Collection<ThemeValues> overrides);

        /**
         * <p>
         * Describes the properties that can be overriden to customize an instance of the theme.
         * </p>
         * 
         * @param overrides
         *        Describes the properties that can be overriden to customize an instance of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(ThemeValues... overrides);

        /**
         * <p>
         * Describes the properties that can be overriden to customize an instance of the theme.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder#build()} is called
         * immediately and its result is passed to {@link #overrides(List<ThemeValues>)}.
         * 
         * @param overrides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(java.util.Collection<ThemeValues>)
         */
        Builder overrides(Consumer<ThemeValues.Builder>... overrides);

        /**
         * <p>
         * One or more key-value pairs to use when tagging the theme data.
         * </p>
         * 
         * @param tags
         *        One or more key-value pairs to use when tagging the theme data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<ThemeValues> values = DefaultSdkAutoConstructList.getInstance();

        private List<ThemeValues> overrides = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThemeData model) {
            name(model.name);
            values(model.values);
            overrides(model.overrides);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ThemeValues.Builder> getValues() {
            List<ThemeValues.Builder> result = ThemeValuesListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<ThemeValues.BuilderImpl> values) {
            this.values = ThemeValuesListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<ThemeValues> values) {
            this.values = ThemeValuesListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(ThemeValues... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<ThemeValues.Builder>... values) {
            values(Stream.of(values).map(c -> ThemeValues.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ThemeValues.Builder> getOverrides() {
            List<ThemeValues.Builder> result = ThemeValuesListCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<ThemeValues.BuilderImpl> overrides) {
            this.overrides = ThemeValuesListCopier.copyFromBuilder(overrides);
        }

        @Override
        public final Builder overrides(Collection<ThemeValues> overrides) {
            this.overrides = ThemeValuesListCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(ThemeValues... overrides) {
            overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<ThemeValues.Builder>... overrides) {
            overrides(Stream.of(overrides).map(c -> ThemeValues.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public CreateThemeData build() {
            return new CreateThemeData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
