/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes how to bind a component property to form data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormBindingElement implements SdkPojo, Serializable,
        ToCopyableBuilder<FormBindingElement.Builder, FormBindingElement> {
    private static final SdkField<String> ELEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("element")
            .getter(getter(FormBindingElement::element)).setter(setter(Builder::element))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("element").build()).build();

    private static final SdkField<String> PROPERTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("property").getter(getter(FormBindingElement::property)).setter(setter(Builder::property))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("property").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ELEMENT_FIELD, PROPERTY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String element;

    private final String property;

    private FormBindingElement(BuilderImpl builder) {
        this.element = builder.element;
        this.property = builder.property;
    }

    /**
     * <p>
     * The name of the component to retrieve a value from.
     * </p>
     * 
     * @return The name of the component to retrieve a value from.
     */
    public final String element() {
        return element;
    }

    /**
     * <p>
     * The property to retrieve a value from.
     * </p>
     * 
     * @return The property to retrieve a value from.
     */
    public final String property() {
        return property;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(element());
        hashCode = 31 * hashCode + Objects.hashCode(property());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormBindingElement)) {
            return false;
        }
        FormBindingElement other = (FormBindingElement) obj;
        return Objects.equals(element(), other.element()) && Objects.equals(property(), other.property());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormBindingElement").add("Element", element()).add("Property", property()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "element":
            return Optional.ofNullable(clazz.cast(element()));
        case "property":
            return Optional.ofNullable(clazz.cast(property()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("element", ELEMENT_FIELD);
        map.put("property", PROPERTY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FormBindingElement, T> g) {
        return obj -> g.apply((FormBindingElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormBindingElement> {
        /**
         * <p>
         * The name of the component to retrieve a value from.
         * </p>
         * 
         * @param element
         *        The name of the component to retrieve a value from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder element(String element);

        /**
         * <p>
         * The property to retrieve a value from.
         * </p>
         * 
         * @param property
         *        The property to retrieve a value from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder property(String property);
    }

    static final class BuilderImpl implements Builder {
        private String element;

        private String property;

        private BuilderImpl() {
        }

        private BuilderImpl(FormBindingElement model) {
            element(model.element);
            property(model.property);
        }

        public final String getElement() {
            return element;
        }

        public final void setElement(String element) {
            this.element = element;
        }

        @Override
        public final Builder element(String element) {
            this.element = element;
            return this;
        }

        public final String getProperty() {
            return property;
        }

        public final void setProperty(String property) {
            this.property = property;
        }

        @Override
        public final Builder property(String property) {
            this.property = property;
            return this;
        }

        @Override
        public FormBindingElement build() {
            return new FormBindingElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
