/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the call to action button configuration for the form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormCTA implements SdkPojo, Serializable, ToCopyableBuilder<FormCTA.Builder, FormCTA> {
    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("position").getter(getter(FormCTA::positionAsString)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<FormButton> CLEAR_FIELD = SdkField.<FormButton> builder(MarshallingType.SDK_POJO)
            .memberName("clear").getter(getter(FormCTA::clear)).setter(setter(Builder::clear)).constructor(FormButton::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clear").build()).build();

    private static final SdkField<FormButton> CANCEL_FIELD = SdkField.<FormButton> builder(MarshallingType.SDK_POJO)
            .memberName("cancel").getter(getter(FormCTA::cancel)).setter(setter(Builder::cancel))
            .constructor(FormButton::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cancel").build()).build();

    private static final SdkField<FormButton> SUBMIT_FIELD = SdkField.<FormButton> builder(MarshallingType.SDK_POJO)
            .memberName("submit").getter(getter(FormCTA::submit)).setter(setter(Builder::submit))
            .constructor(FormButton::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_FIELD, CLEAR_FIELD,
            CANCEL_FIELD, SUBMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String position;

    private final FormButton clear;

    private final FormButton cancel;

    private final FormButton submit;

    private FormCTA(BuilderImpl builder) {
        this.position = builder.position;
        this.clear = builder.clear;
        this.cancel = builder.cancel;
        this.submit = builder.submit;
    }

    /**
     * <p>
     * The position of the button.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link FormButtonsPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionAsString}.
     * </p>
     * 
     * @return The position of the button.
     * @see FormButtonsPosition
     */
    public final FormButtonsPosition position() {
        return FormButtonsPosition.fromValue(position);
    }

    /**
     * <p>
     * The position of the button.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #position} will
     * return {@link FormButtonsPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positionAsString}.
     * </p>
     * 
     * @return The position of the button.
     * @see FormButtonsPosition
     */
    public final String positionAsString() {
        return position;
    }

    /**
     * <p>
     * Displays a clear button.
     * </p>
     * 
     * @return Displays a clear button.
     */
    public final FormButton clear() {
        return clear;
    }

    /**
     * <p>
     * Displays a cancel button.
     * </p>
     * 
     * @return Displays a cancel button.
     */
    public final FormButton cancel() {
        return cancel;
    }

    /**
     * <p>
     * Displays a submit button.
     * </p>
     * 
     * @return Displays a submit button.
     */
    public final FormButton submit() {
        return submit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(positionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clear());
        hashCode = 31 * hashCode + Objects.hashCode(cancel());
        hashCode = 31 * hashCode + Objects.hashCode(submit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormCTA)) {
            return false;
        }
        FormCTA other = (FormCTA) obj;
        return Objects.equals(positionAsString(), other.positionAsString()) && Objects.equals(clear(), other.clear())
                && Objects.equals(cancel(), other.cancel()) && Objects.equals(submit(), other.submit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormCTA").add("Position", positionAsString()).add("Clear", clear()).add("Cancel", cancel())
                .add("Submit", submit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "position":
            return Optional.ofNullable(clazz.cast(positionAsString()));
        case "clear":
            return Optional.ofNullable(clazz.cast(clear()));
        case "cancel":
            return Optional.ofNullable(clazz.cast(cancel()));
        case "submit":
            return Optional.ofNullable(clazz.cast(submit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("position", POSITION_FIELD);
        map.put("clear", CLEAR_FIELD);
        map.put("cancel", CANCEL_FIELD);
        map.put("submit", SUBMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FormCTA, T> g) {
        return obj -> g.apply((FormCTA) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormCTA> {
        /**
         * <p>
         * The position of the button.
         * </p>
         * 
         * @param position
         *        The position of the button.
         * @see FormButtonsPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormButtonsPosition
         */
        Builder position(String position);

        /**
         * <p>
         * The position of the button.
         * </p>
         * 
         * @param position
         *        The position of the button.
         * @see FormButtonsPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormButtonsPosition
         */
        Builder position(FormButtonsPosition position);

        /**
         * <p>
         * Displays a clear button.
         * </p>
         * 
         * @param clear
         *        Displays a clear button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clear(FormButton clear);

        /**
         * <p>
         * Displays a clear button.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormButton.Builder} avoiding the need to
         * create one manually via {@link FormButton#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormButton.Builder#build()} is called immediately and its result
         * is passed to {@link #clear(FormButton)}.
         * 
         * @param clear
         *        a consumer that will call methods on {@link FormButton.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clear(FormButton)
         */
        default Builder clear(Consumer<FormButton.Builder> clear) {
            return clear(FormButton.builder().applyMutation(clear).build());
        }

        /**
         * <p>
         * Displays a cancel button.
         * </p>
         * 
         * @param cancel
         *        Displays a cancel button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancel(FormButton cancel);

        /**
         * <p>
         * Displays a cancel button.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormButton.Builder} avoiding the need to
         * create one manually via {@link FormButton#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormButton.Builder#build()} is called immediately and its result
         * is passed to {@link #cancel(FormButton)}.
         * 
         * @param cancel
         *        a consumer that will call methods on {@link FormButton.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cancel(FormButton)
         */
        default Builder cancel(Consumer<FormButton.Builder> cancel) {
            return cancel(FormButton.builder().applyMutation(cancel).build());
        }

        /**
         * <p>
         * Displays a submit button.
         * </p>
         * 
         * @param submit
         *        Displays a submit button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submit(FormButton submit);

        /**
         * <p>
         * Displays a submit button.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormButton.Builder} avoiding the need to
         * create one manually via {@link FormButton#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormButton.Builder#build()} is called immediately and its result
         * is passed to {@link #submit(FormButton)}.
         * 
         * @param submit
         *        a consumer that will call methods on {@link FormButton.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #submit(FormButton)
         */
        default Builder submit(Consumer<FormButton.Builder> submit) {
            return submit(FormButton.builder().applyMutation(submit).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String position;

        private FormButton clear;

        private FormButton cancel;

        private FormButton submit;

        private BuilderImpl() {
        }

        private BuilderImpl(FormCTA model) {
            position(model.position);
            clear(model.clear);
            cancel(model.cancel);
            submit(model.submit);
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(FormButtonsPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public final FormButton.Builder getClear() {
            return clear != null ? clear.toBuilder() : null;
        }

        public final void setClear(FormButton.BuilderImpl clear) {
            this.clear = clear != null ? clear.build() : null;
        }

        @Override
        public final Builder clear(FormButton clear) {
            this.clear = clear;
            return this;
        }

        public final FormButton.Builder getCancel() {
            return cancel != null ? cancel.toBuilder() : null;
        }

        public final void setCancel(FormButton.BuilderImpl cancel) {
            this.cancel = cancel != null ? cancel.build() : null;
        }

        @Override
        public final Builder cancel(FormButton cancel) {
            this.cancel = cancel;
            return this;
        }

        public final FormButton.Builder getSubmit() {
            return submit != null ? submit.toBuilder() : null;
        }

        public final void setSubmit(FormButton.BuilderImpl submit) {
            this.submit = submit != null ? submit.build() : null;
        }

        @Override
        public final Builder submit(FormButton submit) {
            this.submit = submit;
            return this;
        }

        @Override
        public FormCTA build() {
            return new FormCTA(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
