/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration for the form's style.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormStyle implements SdkPojo, Serializable, ToCopyableBuilder<FormStyle.Builder, FormStyle> {
    private static final SdkField<FormStyleConfig> HORIZONTAL_GAP_FIELD = SdkField
            .<FormStyleConfig> builder(MarshallingType.SDK_POJO).memberName("horizontalGap")
            .getter(getter(FormStyle::horizontalGap)).setter(setter(Builder::horizontalGap))
            .constructor(FormStyleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("horizontalGap").build()).build();

    private static final SdkField<FormStyleConfig> VERTICAL_GAP_FIELD = SdkField
            .<FormStyleConfig> builder(MarshallingType.SDK_POJO).memberName("verticalGap").getter(getter(FormStyle::verticalGap))
            .setter(setter(Builder::verticalGap)).constructor(FormStyleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verticalGap").build()).build();

    private static final SdkField<FormStyleConfig> OUTER_PADDING_FIELD = SdkField
            .<FormStyleConfig> builder(MarshallingType.SDK_POJO).memberName("outerPadding")
            .getter(getter(FormStyle::outerPadding)).setter(setter(Builder::outerPadding)).constructor(FormStyleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outerPadding").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HORIZONTAL_GAP_FIELD,
            VERTICAL_GAP_FIELD, OUTER_PADDING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FormStyleConfig horizontalGap;

    private final FormStyleConfig verticalGap;

    private final FormStyleConfig outerPadding;

    private FormStyle(BuilderImpl builder) {
        this.horizontalGap = builder.horizontalGap;
        this.verticalGap = builder.verticalGap;
        this.outerPadding = builder.outerPadding;
    }

    /**
     * <p>
     * The spacing for the horizontal gap.
     * </p>
     * 
     * @return The spacing for the horizontal gap.
     */
    public final FormStyleConfig horizontalGap() {
        return horizontalGap;
    }

    /**
     * <p>
     * The spacing for the vertical gap.
     * </p>
     * 
     * @return The spacing for the vertical gap.
     */
    public final FormStyleConfig verticalGap() {
        return verticalGap;
    }

    /**
     * <p>
     * The size of the outer padding for the form.
     * </p>
     * 
     * @return The size of the outer padding for the form.
     */
    public final FormStyleConfig outerPadding() {
        return outerPadding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(horizontalGap());
        hashCode = 31 * hashCode + Objects.hashCode(verticalGap());
        hashCode = 31 * hashCode + Objects.hashCode(outerPadding());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormStyle)) {
            return false;
        }
        FormStyle other = (FormStyle) obj;
        return Objects.equals(horizontalGap(), other.horizontalGap()) && Objects.equals(verticalGap(), other.verticalGap())
                && Objects.equals(outerPadding(), other.outerPadding());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormStyle").add("HorizontalGap", horizontalGap()).add("VerticalGap", verticalGap())
                .add("OuterPadding", outerPadding()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "horizontalGap":
            return Optional.ofNullable(clazz.cast(horizontalGap()));
        case "verticalGap":
            return Optional.ofNullable(clazz.cast(verticalGap()));
        case "outerPadding":
            return Optional.ofNullable(clazz.cast(outerPadding()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("horizontalGap", HORIZONTAL_GAP_FIELD);
        map.put("verticalGap", VERTICAL_GAP_FIELD);
        map.put("outerPadding", OUTER_PADDING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FormStyle, T> g) {
        return obj -> g.apply((FormStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormStyle> {
        /**
         * <p>
         * The spacing for the horizontal gap.
         * </p>
         * 
         * @param horizontalGap
         *        The spacing for the horizontal gap.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder horizontalGap(FormStyleConfig horizontalGap);

        /**
         * <p>
         * The spacing for the horizontal gap.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormStyleConfig.Builder} avoiding the
         * need to create one manually via {@link FormStyleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormStyleConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #horizontalGap(FormStyleConfig)}.
         * 
         * @param horizontalGap
         *        a consumer that will call methods on {@link FormStyleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #horizontalGap(FormStyleConfig)
         */
        default Builder horizontalGap(Consumer<FormStyleConfig.Builder> horizontalGap) {
            return horizontalGap(FormStyleConfig.builder().applyMutation(horizontalGap).build());
        }

        /**
         * <p>
         * The spacing for the vertical gap.
         * </p>
         * 
         * @param verticalGap
         *        The spacing for the vertical gap.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verticalGap(FormStyleConfig verticalGap);

        /**
         * <p>
         * The spacing for the vertical gap.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormStyleConfig.Builder} avoiding the
         * need to create one manually via {@link FormStyleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormStyleConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #verticalGap(FormStyleConfig)}.
         * 
         * @param verticalGap
         *        a consumer that will call methods on {@link FormStyleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verticalGap(FormStyleConfig)
         */
        default Builder verticalGap(Consumer<FormStyleConfig.Builder> verticalGap) {
            return verticalGap(FormStyleConfig.builder().applyMutation(verticalGap).build());
        }

        /**
         * <p>
         * The size of the outer padding for the form.
         * </p>
         * 
         * @param outerPadding
         *        The size of the outer padding for the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outerPadding(FormStyleConfig outerPadding);

        /**
         * <p>
         * The size of the outer padding for the form.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormStyleConfig.Builder} avoiding the
         * need to create one manually via {@link FormStyleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormStyleConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outerPadding(FormStyleConfig)}.
         * 
         * @param outerPadding
         *        a consumer that will call methods on {@link FormStyleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outerPadding(FormStyleConfig)
         */
        default Builder outerPadding(Consumer<FormStyleConfig.Builder> outerPadding) {
            return outerPadding(FormStyleConfig.builder().applyMutation(outerPadding).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FormStyleConfig horizontalGap;

        private FormStyleConfig verticalGap;

        private FormStyleConfig outerPadding;

        private BuilderImpl() {
        }

        private BuilderImpl(FormStyle model) {
            horizontalGap(model.horizontalGap);
            verticalGap(model.verticalGap);
            outerPadding(model.outerPadding);
        }

        public final FormStyleConfig.Builder getHorizontalGap() {
            return horizontalGap != null ? horizontalGap.toBuilder() : null;
        }

        public final void setHorizontalGap(FormStyleConfig.BuilderImpl horizontalGap) {
            this.horizontalGap = horizontalGap != null ? horizontalGap.build() : null;
        }

        @Override
        public final Builder horizontalGap(FormStyleConfig horizontalGap) {
            this.horizontalGap = horizontalGap;
            return this;
        }

        public final FormStyleConfig.Builder getVerticalGap() {
            return verticalGap != null ? verticalGap.toBuilder() : null;
        }

        public final void setVerticalGap(FormStyleConfig.BuilderImpl verticalGap) {
            this.verticalGap = verticalGap != null ? verticalGap.build() : null;
        }

        @Override
        public final Builder verticalGap(FormStyleConfig verticalGap) {
            this.verticalGap = verticalGap;
            return this;
        }

        public final FormStyleConfig.Builder getOuterPadding() {
            return outerPadding != null ? outerPadding.toBuilder() : null;
        }

        public final void setOuterPadding(FormStyleConfig.BuilderImpl outerPadding) {
            this.outerPadding = outerPadding != null ? outerPadding.build() : null;
        }

        @Override
        public final Builder outerPadding(FormStyleConfig outerPadding) {
            this.outerPadding = outerPadding;
            return this;
        }

        @Override
        public FormStyle build() {
            return new FormStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
