/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration settings for the form's style properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormStyleConfig implements SdkPojo, Serializable, ToCopyableBuilder<FormStyleConfig.Builder, FormStyleConfig> {
    private static final SdkField<String> TOKEN_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenReference").getter(getter(FormStyleConfig::tokenReference)).setter(setter(Builder::tokenReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenReference").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(FormStyleConfig::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_REFERENCE_FIELD,
            VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tokenReference;

    private final String value;

    private final Type type;

    private FormStyleConfig(BuilderImpl builder) {
        this.tokenReference = builder.tokenReference;
        this.value = builder.value;
        this.type = builder.type;
    }

    /**
     * <p>
     * A reference to a design token to use to bind the form's style properties to an existing theme.
     * </p>
     * 
     * @return A reference to a design token to use to bind the form's style properties to an existing theme.
     */
    public final String tokenReference() {
        return tokenReference;
    }

    /**
     * <p>
     * The value of the style setting.
     * </p>
     * 
     * @return The value of the style setting.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tokenReference());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormStyleConfig)) {
            return false;
        }
        FormStyleConfig other = (FormStyleConfig) obj;
        return Objects.equals(tokenReference(), other.tokenReference()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormStyleConfig").add("TokenReference", tokenReference()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tokenReference":
            return Optional.ofNullable(clazz.cast(tokenReference()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #tokenReference()} initialized to the given value.
     *
     * <p>
     * A reference to a design token to use to bind the form's style properties to an existing theme.
     * </p>
     * 
     * @param tokenReference
     *        A reference to a design token to use to bind the form's style properties to an existing theme.
     */
    public static FormStyleConfig fromTokenReference(String tokenReference) {
        return builder().tokenReference(tokenReference).build();
    }

    /**
     * Create an instance of this class with {@link #value()} initialized to the given value.
     *
     * <p>
     * The value of the style setting.
     * </p>
     * 
     * @param value
     *        The value of the style setting.
     */
    public static FormStyleConfig fromValue(String value) {
        return builder().value(value).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tokenReference", TOKEN_REFERENCE_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FormStyleConfig, T> g) {
        return obj -> g.apply((FormStyleConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormStyleConfig> {
        /**
         * <p>
         * A reference to a design token to use to bind the form's style properties to an existing theme.
         * </p>
         * 
         * @param tokenReference
         *        A reference to a design token to use to bind the form's style properties to an existing theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenReference(String tokenReference);

        /**
         * <p>
         * The value of the style setting.
         * </p>
         * 
         * @param value
         *        The value of the style setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String tokenReference;

        private String value;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FormStyleConfig model) {
            tokenReference(model.tokenReference);
            value(model.value);
        }

        public final String getTokenReference() {
            return tokenReference;
        }

        public final void setTokenReference(String tokenReference) {
            Object oldValue = this.tokenReference;
            this.tokenReference = tokenReference;
            handleUnionValueChange(Type.TOKEN_REFERENCE, oldValue, this.tokenReference);
        }

        @Override
        public final Builder tokenReference(String tokenReference) {
            Object oldValue = this.tokenReference;
            this.tokenReference = tokenReference;
            handleUnionValueChange(Type.TOKEN_REFERENCE, oldValue, this.tokenReference);
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            Object oldValue = this.value;
            this.value = value;
            handleUnionValueChange(Type.VALUE, oldValue, this.value);
        }

        @Override
        public final Builder value(String value) {
            Object oldValue = this.value;
            this.value = value;
            handleUnionValueChange(Type.VALUE, oldValue, this.value);
            return this;
        }

        @Override
        public FormStyleConfig build() {
            return new FormStyleConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FormStyleConfig#type()
     */
    public enum Type {
        TOKEN_REFERENCE,

        VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
