/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stores information for generating Amplify DataStore queries. Use a <code>Predicate</code> to retrieve a subset of the
 * data in a collection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Predicate implements SdkPojo, Serializable, ToCopyableBuilder<Predicate.Builder, Predicate> {
    private static final SdkField<List<Predicate>> OR_FIELD = SdkField
            .<List<Predicate>> builder(MarshallingType.LIST)
            .memberName("or")
            .getter(getter(Predicate::or))
            .setter(setter(Builder::or))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("or").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Predicate> builder(MarshallingType.SDK_POJO)
                                            .constructor(Predicate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Predicate>> AND_FIELD = SdkField
            .<List<Predicate>> builder(MarshallingType.LIST)
            .memberName("and")
            .getter(getter(Predicate::and))
            .setter(setter(Builder::and))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("and").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Predicate> builder(MarshallingType.SDK_POJO)
                                            .constructor(Predicate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("field")
            .getter(getter(Predicate::field)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operator").getter(getter(Predicate::operator)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final SdkField<String> OPERAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("operand")
            .getter(getter(Predicate::operand)).setter(setter(Builder::operand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operand").build()).build();

    private static final SdkField<String> OPERAND_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operandType").getter(getter(Predicate::operandType)).setter(setter(Builder::operandType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operandType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_FIELD, AND_FIELD,
            FIELD_FIELD, OPERATOR_FIELD, OPERAND_FIELD, OPERAND_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Predicate> or;

    private final List<Predicate> and;

    private final String field;

    private final String operator;

    private final String operand;

    private final String operandType;

    private Predicate(BuilderImpl builder) {
        this.or = builder.or;
        this.and = builder.and;
        this.field = builder.field;
        this.operator = builder.operator;
        this.operand = builder.operand;
        this.operandType = builder.operandType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Or property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOr() {
        return or != null && !(or instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of predicates to combine logically.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOr} method.
     * </p>
     * 
     * @return A list of predicates to combine logically.
     */
    public final List<Predicate> or() {
        return or;
    }

    /**
     * For responses, this returns true if the service returned a value for the And property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAnd() {
        return and != null && !(and instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of predicates to combine logically.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnd} method.
     * </p>
     * 
     * @return A list of predicates to combine logically.
     */
    public final List<Predicate> and() {
        return and;
    }

    /**
     * <p>
     * The field to query.
     * </p>
     * 
     * @return The field to query.
     */
    public final String field() {
        return field;
    }

    /**
     * <p>
     * The operator to use to perform the evaluation.
     * </p>
     * 
     * @return The operator to use to perform the evaluation.
     */
    public final String operator() {
        return operator;
    }

    /**
     * <p>
     * The value to use when performing the evaluation.
     * </p>
     * 
     * @return The value to use when performing the evaluation.
     */
    public final String operand() {
        return operand;
    }

    /**
     * <p>
     * The type of value to use when performing the evaluation.
     * </p>
     * 
     * @return The type of value to use when performing the evaluation.
     */
    public final String operandType() {
        return operandType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOr() ? or() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAnd() ? and() : null);
        hashCode = 31 * hashCode + Objects.hashCode(field());
        hashCode = 31 * hashCode + Objects.hashCode(operator());
        hashCode = 31 * hashCode + Objects.hashCode(operand());
        hashCode = 31 * hashCode + Objects.hashCode(operandType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate) obj;
        return hasOr() == other.hasOr() && Objects.equals(or(), other.or()) && hasAnd() == other.hasAnd()
                && Objects.equals(and(), other.and()) && Objects.equals(field(), other.field())
                && Objects.equals(operator(), other.operator()) && Objects.equals(operand(), other.operand())
                && Objects.equals(operandType(), other.operandType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Predicate").add("Or", hasOr() ? or() : null).add("And", hasAnd() ? and() : null)
                .add("Field", field()).add("Operator", operator()).add("Operand", operand()).add("OperandType", operandType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "or":
            return Optional.ofNullable(clazz.cast(or()));
        case "and":
            return Optional.ofNullable(clazz.cast(and()));
        case "field":
            return Optional.ofNullable(clazz.cast(field()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operator()));
        case "operand":
            return Optional.ofNullable(clazz.cast(operand()));
        case "operandType":
            return Optional.ofNullable(clazz.cast(operandType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("or", OR_FIELD);
        map.put("and", AND_FIELD);
        map.put("field", FIELD_FIELD);
        map.put("operator", OPERATOR_FIELD);
        map.put("operand", OPERAND_FIELD);
        map.put("operandType", OPERAND_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Predicate, T> g) {
        return obj -> g.apply((Predicate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Predicate> {
        /**
         * <p>
         * A list of predicates to combine logically.
         * </p>
         * 
         * @param or
         *        A list of predicates to combine logically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(Collection<Predicate> or);

        /**
         * <p>
         * A list of predicates to combine logically.
         * </p>
         * 
         * @param or
         *        A list of predicates to combine logically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(Predicate... or);

        /**
         * <p>
         * A list of predicates to combine logically.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.Predicate.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.amplifyuibuilder.model.Predicate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.Predicate.Builder#build()} is called
         * immediately and its result is passed to {@link #or(List<Predicate>)}.
         * 
         * @param or
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.Predicate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #or(java.util.Collection<Predicate>)
         */
        Builder or(Consumer<Builder>... or);

        /**
         * <p>
         * A list of predicates to combine logically.
         * </p>
         * 
         * @param and
         *        A list of predicates to combine logically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(Collection<Predicate> and);

        /**
         * <p>
         * A list of predicates to combine logically.
         * </p>
         * 
         * @param and
         *        A list of predicates to combine logically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(Predicate... and);

        /**
         * <p>
         * A list of predicates to combine logically.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.Predicate.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.amplifyuibuilder.model.Predicate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.Predicate.Builder#build()} is called
         * immediately and its result is passed to {@link #and(List<Predicate>)}.
         * 
         * @param and
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.Predicate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(java.util.Collection<Predicate>)
         */
        Builder and(Consumer<Builder>... and);

        /**
         * <p>
         * The field to query.
         * </p>
         * 
         * @param field
         *        The field to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(String field);

        /**
         * <p>
         * The operator to use to perform the evaluation.
         * </p>
         * 
         * @param operator
         *        The operator to use to perform the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operator(String operator);

        /**
         * <p>
         * The value to use when performing the evaluation.
         * </p>
         * 
         * @param operand
         *        The value to use when performing the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operand(String operand);

        /**
         * <p>
         * The type of value to use when performing the evaluation.
         * </p>
         * 
         * @param operandType
         *        The type of value to use when performing the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operandType(String operandType);
    }

    static final class BuilderImpl implements Builder {
        private List<Predicate> or = DefaultSdkAutoConstructList.getInstance();

        private List<Predicate> and = DefaultSdkAutoConstructList.getInstance();

        private String field;

        private String operator;

        private String operand;

        private String operandType;

        private BuilderImpl() {
        }

        private BuilderImpl(Predicate model) {
            or(model.or);
            and(model.and);
            field(model.field);
            operator(model.operator);
            operand(model.operand);
            operandType(model.operandType);
        }

        public final List<Builder> getOr() {
            List<Builder> result = PredicateListCopier.copyToBuilder(this.or);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOr(Collection<BuilderImpl> or) {
            this.or = PredicateListCopier.copyFromBuilder(or);
        }

        @Override
        public final Builder or(Collection<Predicate> or) {
            this.or = PredicateListCopier.copy(or);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Predicate... or) {
            or(Arrays.asList(or));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Consumer<Builder>... or) {
            or(Stream.of(or).map(c -> Predicate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAnd() {
            List<Builder> result = PredicateListCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnd(Collection<BuilderImpl> and) {
            this.and = PredicateListCopier.copyFromBuilder(and);
        }

        @Override
        public final Builder and(Collection<Predicate> and) {
            this.and = PredicateListCopier.copy(and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Predicate... and) {
            and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<Builder>... and) {
            and(Stream.of(and).map(c -> Predicate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getField() {
            return field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public final String getOperand() {
            return operand;
        }

        public final void setOperand(String operand) {
            this.operand = operand;
        }

        @Override
        public final Builder operand(String operand) {
            this.operand = operand;
            return this;
        }

        public final String getOperandType() {
            return operandType;
        }

        public final void setOperandType(String operandType) {
            this.operandType = operandType;
        }

        @Override
        public final Builder operandType(String operandType) {
            this.operandType = operandType;
            return this;
        }

        @Override
        public Predicate build() {
            return new Predicate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
