/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMetadataFlagRequest extends AmplifyUiBuilderRequest implements
        ToCopyableBuilder<PutMetadataFlagRequest.Builder, PutMetadataFlagRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(PutMetadataFlagRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(PutMetadataFlagRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentName").build()).build();

    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("featureName").getter(getter(PutMetadataFlagRequest::featureName)).setter(setter(Builder::featureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("featureName").build()).build();

    private static final SdkField<PutMetadataFlagBody> BODY_FIELD = SdkField
            .<PutMetadataFlagBody> builder(MarshallingType.SDK_POJO)
            .memberName("body")
            .getter(getter(PutMetadataFlagRequest::body))
            .setter(setter(Builder::body))
            .constructor(PutMetadataFlagBody::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            ENVIRONMENT_NAME_FIELD, FEATURE_NAME_FIELD, BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appId;

    private final String environmentName;

    private final String featureName;

    private final PutMetadataFlagBody body;

    private PutMetadataFlagRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
        this.featureName = builder.featureName;
        this.body = builder.body;
    }

    /**
     * <p>
     * The unique ID for the Amplify app.
     * </p>
     * 
     * @return The unique ID for the Amplify app.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of the backend environment that is part of the Amplify app.
     * </p>
     * 
     * @return The name of the backend environment that is part of the Amplify app.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The name of the feature associated with the metadata.
     * </p>
     * 
     * @return The name of the feature associated with the metadata.
     */
    public final String featureName() {
        return featureName;
    }

    /**
     * <p>
     * The metadata information to store.
     * </p>
     * 
     * @return The metadata information to store.
     */
    public final PutMetadataFlagBody body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(featureName());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetadataFlagRequest)) {
            return false;
        }
        PutMetadataFlagRequest other = (PutMetadataFlagRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(featureName(), other.featureName()) && Objects.equals(body(), other.body());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutMetadataFlagRequest").add("AppId", appId()).add("EnvironmentName", environmentName())
                .add("FeatureName", featureName()).add("Body", body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "featureName":
            return Optional.ofNullable(clazz.cast(featureName()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appId", APP_ID_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("featureName", FEATURE_NAME_FIELD);
        map.put("body", BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutMetadataFlagRequest, T> g) {
        return obj -> g.apply((PutMetadataFlagRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyUiBuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutMetadataFlagRequest> {
        /**
         * <p>
         * The unique ID for the Amplify app.
         * </p>
         * 
         * @param appId
         *        The unique ID for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of the backend environment that is part of the Amplify app.
         * </p>
         * 
         * @param environmentName
         *        The name of the backend environment that is part of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The name of the feature associated with the metadata.
         * </p>
         * 
         * @param featureName
         *        The name of the feature associated with the metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureName(String featureName);

        /**
         * <p>
         * The metadata information to store.
         * </p>
         * 
         * @param body
         *        The metadata information to store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(PutMetadataFlagBody body);

        /**
         * <p>
         * The metadata information to store.
         * </p>
         * This is a convenience method that creates an instance of the {@link PutMetadataFlagBody.Builder} avoiding the
         * need to create one manually via {@link PutMetadataFlagBody#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PutMetadataFlagBody.Builder#build()} is called immediately and
         * its result is passed to {@link #body(PutMetadataFlagBody)}.
         * 
         * @param body
         *        a consumer that will call methods on {@link PutMetadataFlagBody.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #body(PutMetadataFlagBody)
         */
        default Builder body(Consumer<PutMetadataFlagBody.Builder> body) {
            return body(PutMetadataFlagBody.builder().applyMutation(body).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyUiBuilderRequest.BuilderImpl implements Builder {
        private String appId;

        private String environmentName;

        private String featureName;

        private PutMetadataFlagBody body;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetadataFlagRequest model) {
            super(model);
            appId(model.appId);
            environmentName(model.environmentName);
            featureName(model.featureName);
            body(model.body);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getFeatureName() {
            return featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final PutMetadataFlagBody.Builder getBody() {
            return body != null ? body.toBuilder() : null;
        }

        public final void setBody(PutMetadataFlagBody.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(PutMetadataFlagBody body) {
            this.body = body;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetadataFlagRequest build() {
            return new PutMetadataFlagRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
