/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshTokenRequest extends AmplifyUiBuilderRequest implements
        ToCopyableBuilder<RefreshTokenRequest.Builder, RefreshTokenRequest> {
    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(RefreshTokenRequest::providerAsString)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("provider").build()).build();

    private static final SdkField<RefreshTokenRequestBody> REFRESH_TOKEN_BODY_FIELD = SdkField
            .<RefreshTokenRequestBody> builder(MarshallingType.SDK_POJO)
            .memberName("refreshTokenBody")
            .getter(getter(RefreshTokenRequest::refreshTokenBody))
            .setter(setter(Builder::refreshTokenBody))
            .constructor(RefreshTokenRequestBody::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshTokenBody").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_FIELD,
            REFRESH_TOKEN_BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String provider;

    private final RefreshTokenRequestBody refreshTokenBody;

    private RefreshTokenRequest(BuilderImpl builder) {
        super(builder);
        this.provider = builder.provider;
        this.refreshTokenBody = builder.refreshTokenBody;
    }

    /**
     * <p>
     * The third-party provider for the token. The only valid value is <code>figma</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link TokenProviders#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerAsString}.
     * </p>
     * 
     * @return The third-party provider for the token. The only valid value is <code>figma</code>.
     * @see TokenProviders
     */
    public final TokenProviders provider() {
        return TokenProviders.fromValue(provider);
    }

    /**
     * <p>
     * The third-party provider for the token. The only valid value is <code>figma</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link TokenProviders#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerAsString}.
     * </p>
     * 
     * @return The third-party provider for the token. The only valid value is <code>figma</code>.
     * @see TokenProviders
     */
    public final String providerAsString() {
        return provider;
    }

    /**
     * <p>
     * Information about the refresh token request.
     * </p>
     * 
     * @return Information about the refresh token request.
     */
    public final RefreshTokenRequestBody refreshTokenBody() {
        return refreshTokenBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(refreshTokenBody());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshTokenRequest)) {
            return false;
        }
        RefreshTokenRequest other = (RefreshTokenRequest) obj;
        return Objects.equals(providerAsString(), other.providerAsString())
                && Objects.equals(refreshTokenBody(), other.refreshTokenBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshTokenRequest").add("Provider", providerAsString())
                .add("RefreshTokenBody", refreshTokenBody()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "provider":
            return Optional.ofNullable(clazz.cast(providerAsString()));
        case "refreshTokenBody":
            return Optional.ofNullable(clazz.cast(refreshTokenBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("provider", PROVIDER_FIELD);
        map.put("refreshTokenBody", REFRESH_TOKEN_BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshTokenRequest, T> g) {
        return obj -> g.apply((RefreshTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyUiBuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, RefreshTokenRequest> {
        /**
         * <p>
         * The third-party provider for the token. The only valid value is <code>figma</code>.
         * </p>
         * 
         * @param provider
         *        The third-party provider for the token. The only valid value is <code>figma</code>.
         * @see TokenProviders
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TokenProviders
         */
        Builder provider(String provider);

        /**
         * <p>
         * The third-party provider for the token. The only valid value is <code>figma</code>.
         * </p>
         * 
         * @param provider
         *        The third-party provider for the token. The only valid value is <code>figma</code>.
         * @see TokenProviders
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TokenProviders
         */
        Builder provider(TokenProviders provider);

        /**
         * <p>
         * Information about the refresh token request.
         * </p>
         * 
         * @param refreshTokenBody
         *        Information about the refresh token request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshTokenBody(RefreshTokenRequestBody refreshTokenBody);

        /**
         * <p>
         * Information about the refresh token request.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshTokenRequestBody.Builder} avoiding
         * the need to create one manually via {@link RefreshTokenRequestBody#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshTokenRequestBody.Builder#build()} is called immediately
         * and its result is passed to {@link #refreshTokenBody(RefreshTokenRequestBody)}.
         * 
         * @param refreshTokenBody
         *        a consumer that will call methods on {@link RefreshTokenRequestBody.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshTokenBody(RefreshTokenRequestBody)
         */
        default Builder refreshTokenBody(Consumer<RefreshTokenRequestBody.Builder> refreshTokenBody) {
            return refreshTokenBody(RefreshTokenRequestBody.builder().applyMutation(refreshTokenBody).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyUiBuilderRequest.BuilderImpl implements Builder {
        private String provider;

        private RefreshTokenRequestBody refreshTokenBody;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshTokenRequest model) {
            super(model);
            provider(model.provider);
            refreshTokenBody(model.refreshTokenBody);
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(TokenProviders provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final RefreshTokenRequestBody.Builder getRefreshTokenBody() {
            return refreshTokenBody != null ? refreshTokenBody.toBuilder() : null;
        }

        public final void setRefreshTokenBody(RefreshTokenRequestBody.BuilderImpl refreshTokenBody) {
            this.refreshTokenBody = refreshTokenBody != null ? refreshTokenBody.build() : null;
        }

        @Override
        public final Builder refreshTokenBody(RefreshTokenRequestBody refreshTokenBody) {
            this.refreshTokenBody = refreshTokenBody;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RefreshTokenRequest build() {
            return new RefreshTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
