/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates and saves all of the information about a component, based on component ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateComponentData implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateComponentData.Builder, UpdateComponentData> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateComponentData::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateComponentData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceId").getter(getter(UpdateComponentData::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceId").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentType").getter(getter(UpdateComponentData::componentType))
            .setter(setter(Builder::componentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentType").build()).build();

    private static final SdkField<Map<String, ComponentProperty>> PROPERTIES_FIELD = SdkField
            .<Map<String, ComponentProperty>> builder(MarshallingType.MAP)
            .memberName("properties")
            .getter(getter(UpdateComponentData::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ComponentChild>> CHILDREN_FIELD = SdkField
            .<List<ComponentChild>> builder(MarshallingType.LIST)
            .memberName("children")
            .getter(getter(UpdateComponentData::children))
            .setter(setter(Builder::children))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("children").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentChild> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentChild::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ComponentVariant>> VARIANTS_FIELD = SdkField
            .<List<ComponentVariant>> builder(MarshallingType.LIST)
            .memberName("variants")
            .getter(getter(UpdateComponentData::variants))
            .setter(setter(Builder::variants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentVariant> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentVariant::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, Map<String, String>>> OVERRIDES_FIELD = SdkField
            .<Map<String, Map<String, String>>> builder(MarshallingType.MAP)
            .memberName("overrides")
            .getter(getter(UpdateComponentData::overrides))
            .setter(setter(Builder::overrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, ComponentBindingPropertiesValue>> BINDING_PROPERTIES_FIELD = SdkField
            .<Map<String, ComponentBindingPropertiesValue>> builder(MarshallingType.MAP)
            .memberName("bindingProperties")
            .getter(getter(UpdateComponentData::bindingProperties))
            .setter(setter(Builder::bindingProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindingProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentBindingPropertiesValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentBindingPropertiesValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ComponentDataConfiguration>> COLLECTION_PROPERTIES_FIELD = SdkField
            .<Map<String, ComponentDataConfiguration>> builder(MarshallingType.MAP)
            .memberName("collectionProperties")
            .getter(getter(UpdateComponentData::collectionProperties))
            .setter(setter(Builder::collectionProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentDataConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentDataConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ComponentEvent>> EVENTS_FIELD = SdkField
            .<Map<String, ComponentEvent>> builder(MarshallingType.MAP)
            .memberName("events")
            .getter(getter(UpdateComponentData::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaVersion").getter(getter(UpdateComponentData::schemaVersion))
            .setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            SOURCE_ID_FIELD, COMPONENT_TYPE_FIELD, PROPERTIES_FIELD, CHILDREN_FIELD, VARIANTS_FIELD, OVERRIDES_FIELD,
            BINDING_PROPERTIES_FIELD, COLLECTION_PROPERTIES_FIELD, EVENTS_FIELD, SCHEMA_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String sourceId;

    private final String componentType;

    private final Map<String, ComponentProperty> properties;

    private final List<ComponentChild> children;

    private final List<ComponentVariant> variants;

    private final Map<String, Map<String, String>> overrides;

    private final Map<String, ComponentBindingPropertiesValue> bindingProperties;

    private final Map<String, ComponentDataConfiguration> collectionProperties;

    private final Map<String, ComponentEvent> events;

    private final String schemaVersion;

    private UpdateComponentData(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.sourceId = builder.sourceId;
        this.componentType = builder.componentType;
        this.properties = builder.properties;
        this.children = builder.children;
        this.variants = builder.variants;
        this.overrides = builder.overrides;
        this.bindingProperties = builder.bindingProperties;
        this.collectionProperties = builder.collectionProperties;
        this.events = builder.events;
        this.schemaVersion = builder.schemaVersion;
    }

    /**
     * <p>
     * The unique ID of the component to update.
     * </p>
     * 
     * @return The unique ID of the component to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the component to update.
     * </p>
     * 
     * @return The name of the component to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique ID of the component in its original source system, such as Figma.
     * </p>
     * 
     * @return The unique ID of the component in its original source system, such as Figma.
     */
    public final String sourceId() {
        return sourceId;
    }

    /**
     * <p>
     * The type of the component. This can be an Amplify custom UI component or another custom component.
     * </p>
     * 
     * @return The type of the component. This can be an Amplify custom UI component or another custom component.
     */
    public final String componentType() {
        return componentType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Describes the component's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return Describes the component's properties.
     */
    public final Map<String, ComponentProperty> properties() {
        return properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Children property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChildren() {
        return children != null && !(children instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The components that are instances of the main component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChildren} method.
     * </p>
     * 
     * @return The components that are instances of the main component.
     */
    public final List<ComponentChild> children() {
        return children;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variants property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariants() {
        return variants != null && !(variants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the unique variants of the main component being updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariants} method.
     * </p>
     * 
     * @return A list of the unique variants of the main component being updated.
     */
    public final List<ComponentVariant> variants() {
        return variants;
    }

    /**
     * For responses, this returns true if the service returned a value for the Overrides property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOverrides() {
        return overrides != null && !(overrides instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Describes the properties that can be overriden to customize the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrides} method.
     * </p>
     * 
     * @return Describes the properties that can be overriden to customize the component.
     */
    public final Map<String, Map<String, String>> overrides() {
        return overrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the BindingProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBindingProperties() {
        return bindingProperties != null && !(bindingProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The data binding information for the component's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBindingProperties} method.
     * </p>
     * 
     * @return The data binding information for the component's properties.
     */
    public final Map<String, ComponentBindingPropertiesValue> bindingProperties() {
        return bindingProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the CollectionProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCollectionProperties() {
        return collectionProperties != null && !(collectionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration for binding a component's properties to a data model. Use this for a collection component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollectionProperties} method.
     * </p>
     * 
     * @return The configuration for binding a component's properties to a data model. Use this for a collection
     *         component.
     */
    public final Map<String, ComponentDataConfiguration> collectionProperties() {
        return collectionProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to bind
     * events and actions to components.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you
     *         to bind events and actions to components.
     */
    public final Map<String, ComponentEvent> events() {
        return events;
    }

    /**
     * <p>
     * The schema version of the component when it was imported.
     * </p>
     * 
     * @return The schema version of the component when it was imported.
     */
    public final String schemaVersion() {
        return schemaVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(componentType());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasChildren() ? children() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVariants() ? variants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrides() ? overrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBindingProperties() ? bindingProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCollectionProperties() ? collectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComponentData)) {
            return false;
        }
        UpdateComponentData other = (UpdateComponentData) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(sourceId(), other.sourceId()) && Objects.equals(componentType(), other.componentType())
                && hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties())
                && hasChildren() == other.hasChildren() && Objects.equals(children(), other.children())
                && hasVariants() == other.hasVariants() && Objects.equals(variants(), other.variants())
                && hasOverrides() == other.hasOverrides() && Objects.equals(overrides(), other.overrides())
                && hasBindingProperties() == other.hasBindingProperties()
                && Objects.equals(bindingProperties(), other.bindingProperties())
                && hasCollectionProperties() == other.hasCollectionProperties()
                && Objects.equals(collectionProperties(), other.collectionProperties()) && hasEvents() == other.hasEvents()
                && Objects.equals(events(), other.events()) && Objects.equals(schemaVersion(), other.schemaVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateComponentData").add("Id", id()).add("Name", name()).add("SourceId", sourceId())
                .add("ComponentType", componentType()).add("Properties", hasProperties() ? properties() : null)
                .add("Children", hasChildren() ? children() : null).add("Variants", hasVariants() ? variants() : null)
                .add("Overrides", hasOverrides() ? overrides() : null)
                .add("BindingProperties", hasBindingProperties() ? bindingProperties() : null)
                .add("CollectionProperties", hasCollectionProperties() ? collectionProperties() : null)
                .add("Events", hasEvents() ? events() : null).add("SchemaVersion", schemaVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        case "componentType":
            return Optional.ofNullable(clazz.cast(componentType()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "children":
            return Optional.ofNullable(clazz.cast(children()));
        case "variants":
            return Optional.ofNullable(clazz.cast(variants()));
        case "overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        case "bindingProperties":
            return Optional.ofNullable(clazz.cast(bindingProperties()));
        case "collectionProperties":
            return Optional.ofNullable(clazz.cast(collectionProperties()));
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sourceId", SOURCE_ID_FIELD);
        map.put("componentType", COMPONENT_TYPE_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("children", CHILDREN_FIELD);
        map.put("variants", VARIANTS_FIELD);
        map.put("overrides", OVERRIDES_FIELD);
        map.put("bindingProperties", BINDING_PROPERTIES_FIELD);
        map.put("collectionProperties", COLLECTION_PROPERTIES_FIELD);
        map.put("events", EVENTS_FIELD);
        map.put("schemaVersion", SCHEMA_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateComponentData, T> g) {
        return obj -> g.apply((UpdateComponentData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateComponentData> {
        /**
         * <p>
         * The unique ID of the component to update.
         * </p>
         * 
         * @param id
         *        The unique ID of the component to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the component to update.
         * </p>
         * 
         * @param name
         *        The name of the component to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique ID of the component in its original source system, such as Figma.
         * </p>
         * 
         * @param sourceId
         *        The unique ID of the component in its original source system, such as Figma.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(String sourceId);

        /**
         * <p>
         * The type of the component. This can be an Amplify custom UI component or another custom component.
         * </p>
         * 
         * @param componentType
         *        The type of the component. This can be an Amplify custom UI component or another custom component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentType(String componentType);

        /**
         * <p>
         * Describes the component's properties.
         * </p>
         * 
         * @param properties
         *        Describes the component's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, ComponentProperty> properties);

        /**
         * <p>
         * The components that are instances of the main component.
         * </p>
         * 
         * @param children
         *        The components that are instances of the main component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(Collection<ComponentChild> children);

        /**
         * <p>
         * The components that are instances of the main component.
         * </p>
         * 
         * @param children
         *        The components that are instances of the main component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(ComponentChild... children);

        /**
         * <p>
         * The components that are instances of the main component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild.Builder#build()} is called
         * immediately and its result is passed to {@link #children(List<ComponentChild>)}.
         * 
         * @param children
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChild.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #children(java.util.Collection<ComponentChild>)
         */
        Builder children(Consumer<ComponentChild.Builder>... children);

        /**
         * <p>
         * A list of the unique variants of the main component being updated.
         * </p>
         * 
         * @param variants
         *        A list of the unique variants of the main component being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variants(Collection<ComponentVariant> variants);

        /**
         * <p>
         * A list of the unique variants of the main component being updated.
         * </p>
         * 
         * @param variants
         *        A list of the unique variants of the main component being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variants(ComponentVariant... variants);

        /**
         * <p>
         * A list of the unique variants of the main component being updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariant.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariant.Builder#build()} is called
         * immediately and its result is passed to {@link #variants(List<ComponentVariant>)}.
         * 
         * @param variants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variants(java.util.Collection<ComponentVariant>)
         */
        Builder variants(Consumer<ComponentVariant.Builder>... variants);

        /**
         * <p>
         * Describes the properties that can be overriden to customize the component.
         * </p>
         * 
         * @param overrides
         *        Describes the properties that can be overriden to customize the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(Map<String, ? extends Map<String, String>> overrides);

        /**
         * <p>
         * The data binding information for the component's properties.
         * </p>
         * 
         * @param bindingProperties
         *        The data binding information for the component's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bindingProperties(Map<String, ComponentBindingPropertiesValue> bindingProperties);

        /**
         * <p>
         * The configuration for binding a component's properties to a data model. Use this for a collection component.
         * </p>
         * 
         * @param collectionProperties
         *        The configuration for binding a component's properties to a data model. Use this for a collection
         *        component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionProperties(Map<String, ComponentDataConfiguration> collectionProperties);

        /**
         * <p>
         * The event configuration for the component. Use for the workflow feature in Amplify Studio that allows you to
         * bind events and actions to components.
         * </p>
         * 
         * @param events
         *        The event configuration for the component. Use for the workflow feature in Amplify Studio that allows
         *        you to bind events and actions to components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Map<String, ComponentEvent> events);

        /**
         * <p>
         * The schema version of the component when it was imported.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version of the component when it was imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String sourceId;

        private String componentType;

        private Map<String, ComponentProperty> properties = DefaultSdkAutoConstructMap.getInstance();

        private List<ComponentChild> children = DefaultSdkAutoConstructList.getInstance();

        private List<ComponentVariant> variants = DefaultSdkAutoConstructList.getInstance();

        private Map<String, Map<String, String>> overrides = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ComponentBindingPropertiesValue> bindingProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ComponentDataConfiguration> collectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ComponentEvent> events = DefaultSdkAutoConstructMap.getInstance();

        private String schemaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComponentData model) {
            id(model.id);
            name(model.name);
            sourceId(model.sourceId);
            componentType(model.componentType);
            properties(model.properties);
            children(model.children);
            variants(model.variants);
            overrides(model.overrides);
            bindingProperties(model.bindingProperties);
            collectionProperties(model.collectionProperties);
            events(model.events);
            schemaVersion(model.schemaVersion);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceId() {
            return sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getComponentType() {
            return componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public final Map<String, ComponentProperty.Builder> getProperties() {
            Map<String, ComponentProperty.Builder> result = ComponentPropertiesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, ComponentProperty.BuilderImpl> properties) {
            this.properties = ComponentPropertiesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, ComponentProperty> properties) {
            this.properties = ComponentPropertiesCopier.copy(properties);
            return this;
        }

        public final List<ComponentChild.Builder> getChildren() {
            List<ComponentChild.Builder> result = ComponentChildListCopier.copyToBuilder(this.children);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildren(Collection<ComponentChild.BuilderImpl> children) {
            this.children = ComponentChildListCopier.copyFromBuilder(children);
        }

        @Override
        public final Builder children(Collection<ComponentChild> children) {
            this.children = ComponentChildListCopier.copy(children);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(ComponentChild... children) {
            children(Arrays.asList(children));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Consumer<ComponentChild.Builder>... children) {
            children(Stream.of(children).map(c -> ComponentChild.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ComponentVariant.Builder> getVariants() {
            List<ComponentVariant.Builder> result = ComponentVariantsCopier.copyToBuilder(this.variants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariants(Collection<ComponentVariant.BuilderImpl> variants) {
            this.variants = ComponentVariantsCopier.copyFromBuilder(variants);
        }

        @Override
        public final Builder variants(Collection<ComponentVariant> variants) {
            this.variants = ComponentVariantsCopier.copy(variants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(ComponentVariant... variants) {
            variants(Arrays.asList(variants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(Consumer<ComponentVariant.Builder>... variants) {
            variants(Stream.of(variants).map(c -> ComponentVariant.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getOverrides() {
            if (overrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return overrides;
        }

        public final void setOverrides(Map<String, ? extends Map<String, String>> overrides) {
            this.overrides = ComponentOverridesCopier.copy(overrides);
        }

        @Override
        public final Builder overrides(Map<String, ? extends Map<String, String>> overrides) {
            this.overrides = ComponentOverridesCopier.copy(overrides);
            return this;
        }

        public final Map<String, ComponentBindingPropertiesValue.Builder> getBindingProperties() {
            Map<String, ComponentBindingPropertiesValue.Builder> result = ComponentBindingPropertiesCopier
                    .copyToBuilder(this.bindingProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBindingProperties(Map<String, ComponentBindingPropertiesValue.BuilderImpl> bindingProperties) {
            this.bindingProperties = ComponentBindingPropertiesCopier.copyFromBuilder(bindingProperties);
        }

        @Override
        public final Builder bindingProperties(Map<String, ComponentBindingPropertiesValue> bindingProperties) {
            this.bindingProperties = ComponentBindingPropertiesCopier.copy(bindingProperties);
            return this;
        }

        public final Map<String, ComponentDataConfiguration.Builder> getCollectionProperties() {
            Map<String, ComponentDataConfiguration.Builder> result = ComponentCollectionPropertiesCopier
                    .copyToBuilder(this.collectionProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCollectionProperties(Map<String, ComponentDataConfiguration.BuilderImpl> collectionProperties) {
            this.collectionProperties = ComponentCollectionPropertiesCopier.copyFromBuilder(collectionProperties);
        }

        @Override
        public final Builder collectionProperties(Map<String, ComponentDataConfiguration> collectionProperties) {
            this.collectionProperties = ComponentCollectionPropertiesCopier.copy(collectionProperties);
            return this;
        }

        public final Map<String, ComponentEvent.Builder> getEvents() {
            Map<String, ComponentEvent.Builder> result = ComponentEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEvents(Map<String, ComponentEvent.BuilderImpl> events) {
            this.events = ComponentEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Map<String, ComponentEvent> events) {
            this.events = ComponentEventsCopier.copy(events);
            return this;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public UpdateComponentData build() {
            return new UpdateComponentData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
