/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateComponentResponse extends AmplifyUiBuilderResponse implements
        ToCopyableBuilder<UpdateComponentResponse.Builder, UpdateComponentResponse> {
    private static final SdkField<Component> ENTITY_FIELD = SdkField
            .<Component> builder(MarshallingType.SDK_POJO)
            .memberName("entity")
            .getter(getter(UpdateComponentResponse::entity))
            .setter(setter(Builder::entity))
            .constructor(Component::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entity").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Component entity;

    private UpdateComponentResponse(BuilderImpl builder) {
        super(builder);
        this.entity = builder.entity;
    }

    /**
     * <p>
     * Describes the configuration of the updated component.
     * </p>
     * 
     * @return Describes the configuration of the updated component.
     */
    public final Component entity() {
        return entity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComponentResponse)) {
            return false;
        }
        UpdateComponentResponse other = (UpdateComponentResponse) obj;
        return Objects.equals(entity(), other.entity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateComponentResponse").add("Entity", entity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entity":
            return Optional.ofNullable(clazz.cast(entity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entity", ENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateComponentResponse, T> g) {
        return obj -> g.apply((UpdateComponentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyUiBuilderResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateComponentResponse> {
        /**
         * <p>
         * Describes the configuration of the updated component.
         * </p>
         * 
         * @param entity
         *        Describes the configuration of the updated component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entity(Component entity);

        /**
         * <p>
         * Describes the configuration of the updated component.
         * </p>
         * This is a convenience method that creates an instance of the {@link Component.Builder} avoiding the need to
         * create one manually via {@link Component#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Component.Builder#build()} is called immediately and its result
         * is passed to {@link #entity(Component)}.
         * 
         * @param entity
         *        a consumer that will call methods on {@link Component.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entity(Component)
         */
        default Builder entity(Consumer<Component.Builder> entity) {
            return entity(Component.builder().applyMutation(entity).build());
        }
    }

    static final class BuilderImpl extends AmplifyUiBuilderResponse.BuilderImpl implements Builder {
        private Component entity;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComponentResponse model) {
            super(model);
            entity(model.entity);
        }

        public final Component.Builder getEntity() {
            return entity != null ? entity.toBuilder() : null;
        }

        public final void setEntity(Component.BuilderImpl entity) {
            this.entity = entity != null ? entity.build() : null;
        }

        @Override
        public final Builder entity(Component entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public UpdateComponentResponse build() {
            return new UpdateComponentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
