/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentChildListCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentEvent;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentEventsCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertiesCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentChild
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentChild> {
    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentType").getter(ComponentChild.getter(ComponentChild::componentType)).setter(ComponentChild.setter(Builder::componentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ComponentChild.getter(ComponentChild::name)).setter(ComponentChild.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, ComponentProperty>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("properties").getter(ComponentChild.getter(ComponentChild::properties)).setter(ComponentChild.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ComponentChild>> CHILDREN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("children").getter(ComponentChild.getter(ComponentChild::children)).setter(ComponentChild.setter(Builder::children)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("children").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentChild::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ComponentEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("events").getter(ComponentChild.getter(ComponentChild::events)).setter(ComponentChild.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceId").getter(ComponentChild.getter(ComponentChild::sourceId)).setter(ComponentChild.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_TYPE_FIELD, NAME_FIELD, PROPERTIES_FIELD, CHILDREN_FIELD, EVENTS_FIELD, SOURCE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentChild.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String componentType;
    private final String name;
    private final Map<String, ComponentProperty> properties;
    private final List<ComponentChild> children;
    private final Map<String, ComponentEvent> events;
    private final String sourceId;

    private ComponentChild(BuilderImpl builder) {
        this.componentType = builder.componentType;
        this.name = builder.name;
        this.properties = builder.properties;
        this.children = builder.children;
        this.events = builder.events;
        this.sourceId = builder.sourceId;
    }

    public final String componentType() {
        return this.componentType;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentProperty> properties() {
        return this.properties;
    }

    public final boolean hasChildren() {
        return this.children != null && !(this.children instanceof SdkAutoConstructList);
    }

    public final List<ComponentChild> children() {
        return this.children;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentEvent> events() {
        return this.events;
    }

    public final String sourceId() {
        return this.sourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildren() ? this.children() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentChild)) {
            return false;
        }
        ComponentChild other = (ComponentChild)obj;
        return Objects.equals(this.componentType(), other.componentType()) && Objects.equals(this.name(), other.name()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && this.hasChildren() == other.hasChildren() && Objects.equals(this.children(), other.children()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events()) && Objects.equals(this.sourceId(), other.sourceId());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentChild").add("ComponentType", (Object)this.componentType()).add("Name", (Object)this.name()).add("Properties", this.hasProperties() ? this.properties() : null).add("Children", this.hasChildren() ? this.children() : null).add("Events", this.hasEvents() ? this.events() : null).add("SourceId", (Object)this.sourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentType": {
                return Optional.ofNullable(clazz.cast(this.componentType()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "children": {
                return Optional.ofNullable(clazz.cast(this.children()));
            }
            case "events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "sourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("componentType", COMPONENT_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("children", CHILDREN_FIELD);
        map.put("events", EVENTS_FIELD);
        map.put("sourceId", SOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentChild, T> g) {
        return obj -> g.apply((ComponentChild)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentType;
        private String name;
        private Map<String, ComponentProperty> properties = DefaultSdkAutoConstructMap.getInstance();
        private List<ComponentChild> children = DefaultSdkAutoConstructList.getInstance();
        private Map<String, ComponentEvent> events = DefaultSdkAutoConstructMap.getInstance();
        private String sourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentChild model) {
            this.componentType(model.componentType);
            this.name(model.name);
            this.properties(model.properties);
            this.children(model.children);
            this.events(model.events);
            this.sourceId(model.sourceId);
        }

        public final String getComponentType() {
            return this.componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, ComponentProperty.Builder> getProperties() {
            Map<String, ComponentProperty.Builder> result = ComponentPropertiesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, ComponentProperty.BuilderImpl> properties) {
            this.properties = ComponentPropertiesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, ComponentProperty> properties) {
            this.properties = ComponentPropertiesCopier.copy(properties);
            return this;
        }

        public final List<Builder> getChildren() {
            List<Builder> result = ComponentChildListCopier.copyToBuilder(this.children);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildren(Collection<BuilderImpl> children) {
            this.children = ComponentChildListCopier.copyFromBuilder(children);
        }

        @Override
        public final Builder children(Collection<ComponentChild> children) {
            this.children = ComponentChildListCopier.copy(children);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(ComponentChild ... children) {
            this.children(Arrays.asList(children));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Consumer<Builder> ... children) {
            this.children(Stream.of(children).map(c -> (ComponentChild)((Builder)ComponentChild.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, ComponentEvent.Builder> getEvents() {
            Map<String, ComponentEvent.Builder> result = ComponentEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEvents(Map<String, ComponentEvent.BuilderImpl> events) {
            this.events = ComponentEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Map<String, ComponentEvent> events) {
            this.events = ComponentEventsCopier.copy(events);
            return this;
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public ComponentChild build() {
            return new ComponentChild(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentChild> {
        public Builder componentType(String var1);

        public Builder name(String var1);

        public Builder properties(Map<String, ComponentProperty> var1);

        public Builder children(Collection<ComponentChild> var1);

        public Builder children(ComponentChild ... var1);

        public Builder children(Consumer<Builder> ... var1);

        public Builder events(Map<String, ComponentEvent> var1);

        public Builder sourceId(String var1);
    }
}

