/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the event action configuration for an element of a <code>Component</code> or <code>ComponentChild</code>.
 * Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
 * <code>ActionParameters</code> defines the action that is performed when an event occurs on the component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionParameters.Builder, ActionParameters> {
    private static final SdkField<ComponentProperty> TYPE_FIELD = SdkField.<ComponentProperty> builder(MarshallingType.SDK_POJO)
            .memberName("type").getter(getter(ActionParameters::type)).setter(setter(Builder::type))
            .constructor(ComponentProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<ComponentProperty> URL_FIELD = SdkField.<ComponentProperty> builder(MarshallingType.SDK_POJO)
            .memberName("url").getter(getter(ActionParameters::url)).setter(setter(Builder::url))
            .constructor(ComponentProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<ComponentProperty> ANCHOR_FIELD = SdkField
            .<ComponentProperty> builder(MarshallingType.SDK_POJO).memberName("anchor").getter(getter(ActionParameters::anchor))
            .setter(setter(Builder::anchor)).constructor(ComponentProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anchor").build()).build();

    private static final SdkField<ComponentProperty> TARGET_FIELD = SdkField
            .<ComponentProperty> builder(MarshallingType.SDK_POJO).memberName("target").getter(getter(ActionParameters::target))
            .setter(setter(Builder::target)).constructor(ComponentProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<ComponentProperty> GLOBAL_FIELD = SdkField
            .<ComponentProperty> builder(MarshallingType.SDK_POJO).memberName("global").getter(getter(ActionParameters::global))
            .setter(setter(Builder::global)).constructor(ComponentProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("global").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("model")
            .getter(getter(ActionParameters::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()).build();

    private static final SdkField<ComponentProperty> ID_FIELD = SdkField.<ComponentProperty> builder(MarshallingType.SDK_POJO)
            .memberName("id").getter(getter(ActionParameters::id)).setter(setter(Builder::id))
            .constructor(ComponentProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Map<String, ComponentProperty>> FIELDS_FIELD = SdkField
            .<Map<String, ComponentProperty>> builder(MarshallingType.MAP)
            .memberName("fields")
            .getter(getter(ActionParameters::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<MutationActionSetStateParameter> STATE_FIELD = SdkField
            .<MutationActionSetStateParameter> builder(MarshallingType.SDK_POJO).memberName("state")
            .getter(getter(ActionParameters::state)).setter(setter(Builder::state))
            .constructor(MutationActionSetStateParameter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, URL_FIELD,
            ANCHOR_FIELD, TARGET_FIELD, GLOBAL_FIELD, MODEL_FIELD, ID_FIELD, FIELDS_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ComponentProperty type;

    private final ComponentProperty url;

    private final ComponentProperty anchor;

    private final ComponentProperty target;

    private final ComponentProperty global;

    private final String model;

    private final ComponentProperty id;

    private final Map<String, ComponentProperty> fields;

    private final MutationActionSetStateParameter state;

    private ActionParameters(BuilderImpl builder) {
        this.type = builder.type;
        this.url = builder.url;
        this.anchor = builder.anchor;
        this.target = builder.target;
        this.global = builder.global;
        this.model = builder.model;
        this.id = builder.id;
        this.fields = builder.fields;
        this.state = builder.state;
    }

    /**
     * <p>
     * The type of navigation action. Valid values are <code>url</code> and <code>anchor</code>. This value is required
     * for a navigation action.
     * </p>
     * 
     * @return The type of navigation action. Valid values are <code>url</code> and <code>anchor</code>. This value is
     *         required for a navigation action.
     */
    public final ComponentProperty type() {
        return type;
    }

    /**
     * <p>
     * The URL to the location to open. Specify this value for a navigation action.
     * </p>
     * 
     * @return The URL to the location to open. Specify this value for a navigation action.
     */
    public final ComponentProperty url() {
        return url;
    }

    /**
     * <p>
     * The HTML anchor link to the location to open. Specify this value for a navigation action.
     * </p>
     * 
     * @return The HTML anchor link to the location to open. Specify this value for a navigation action.
     */
    public final ComponentProperty anchor() {
        return anchor;
    }

    /**
     * <p>
     * The element within the same component to modify when the action occurs.
     * </p>
     * 
     * @return The element within the same component to modify when the action occurs.
     */
    public final ComponentProperty target() {
        return target;
    }

    /**
     * <p>
     * Specifies whether the user should be signed out globally. Specify this value for an auth sign out action.
     * </p>
     * 
     * @return Specifies whether the user should be signed out globally. Specify this value for an auth sign out action.
     */
    public final ComponentProperty global() {
        return global;
    }

    /**
     * <p>
     * The name of the data model. Use when the action performs an operation on an Amplify DataStore model.
     * </p>
     * 
     * @return The name of the data model. Use when the action performs an operation on an Amplify DataStore model.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The unique ID of the component that the <code>ActionParameters</code> apply to.
     * </p>
     * 
     * @return The unique ID of the component that the <code>ActionParameters</code> apply to.
     */
    public final ComponentProperty id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A dictionary of key-value pairs mapping Amplify Studio properties to fields in a data model. Use when the action
     * performs an operation on an Amplify DataStore model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return A dictionary of key-value pairs mapping Amplify Studio properties to fields in a data model. Use when the
     *         action performs an operation on an Amplify DataStore model.
     */
    public final Map<String, ComponentProperty> fields() {
        return fields;
    }

    /**
     * <p>
     * A key-value pair that specifies the state property name and its initial value.
     * </p>
     * 
     * @return A key-value pair that specifies the state property name and its initial value.
     */
    public final MutationActionSetStateParameter state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(anchor());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(global());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionParameters)) {
            return false;
        }
        ActionParameters other = (ActionParameters) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(url(), other.url())
                && Objects.equals(anchor(), other.anchor()) && Objects.equals(target(), other.target())
                && Objects.equals(global(), other.global()) && Objects.equals(model(), other.model())
                && Objects.equals(id(), other.id()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionParameters").add("Type", type()).add("Url", url()).add("Anchor", anchor())
                .add("Target", target()).add("Global", global()).add("Model", model()).add("Id", id())
                .add("Fields", hasFields() ? fields() : null).add("State", state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "anchor":
            return Optional.ofNullable(clazz.cast(anchor()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "global":
            return Optional.ofNullable(clazz.cast(global()));
        case "model":
            return Optional.ofNullable(clazz.cast(model()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("url", URL_FIELD);
        map.put("anchor", ANCHOR_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("global", GLOBAL_FIELD);
        map.put("model", MODEL_FIELD);
        map.put("id", ID_FIELD);
        map.put("fields", FIELDS_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionParameters, T> g) {
        return obj -> g.apply((ActionParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionParameters> {
        /**
         * <p>
         * The type of navigation action. Valid values are <code>url</code> and <code>anchor</code>. This value is
         * required for a navigation action.
         * </p>
         * 
         * @param type
         *        The type of navigation action. Valid values are <code>url</code> and <code>anchor</code>. This value
         *        is required for a navigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(ComponentProperty type);

        /**
         * <p>
         * The type of navigation action. Valid values are <code>url</code> and <code>anchor</code>. This value is
         * required for a navigation action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentProperty.Builder} avoiding the
         * need to create one manually via {@link ComponentProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentProperty.Builder#build()} is called immediately and its
         * result is passed to {@link #type(ComponentProperty)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link ComponentProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(ComponentProperty)
         */
        default Builder type(Consumer<ComponentProperty.Builder> type) {
            return type(ComponentProperty.builder().applyMutation(type).build());
        }

        /**
         * <p>
         * The URL to the location to open. Specify this value for a navigation action.
         * </p>
         * 
         * @param url
         *        The URL to the location to open. Specify this value for a navigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(ComponentProperty url);

        /**
         * <p>
         * The URL to the location to open. Specify this value for a navigation action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentProperty.Builder} avoiding the
         * need to create one manually via {@link ComponentProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentProperty.Builder#build()} is called immediately and its
         * result is passed to {@link #url(ComponentProperty)}.
         * 
         * @param url
         *        a consumer that will call methods on {@link ComponentProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #url(ComponentProperty)
         */
        default Builder url(Consumer<ComponentProperty.Builder> url) {
            return url(ComponentProperty.builder().applyMutation(url).build());
        }

        /**
         * <p>
         * The HTML anchor link to the location to open. Specify this value for a navigation action.
         * </p>
         * 
         * @param anchor
         *        The HTML anchor link to the location to open. Specify this value for a navigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anchor(ComponentProperty anchor);

        /**
         * <p>
         * The HTML anchor link to the location to open. Specify this value for a navigation action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentProperty.Builder} avoiding the
         * need to create one manually via {@link ComponentProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentProperty.Builder#build()} is called immediately and its
         * result is passed to {@link #anchor(ComponentProperty)}.
         * 
         * @param anchor
         *        a consumer that will call methods on {@link ComponentProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anchor(ComponentProperty)
         */
        default Builder anchor(Consumer<ComponentProperty.Builder> anchor) {
            return anchor(ComponentProperty.builder().applyMutation(anchor).build());
        }

        /**
         * <p>
         * The element within the same component to modify when the action occurs.
         * </p>
         * 
         * @param target
         *        The element within the same component to modify when the action occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(ComponentProperty target);

        /**
         * <p>
         * The element within the same component to modify when the action occurs.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentProperty.Builder} avoiding the
         * need to create one manually via {@link ComponentProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentProperty.Builder#build()} is called immediately and its
         * result is passed to {@link #target(ComponentProperty)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link ComponentProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(ComponentProperty)
         */
        default Builder target(Consumer<ComponentProperty.Builder> target) {
            return target(ComponentProperty.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * Specifies whether the user should be signed out globally. Specify this value for an auth sign out action.
         * </p>
         * 
         * @param global
         *        Specifies whether the user should be signed out globally. Specify this value for an auth sign out
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder global(ComponentProperty global);

        /**
         * <p>
         * Specifies whether the user should be signed out globally. Specify this value for an auth sign out action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentProperty.Builder} avoiding the
         * need to create one manually via {@link ComponentProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentProperty.Builder#build()} is called immediately and its
         * result is passed to {@link #global(ComponentProperty)}.
         * 
         * @param global
         *        a consumer that will call methods on {@link ComponentProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #global(ComponentProperty)
         */
        default Builder global(Consumer<ComponentProperty.Builder> global) {
            return global(ComponentProperty.builder().applyMutation(global).build());
        }

        /**
         * <p>
         * The name of the data model. Use when the action performs an operation on an Amplify DataStore model.
         * </p>
         * 
         * @param model
         *        The name of the data model. Use when the action performs an operation on an Amplify DataStore model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The unique ID of the component that the <code>ActionParameters</code> apply to.
         * </p>
         * 
         * @param id
         *        The unique ID of the component that the <code>ActionParameters</code> apply to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(ComponentProperty id);

        /**
         * <p>
         * The unique ID of the component that the <code>ActionParameters</code> apply to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentProperty.Builder} avoiding the
         * need to create one manually via {@link ComponentProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentProperty.Builder#build()} is called immediately and its
         * result is passed to {@link #id(ComponentProperty)}.
         * 
         * @param id
         *        a consumer that will call methods on {@link ComponentProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #id(ComponentProperty)
         */
        default Builder id(Consumer<ComponentProperty.Builder> id) {
            return id(ComponentProperty.builder().applyMutation(id).build());
        }

        /**
         * <p>
         * A dictionary of key-value pairs mapping Amplify Studio properties to fields in a data model. Use when the
         * action performs an operation on an Amplify DataStore model.
         * </p>
         * 
         * @param fields
         *        A dictionary of key-value pairs mapping Amplify Studio properties to fields in a data model. Use when
         *        the action performs an operation on an Amplify DataStore model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Map<String, ComponentProperty> fields);

        /**
         * <p>
         * A key-value pair that specifies the state property name and its initial value.
         * </p>
         * 
         * @param state
         *        A key-value pair that specifies the state property name and its initial value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(MutationActionSetStateParameter state);

        /**
         * <p>
         * A key-value pair that specifies the state property name and its initial value.
         * </p>
         * This is a convenience method that creates an instance of the {@link MutationActionSetStateParameter.Builder}
         * avoiding the need to create one manually via {@link MutationActionSetStateParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MutationActionSetStateParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #state(MutationActionSetStateParameter)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link MutationActionSetStateParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(MutationActionSetStateParameter)
         */
        default Builder state(Consumer<MutationActionSetStateParameter.Builder> state) {
            return state(MutationActionSetStateParameter.builder().applyMutation(state).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ComponentProperty type;

        private ComponentProperty url;

        private ComponentProperty anchor;

        private ComponentProperty target;

        private ComponentProperty global;

        private String model;

        private ComponentProperty id;

        private Map<String, ComponentProperty> fields = DefaultSdkAutoConstructMap.getInstance();

        private MutationActionSetStateParameter state;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionParameters model) {
            type(model.type);
            url(model.url);
            anchor(model.anchor);
            target(model.target);
            global(model.global);
            model(model.model);
            id(model.id);
            fields(model.fields);
            state(model.state);
        }

        public final ComponentProperty.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(ComponentProperty.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(ComponentProperty type) {
            this.type = type;
            return this;
        }

        public final ComponentProperty.Builder getUrl() {
            return url != null ? url.toBuilder() : null;
        }

        public final void setUrl(ComponentProperty.BuilderImpl url) {
            this.url = url != null ? url.build() : null;
        }

        @Override
        public final Builder url(ComponentProperty url) {
            this.url = url;
            return this;
        }

        public final ComponentProperty.Builder getAnchor() {
            return anchor != null ? anchor.toBuilder() : null;
        }

        public final void setAnchor(ComponentProperty.BuilderImpl anchor) {
            this.anchor = anchor != null ? anchor.build() : null;
        }

        @Override
        public final Builder anchor(ComponentProperty anchor) {
            this.anchor = anchor;
            return this;
        }

        public final ComponentProperty.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(ComponentProperty.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(ComponentProperty target) {
            this.target = target;
            return this;
        }

        public final ComponentProperty.Builder getGlobal() {
            return global != null ? global.toBuilder() : null;
        }

        public final void setGlobal(ComponentProperty.BuilderImpl global) {
            this.global = global != null ? global.build() : null;
        }

        @Override
        public final Builder global(ComponentProperty global) {
            this.global = global;
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final ComponentProperty.Builder getId() {
            return id != null ? id.toBuilder() : null;
        }

        public final void setId(ComponentProperty.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        @Override
        public final Builder id(ComponentProperty id) {
            this.id = id;
            return this;
        }

        public final Map<String, ComponentProperty.Builder> getFields() {
            Map<String, ComponentProperty.Builder> result = ComponentPropertiesCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, ComponentProperty.BuilderImpl> fields) {
            this.fields = ComponentPropertiesCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Map<String, ComponentProperty> fields) {
            this.fields = ComponentPropertiesCopier.copy(fields);
            return this;
        }

        public final MutationActionSetStateParameter.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(MutationActionSetStateParameter.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(MutationActionSetStateParameter state) {
            this.state = state;
            return this;
        }

        @Override
        public ActionParameters build() {
            return new ActionParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
