/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a field in a generic data schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodegenGenericDataField implements SdkPojo, Serializable,
        ToCopyableBuilder<CodegenGenericDataField.Builder, CodegenGenericDataField> {
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(CodegenGenericDataField::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> DATA_TYPE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataTypeValue").getter(getter(CodegenGenericDataField::dataTypeValue))
            .setter(setter(Builder::dataTypeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTypeValue").build()).build();

    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("required").getter(getter(CodegenGenericDataField::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("readOnly").getter(getter(CodegenGenericDataField::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnly").build()).build();

    private static final SdkField<Boolean> IS_ARRAY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isArray").getter(getter(CodegenGenericDataField::isArray)).setter(setter(Builder::isArray))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArray").build()).build();

    private static final SdkField<CodegenGenericDataRelationshipType> RELATIONSHIP_FIELD = SdkField
            .<CodegenGenericDataRelationshipType> builder(MarshallingType.SDK_POJO).memberName("relationship")
            .getter(getter(CodegenGenericDataField::relationship)).setter(setter(Builder::relationship))
            .constructor(CodegenGenericDataRelationshipType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationship").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TYPE_FIELD,
            DATA_TYPE_VALUE_FIELD, REQUIRED_FIELD, READ_ONLY_FIELD, IS_ARRAY_FIELD, RELATIONSHIP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataType;

    private final String dataTypeValue;

    private final Boolean required;

    private final Boolean readOnly;

    private final Boolean isArray;

    private final CodegenGenericDataRelationshipType relationship;

    private CodegenGenericDataField(BuilderImpl builder) {
        this.dataType = builder.dataType;
        this.dataTypeValue = builder.dataTypeValue;
        this.required = builder.required;
        this.readOnly = builder.readOnly;
        this.isArray = builder.isArray;
        this.relationship = builder.relationship;
    }

    /**
     * <p>
     * The data type for the generic data field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link CodegenGenericDataFieldDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type for the generic data field.
     * @see CodegenGenericDataFieldDataType
     */
    public final CodegenGenericDataFieldDataType dataType() {
        return CodegenGenericDataFieldDataType.fromValue(dataType);
    }

    /**
     * <p>
     * The data type for the generic data field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link CodegenGenericDataFieldDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type for the generic data field.
     * @see CodegenGenericDataFieldDataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * The value of the data type for the generic data field.
     * </p>
     * 
     * @return The value of the data type for the generic data field.
     */
    public final String dataTypeValue() {
        return dataTypeValue;
    }

    /**
     * <p>
     * Specifies whether the generic data field is required.
     * </p>
     * 
     * @return Specifies whether the generic data field is required.
     */
    public final Boolean required() {
        return required;
    }

    /**
     * <p>
     * Specifies whether the generic data field is read-only.
     * </p>
     * 
     * @return Specifies whether the generic data field is read-only.
     */
    public final Boolean readOnly() {
        return readOnly;
    }

    /**
     * <p>
     * Specifies whether the generic data field is an array.
     * </p>
     * 
     * @return Specifies whether the generic data field is an array.
     */
    public final Boolean isArray() {
        return isArray;
    }

    /**
     * <p>
     * The relationship of the generic data schema.
     * </p>
     * 
     * @return The relationship of the generic data schema.
     */
    public final CodegenGenericDataRelationshipType relationship() {
        return relationship;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeValue());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(isArray());
        hashCode = 31 * hashCode + Objects.hashCode(relationship());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodegenGenericDataField)) {
            return false;
        }
        CodegenGenericDataField other = (CodegenGenericDataField) obj;
        return Objects.equals(dataTypeAsString(), other.dataTypeAsString())
                && Objects.equals(dataTypeValue(), other.dataTypeValue()) && Objects.equals(required(), other.required())
                && Objects.equals(readOnly(), other.readOnly()) && Objects.equals(isArray(), other.isArray())
                && Objects.equals(relationship(), other.relationship());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodegenGenericDataField").add("DataType", dataTypeAsString())
                .add("DataTypeValue", dataTypeValue()).add("Required", required()).add("ReadOnly", readOnly())
                .add("IsArray", isArray()).add("Relationship", relationship()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "dataTypeValue":
            return Optional.ofNullable(clazz.cast(dataTypeValue()));
        case "required":
            return Optional.ofNullable(clazz.cast(required()));
        case "readOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        case "isArray":
            return Optional.ofNullable(clazz.cast(isArray()));
        case "relationship":
            return Optional.ofNullable(clazz.cast(relationship()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("dataTypeValue", DATA_TYPE_VALUE_FIELD);
        map.put("required", REQUIRED_FIELD);
        map.put("readOnly", READ_ONLY_FIELD);
        map.put("isArray", IS_ARRAY_FIELD);
        map.put("relationship", RELATIONSHIP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodegenGenericDataField, T> g) {
        return obj -> g.apply((CodegenGenericDataField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodegenGenericDataField> {
        /**
         * <p>
         * The data type for the generic data field.
         * </p>
         * 
         * @param dataType
         *        The data type for the generic data field.
         * @see CodegenGenericDataFieldDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodegenGenericDataFieldDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data type for the generic data field.
         * </p>
         * 
         * @param dataType
         *        The data type for the generic data field.
         * @see CodegenGenericDataFieldDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodegenGenericDataFieldDataType
         */
        Builder dataType(CodegenGenericDataFieldDataType dataType);

        /**
         * <p>
         * The value of the data type for the generic data field.
         * </p>
         * 
         * @param dataTypeValue
         *        The value of the data type for the generic data field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTypeValue(String dataTypeValue);

        /**
         * <p>
         * Specifies whether the generic data field is required.
         * </p>
         * 
         * @param required
         *        Specifies whether the generic data field is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);

        /**
         * <p>
         * Specifies whether the generic data field is read-only.
         * </p>
         * 
         * @param readOnly
         *        Specifies whether the generic data field is read-only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);

        /**
         * <p>
         * Specifies whether the generic data field is an array.
         * </p>
         * 
         * @param isArray
         *        Specifies whether the generic data field is an array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isArray(Boolean isArray);

        /**
         * <p>
         * The relationship of the generic data schema.
         * </p>
         * 
         * @param relationship
         *        The relationship of the generic data schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationship(CodegenGenericDataRelationshipType relationship);

        /**
         * <p>
         * The relationship of the generic data schema.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CodegenGenericDataRelationshipType.Builder} avoiding the need to create one manually via
         * {@link CodegenGenericDataRelationshipType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodegenGenericDataRelationshipType.Builder#build()} is called
         * immediately and its result is passed to {@link #relationship(CodegenGenericDataRelationshipType)}.
         * 
         * @param relationship
         *        a consumer that will call methods on {@link CodegenGenericDataRelationshipType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationship(CodegenGenericDataRelationshipType)
         */
        default Builder relationship(Consumer<CodegenGenericDataRelationshipType.Builder> relationship) {
            return relationship(CodegenGenericDataRelationshipType.builder().applyMutation(relationship).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dataType;

        private String dataTypeValue;

        private Boolean required;

        private Boolean readOnly;

        private Boolean isArray;

        private CodegenGenericDataRelationshipType relationship;

        private BuilderImpl() {
        }

        private BuilderImpl(CodegenGenericDataField model) {
            dataType(model.dataType);
            dataTypeValue(model.dataTypeValue);
            required(model.required);
            readOnly(model.readOnly);
            isArray(model.isArray);
            relationship(model.relationship);
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(CodegenGenericDataFieldDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDataTypeValue() {
            return dataTypeValue;
        }

        public final void setDataTypeValue(String dataTypeValue) {
            this.dataTypeValue = dataTypeValue;
        }

        @Override
        public final Builder dataTypeValue(String dataTypeValue) {
            this.dataTypeValue = dataTypeValue;
            return this;
        }

        public final Boolean getRequired() {
            return required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final Boolean getIsArray() {
            return isArray;
        }

        public final void setIsArray(Boolean isArray) {
            this.isArray = isArray;
        }

        @Override
        public final Builder isArray(Boolean isArray) {
            this.isArray = isArray;
            return this;
        }

        public final CodegenGenericDataRelationshipType.Builder getRelationship() {
            return relationship != null ? relationship.toBuilder() : null;
        }

        public final void setRelationship(CodegenGenericDataRelationshipType.BuilderImpl relationship) {
            this.relationship = relationship != null ? relationship.build() : null;
        }

        @Override
        public final Builder relationship(CodegenGenericDataRelationshipType relationship) {
            this.relationship = relationship;
            return this;
        }

        @Override
        public CodegenGenericDataField build() {
            return new CodegenGenericDataField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
