/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration for a code generation job that is associated with an Amplify app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodegenJob implements SdkPojo, Serializable, ToCopyableBuilder<CodegenJob.Builder, CodegenJob> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CodegenJob::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(CodegenJob::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(CodegenJob::environmentName)).setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<CodegenJobRenderConfig> RENDER_CONFIG_FIELD = SdkField
            .<CodegenJobRenderConfig> builder(MarshallingType.SDK_POJO).memberName("renderConfig")
            .getter(getter(CodegenJob::renderConfig)).setter(setter(Builder::renderConfig))
            .constructor(CodegenJobRenderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderConfig").build()).build();

    private static final SdkField<CodegenJobGenericDataSchema> GENERIC_DATA_SCHEMA_FIELD = SdkField
            .<CodegenJobGenericDataSchema> builder(MarshallingType.SDK_POJO).memberName("genericDataSchema")
            .getter(getter(CodegenJob::genericDataSchema)).setter(setter(Builder::genericDataSchema))
            .constructor(CodegenJobGenericDataSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("genericDataSchema").build()).build();

    private static final SdkField<Boolean> AUTO_GENERATE_FORMS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoGenerateForms").getter(getter(CodegenJob::autoGenerateForms))
            .setter(setter(Builder::autoGenerateForms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoGenerateForms").build()).build();

    private static final SdkField<CodegenFeatureFlags> FEATURES_FIELD = SdkField
            .<CodegenFeatureFlags> builder(MarshallingType.SDK_POJO).memberName("features").getter(getter(CodegenJob::features))
            .setter(setter(Builder::features)).constructor(CodegenFeatureFlags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CodegenJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(CodegenJob::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<CodegenJobAsset> ASSET_FIELD = SdkField.<CodegenJobAsset> builder(MarshallingType.SDK_POJO)
            .memberName("asset").getter(getter(CodegenJob::asset)).setter(setter(Builder::asset))
            .constructor(CodegenJobAsset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asset").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CodegenJob::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CodegenJob::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt")
            .getter(getter(CodegenJob::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<CodegenDependency>> DEPENDENCIES_FIELD = SdkField
            .<List<CodegenDependency>> builder(MarshallingType.LIST)
            .memberName("dependencies")
            .getter(getter(CodegenJob::dependencies))
            .setter(setter(Builder::dependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodegenDependency> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodegenDependency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ID_FIELD, APP_ID_FIELD, ENVIRONMENT_NAME_FIELD, RENDER_CONFIG_FIELD,
                    GENERIC_DATA_SCHEMA_FIELD, AUTO_GENERATE_FORMS_FIELD, FEATURES_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD,
                    ASSET_FIELD, TAGS_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, DEPENDENCIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String appId;

    private final String environmentName;

    private final CodegenJobRenderConfig renderConfig;

    private final CodegenJobGenericDataSchema genericDataSchema;

    private final Boolean autoGenerateForms;

    private final CodegenFeatureFlags features;

    private final String status;

    private final String statusMessage;

    private final CodegenJobAsset asset;

    private final Map<String, String> tags;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final List<CodegenDependency> dependencies;

    private CodegenJob(BuilderImpl builder) {
        this.id = builder.id;
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
        this.renderConfig = builder.renderConfig;
        this.genericDataSchema = builder.genericDataSchema;
        this.autoGenerateForms = builder.autoGenerateForms;
        this.features = builder.features;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.asset = builder.asset;
        this.tags = builder.tags;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.dependencies = builder.dependencies;
    }

    /**
     * <p>
     * The unique ID for the code generation job.
     * </p>
     * 
     * @return The unique ID for the code generation job.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the Amplify app associated with the code generation job.
     * </p>
     * 
     * @return The ID of the Amplify app associated with the code generation job.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of the backend environment associated with the code generation job.
     * </p>
     * 
     * @return The name of the backend environment associated with the code generation job.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * Returns the value of the RenderConfig property for this object.
     * 
     * @return The value of the RenderConfig property for this object.
     */
    public final CodegenJobRenderConfig renderConfig() {
        return renderConfig;
    }

    /**
     * Returns the value of the GenericDataSchema property for this object.
     * 
     * @return The value of the GenericDataSchema property for this object.
     */
    public final CodegenJobGenericDataSchema genericDataSchema() {
        return genericDataSchema;
    }

    /**
     * <p>
     * Specifies whether to autogenerate forms in the code generation job.
     * </p>
     * 
     * @return Specifies whether to autogenerate forms in the code generation job.
     */
    public final Boolean autoGenerateForms() {
        return autoGenerateForms;
    }

    /**
     * Returns the value of the Features property for this object.
     * 
     * @return The value of the Features property for this object.
     */
    public final CodegenFeatureFlags features() {
        return features;
    }

    /**
     * <p>
     * The status of the code generation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CodegenJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the code generation job.
     * @see CodegenJobStatus
     */
    public final CodegenJobStatus status() {
        return CodegenJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the code generation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CodegenJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the code generation job.
     * @see CodegenJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The customized status message for the code generation job.
     * </p>
     * 
     * @return The customized status message for the code generation job.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The <code>CodegenJobAsset</code> to use for the code generation job.
     * </p>
     * 
     * @return The <code>CodegenJobAsset</code> to use for the code generation job.
     */
    public final CodegenJobAsset asset() {
        return asset;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more key-value pairs to use when tagging the code generation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more key-value pairs to use when tagging the code generation job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The time that the code generation job was created.
     * </p>
     * 
     * @return The time that the code generation job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time that the code generation job was modified.
     * </p>
     * 
     * @return The time that the code generation job was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dependencies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDependencies() {
        return dependencies != null && !(dependencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the dependency packages that may be required for the project code to run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependencies} method.
     * </p>
     * 
     * @return Lists the dependency packages that may be required for the project code to run.
     */
    public final List<CodegenDependency> dependencies() {
        return dependencies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(renderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(genericDataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(autoGenerateForms());
        hashCode = 31 * hashCode + Objects.hashCode(features());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(asset());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependencies() ? dependencies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodegenJob)) {
            return false;
        }
        CodegenJob other = (CodegenJob) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(appId(), other.appId())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(renderConfig(), other.renderConfig())
                && Objects.equals(genericDataSchema(), other.genericDataSchema())
                && Objects.equals(autoGenerateForms(), other.autoGenerateForms()) && Objects.equals(features(), other.features())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(asset(), other.asset())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(modifiedAt(), other.modifiedAt())
                && hasDependencies() == other.hasDependencies() && Objects.equals(dependencies(), other.dependencies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodegenJob").add("Id", id()).add("AppId", appId()).add("EnvironmentName", environmentName())
                .add("RenderConfig", renderConfig()).add("GenericDataSchema", genericDataSchema())
                .add("AutoGenerateForms", autoGenerateForms()).add("Features", features()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("Asset", asset()).add("Tags", hasTags() ? tags() : null)
                .add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt())
                .add("Dependencies", hasDependencies() ? dependencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "renderConfig":
            return Optional.ofNullable(clazz.cast(renderConfig()));
        case "genericDataSchema":
            return Optional.ofNullable(clazz.cast(genericDataSchema()));
        case "autoGenerateForms":
            return Optional.ofNullable(clazz.cast(autoGenerateForms()));
        case "features":
            return Optional.ofNullable(clazz.cast(features()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "asset":
            return Optional.ofNullable(clazz.cast(asset()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "dependencies":
            return Optional.ofNullable(clazz.cast(dependencies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("appId", APP_ID_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("renderConfig", RENDER_CONFIG_FIELD);
        map.put("genericDataSchema", GENERIC_DATA_SCHEMA_FIELD);
        map.put("autoGenerateForms", AUTO_GENERATE_FORMS_FIELD);
        map.put("features", FEATURES_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("asset", ASSET_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("dependencies", DEPENDENCIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodegenJob, T> g) {
        return obj -> g.apply((CodegenJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodegenJob> {
        /**
         * <p>
         * The unique ID for the code generation job.
         * </p>
         * 
         * @param id
         *        The unique ID for the code generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the Amplify app associated with the code generation job.
         * </p>
         * 
         * @param appId
         *        The ID of the Amplify app associated with the code generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of the backend environment associated with the code generation job.
         * </p>
         * 
         * @param environmentName
         *        The name of the backend environment associated with the code generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * Sets the value of the RenderConfig property for this object.
         *
         * @param renderConfig
         *        The new value for the RenderConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderConfig(CodegenJobRenderConfig renderConfig);

        /**
         * Sets the value of the RenderConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CodegenJobRenderConfig.Builder} avoiding
         * the need to create one manually via {@link CodegenJobRenderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodegenJobRenderConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #renderConfig(CodegenJobRenderConfig)}.
         * 
         * @param renderConfig
         *        a consumer that will call methods on {@link CodegenJobRenderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renderConfig(CodegenJobRenderConfig)
         */
        default Builder renderConfig(Consumer<CodegenJobRenderConfig.Builder> renderConfig) {
            return renderConfig(CodegenJobRenderConfig.builder().applyMutation(renderConfig).build());
        }

        /**
         * Sets the value of the GenericDataSchema property for this object.
         *
         * @param genericDataSchema
         *        The new value for the GenericDataSchema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder genericDataSchema(CodegenJobGenericDataSchema genericDataSchema);

        /**
         * Sets the value of the GenericDataSchema property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CodegenJobGenericDataSchema.Builder}
         * avoiding the need to create one manually via {@link CodegenJobGenericDataSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodegenJobGenericDataSchema.Builder#build()} is called
         * immediately and its result is passed to {@link #genericDataSchema(CodegenJobGenericDataSchema)}.
         * 
         * @param genericDataSchema
         *        a consumer that will call methods on {@link CodegenJobGenericDataSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #genericDataSchema(CodegenJobGenericDataSchema)
         */
        default Builder genericDataSchema(Consumer<CodegenJobGenericDataSchema.Builder> genericDataSchema) {
            return genericDataSchema(CodegenJobGenericDataSchema.builder().applyMutation(genericDataSchema).build());
        }

        /**
         * <p>
         * Specifies whether to autogenerate forms in the code generation job.
         * </p>
         * 
         * @param autoGenerateForms
         *        Specifies whether to autogenerate forms in the code generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoGenerateForms(Boolean autoGenerateForms);

        /**
         * Sets the value of the Features property for this object.
         *
         * @param features
         *        The new value for the Features property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(CodegenFeatureFlags features);

        /**
         * Sets the value of the Features property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CodegenFeatureFlags.Builder} avoiding the
         * need to create one manually via {@link CodegenFeatureFlags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodegenFeatureFlags.Builder#build()} is called immediately and
         * its result is passed to {@link #features(CodegenFeatureFlags)}.
         * 
         * @param features
         *        a consumer that will call methods on {@link CodegenFeatureFlags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #features(CodegenFeatureFlags)
         */
        default Builder features(Consumer<CodegenFeatureFlags.Builder> features) {
            return features(CodegenFeatureFlags.builder().applyMutation(features).build());
        }

        /**
         * <p>
         * The status of the code generation job.
         * </p>
         * 
         * @param status
         *        The status of the code generation job.
         * @see CodegenJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodegenJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the code generation job.
         * </p>
         * 
         * @param status
         *        The status of the code generation job.
         * @see CodegenJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodegenJobStatus
         */
        Builder status(CodegenJobStatus status);

        /**
         * <p>
         * The customized status message for the code generation job.
         * </p>
         * 
         * @param statusMessage
         *        The customized status message for the code generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The <code>CodegenJobAsset</code> to use for the code generation job.
         * </p>
         * 
         * @param asset
         *        The <code>CodegenJobAsset</code> to use for the code generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asset(CodegenJobAsset asset);

        /**
         * <p>
         * The <code>CodegenJobAsset</code> to use for the code generation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodegenJobAsset.Builder} avoiding the
         * need to create one manually via {@link CodegenJobAsset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodegenJobAsset.Builder#build()} is called immediately and its
         * result is passed to {@link #asset(CodegenJobAsset)}.
         * 
         * @param asset
         *        a consumer that will call methods on {@link CodegenJobAsset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #asset(CodegenJobAsset)
         */
        default Builder asset(Consumer<CodegenJobAsset.Builder> asset) {
            return asset(CodegenJobAsset.builder().applyMutation(asset).build());
        }

        /**
         * <p>
         * One or more key-value pairs to use when tagging the code generation job.
         * </p>
         * 
         * @param tags
         *        One or more key-value pairs to use when tagging the code generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The time that the code generation job was created.
         * </p>
         * 
         * @param createdAt
         *        The time that the code generation job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time that the code generation job was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The time that the code generation job was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * Lists the dependency packages that may be required for the project code to run.
         * </p>
         * 
         * @param dependencies
         *        Lists the dependency packages that may be required for the project code to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(Collection<CodegenDependency> dependencies);

        /**
         * <p>
         * Lists the dependency packages that may be required for the project code to run.
         * </p>
         * 
         * @param dependencies
         *        Lists the dependency packages that may be required for the project code to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(CodegenDependency... dependencies);

        /**
         * <p>
         * Lists the dependency packages that may be required for the project code to run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.CodegenDependency.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.CodegenDependency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.CodegenDependency.Builder#build()} is called
         * immediately and its result is passed to {@link #dependencies(List<CodegenDependency>)}.
         * 
         * @param dependencies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.CodegenDependency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependencies(java.util.Collection<CodegenDependency>)
         */
        Builder dependencies(Consumer<CodegenDependency.Builder>... dependencies);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String appId;

        private String environmentName;

        private CodegenJobRenderConfig renderConfig;

        private CodegenJobGenericDataSchema genericDataSchema;

        private Boolean autoGenerateForms;

        private CodegenFeatureFlags features;

        private String status;

        private String statusMessage;

        private CodegenJobAsset asset;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant createdAt;

        private Instant modifiedAt;

        private List<CodegenDependency> dependencies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodegenJob model) {
            id(model.id);
            appId(model.appId);
            environmentName(model.environmentName);
            renderConfig(model.renderConfig);
            genericDataSchema(model.genericDataSchema);
            autoGenerateForms(model.autoGenerateForms);
            features(model.features);
            status(model.status);
            statusMessage(model.statusMessage);
            asset(model.asset);
            tags(model.tags);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            dependencies(model.dependencies);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final CodegenJobRenderConfig.Builder getRenderConfig() {
            return renderConfig != null ? renderConfig.toBuilder() : null;
        }

        public final void setRenderConfig(CodegenJobRenderConfig.BuilderImpl renderConfig) {
            this.renderConfig = renderConfig != null ? renderConfig.build() : null;
        }

        @Override
        public final Builder renderConfig(CodegenJobRenderConfig renderConfig) {
            this.renderConfig = renderConfig;
            return this;
        }

        public final CodegenJobGenericDataSchema.Builder getGenericDataSchema() {
            return genericDataSchema != null ? genericDataSchema.toBuilder() : null;
        }

        public final void setGenericDataSchema(CodegenJobGenericDataSchema.BuilderImpl genericDataSchema) {
            this.genericDataSchema = genericDataSchema != null ? genericDataSchema.build() : null;
        }

        @Override
        public final Builder genericDataSchema(CodegenJobGenericDataSchema genericDataSchema) {
            this.genericDataSchema = genericDataSchema;
            return this;
        }

        public final Boolean getAutoGenerateForms() {
            return autoGenerateForms;
        }

        public final void setAutoGenerateForms(Boolean autoGenerateForms) {
            this.autoGenerateForms = autoGenerateForms;
        }

        @Override
        public final Builder autoGenerateForms(Boolean autoGenerateForms) {
            this.autoGenerateForms = autoGenerateForms;
            return this;
        }

        public final CodegenFeatureFlags.Builder getFeatures() {
            return features != null ? features.toBuilder() : null;
        }

        public final void setFeatures(CodegenFeatureFlags.BuilderImpl features) {
            this.features = features != null ? features.build() : null;
        }

        @Override
        public final Builder features(CodegenFeatureFlags features) {
            this.features = features;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CodegenJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final CodegenJobAsset.Builder getAsset() {
            return asset != null ? asset.toBuilder() : null;
        }

        public final void setAsset(CodegenJobAsset.BuilderImpl asset) {
            this.asset = asset != null ? asset.build() : null;
        }

        @Override
        public final Builder asset(CodegenJobAsset asset) {
            this.asset = asset;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final List<CodegenDependency.Builder> getDependencies() {
            List<CodegenDependency.Builder> result = CodegenDependenciesCopier.copyToBuilder(this.dependencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependencies(Collection<CodegenDependency.BuilderImpl> dependencies) {
            this.dependencies = CodegenDependenciesCopier.copyFromBuilder(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<CodegenDependency> dependencies) {
            this.dependencies = CodegenDependenciesCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(CodegenDependency... dependencies) {
            dependencies(Arrays.asList(dependencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(Consumer<CodegenDependency.Builder>... dependencies) {
            dependencies(Stream.of(dependencies).map(c -> CodegenDependency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CodegenJob build() {
            return new CodegenJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
