/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the data binding configuration for a component at runtime. You can use
 * <code>ComponentBindingPropertiesValue</code> to add exposed properties to a component to allow different values to be
 * entered when a component is reused in different places in an app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentBindingPropertiesValue implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentBindingPropertiesValue.Builder, ComponentBindingPropertiesValue> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ComponentBindingPropertiesValue::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<ComponentBindingPropertiesValueProperties> BINDING_PROPERTIES_FIELD = SdkField
            .<ComponentBindingPropertiesValueProperties> builder(MarshallingType.SDK_POJO).memberName("bindingProperties")
            .getter(getter(ComponentBindingPropertiesValue::bindingProperties)).setter(setter(Builder::bindingProperties))
            .constructor(ComponentBindingPropertiesValueProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindingProperties").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(ComponentBindingPropertiesValue::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            BINDING_PROPERTIES_FIELD, DEFAULT_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final ComponentBindingPropertiesValueProperties bindingProperties;

    private final String defaultValue;

    private ComponentBindingPropertiesValue(BuilderImpl builder) {
        this.type = builder.type;
        this.bindingProperties = builder.bindingProperties;
        this.defaultValue = builder.defaultValue;
    }

    /**
     * <p>
     * The property type.
     * </p>
     * 
     * @return The property type.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * Describes the properties to customize with data at runtime.
     * </p>
     * 
     * @return Describes the properties to customize with data at runtime.
     */
    public final ComponentBindingPropertiesValueProperties bindingProperties() {
        return bindingProperties;
    }

    /**
     * <p>
     * The default value of the property.
     * </p>
     * 
     * @return The default value of the property.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(bindingProperties());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentBindingPropertiesValue)) {
            return false;
        }
        ComponentBindingPropertiesValue other = (ComponentBindingPropertiesValue) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(bindingProperties(), other.bindingProperties())
                && Objects.equals(defaultValue(), other.defaultValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentBindingPropertiesValue").add("Type", type())
                .add("BindingProperties", bindingProperties()).add("DefaultValue", defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "bindingProperties":
            return Optional.ofNullable(clazz.cast(bindingProperties()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("bindingProperties", BINDING_PROPERTIES_FIELD);
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentBindingPropertiesValue, T> g) {
        return obj -> g.apply((ComponentBindingPropertiesValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentBindingPropertiesValue> {
        /**
         * <p>
         * The property type.
         * </p>
         * 
         * @param type
         *        The property type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Describes the properties to customize with data at runtime.
         * </p>
         * 
         * @param bindingProperties
         *        Describes the properties to customize with data at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bindingProperties(ComponentBindingPropertiesValueProperties bindingProperties);

        /**
         * <p>
         * Describes the properties to customize with data at runtime.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ComponentBindingPropertiesValueProperties.Builder} avoiding the need to create one manually via
         * {@link ComponentBindingPropertiesValueProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentBindingPropertiesValueProperties.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #bindingProperties(ComponentBindingPropertiesValueProperties)}.
         * 
         * @param bindingProperties
         *        a consumer that will call methods on {@link ComponentBindingPropertiesValueProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bindingProperties(ComponentBindingPropertiesValueProperties)
         */
        default Builder bindingProperties(Consumer<ComponentBindingPropertiesValueProperties.Builder> bindingProperties) {
            return bindingProperties(ComponentBindingPropertiesValueProperties.builder().applyMutation(bindingProperties).build());
        }

        /**
         * <p>
         * The default value of the property.
         * </p>
         * 
         * @param defaultValue
         *        The default value of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private ComponentBindingPropertiesValueProperties bindingProperties;

        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentBindingPropertiesValue model) {
            type(model.type);
            bindingProperties(model.bindingProperties);
            defaultValue(model.defaultValue);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final ComponentBindingPropertiesValueProperties.Builder getBindingProperties() {
            return bindingProperties != null ? bindingProperties.toBuilder() : null;
        }

        public final void setBindingProperties(ComponentBindingPropertiesValueProperties.BuilderImpl bindingProperties) {
            this.bindingProperties = bindingProperties != null ? bindingProperties.build() : null;
        }

        @Override
        public final Builder bindingProperties(ComponentBindingPropertiesValueProperties bindingProperties) {
            this.bindingProperties = bindingProperties;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public ComponentBindingPropertiesValue build() {
            return new ComponentBindingPropertiesValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
