/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration information for a field in a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldConfig implements SdkPojo, Serializable, ToCopyableBuilder<FieldConfig.Builder, FieldConfig> {
    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("label")
            .getter(getter(FieldConfig::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()).build();

    private static final SdkField<FieldPosition> POSITION_FIELD = SdkField.<FieldPosition> builder(MarshallingType.SDK_POJO)
            .memberName("position").getter(getter(FieldConfig::position)).setter(setter(Builder::position))
            .constructor(FieldPosition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<Boolean> EXCLUDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("excluded").getter(getter(FieldConfig::excluded)).setter(setter(Builder::excluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excluded").build()).build();

    private static final SdkField<FieldInputConfig> INPUT_TYPE_FIELD = SdkField
            .<FieldInputConfig> builder(MarshallingType.SDK_POJO).memberName("inputType").getter(getter(FieldConfig::inputType))
            .setter(setter(Builder::inputType)).constructor(FieldInputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputType").build()).build();

    private static final SdkField<List<FieldValidationConfiguration>> VALIDATIONS_FIELD = SdkField
            .<List<FieldValidationConfiguration>> builder(MarshallingType.LIST)
            .memberName("validations")
            .getter(getter(FieldConfig::validations))
            .setter(setter(Builder::validations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldValidationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldValidationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_FIELD, POSITION_FIELD,
            EXCLUDED_FIELD, INPUT_TYPE_FIELD, VALIDATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String label;

    private final FieldPosition position;

    private final Boolean excluded;

    private final FieldInputConfig inputType;

    private final List<FieldValidationConfiguration> validations;

    private FieldConfig(BuilderImpl builder) {
        this.label = builder.label;
        this.position = builder.position;
        this.excluded = builder.excluded;
        this.inputType = builder.inputType;
        this.validations = builder.validations;
    }

    /**
     * <p>
     * The label for the field.
     * </p>
     * 
     * @return The label for the field.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * Specifies the field position.
     * </p>
     * 
     * @return Specifies the field position.
     */
    public final FieldPosition position() {
        return position;
    }

    /**
     * <p>
     * Specifies whether to hide a field.
     * </p>
     * 
     * @return Specifies whether to hide a field.
     */
    public final Boolean excluded() {
        return excluded;
    }

    /**
     * <p>
     * Describes the configuration for the default input value to display for a field.
     * </p>
     * 
     * @return Describes the configuration for the default input value to display for a field.
     */
    public final FieldInputConfig inputType() {
        return inputType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Validations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValidations() {
        return validations != null && !(validations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The validations to perform on the value in the field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidations} method.
     * </p>
     * 
     * @return The validations to perform on the value in the field.
     */
    public final List<FieldValidationConfiguration> validations() {
        return validations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(excluded());
        hashCode = 31 * hashCode + Objects.hashCode(inputType());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidations() ? validations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldConfig)) {
            return false;
        }
        FieldConfig other = (FieldConfig) obj;
        return Objects.equals(label(), other.label()) && Objects.equals(position(), other.position())
                && Objects.equals(excluded(), other.excluded()) && Objects.equals(inputType(), other.inputType())
                && hasValidations() == other.hasValidations() && Objects.equals(validations(), other.validations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldConfig").add("Label", label()).add("Position", position()).add("Excluded", excluded())
                .add("InputType", inputType()).add("Validations", hasValidations() ? validations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "label":
            return Optional.ofNullable(clazz.cast(label()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "excluded":
            return Optional.ofNullable(clazz.cast(excluded()));
        case "inputType":
            return Optional.ofNullable(clazz.cast(inputType()));
        case "validations":
            return Optional.ofNullable(clazz.cast(validations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("label", LABEL_FIELD);
        map.put("position", POSITION_FIELD);
        map.put("excluded", EXCLUDED_FIELD);
        map.put("inputType", INPUT_TYPE_FIELD);
        map.put("validations", VALIDATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldConfig, T> g) {
        return obj -> g.apply((FieldConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldConfig> {
        /**
         * <p>
         * The label for the field.
         * </p>
         * 
         * @param label
         *        The label for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * Specifies the field position.
         * </p>
         * 
         * @param position
         *        Specifies the field position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(FieldPosition position);

        /**
         * <p>
         * Specifies the field position.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldPosition.Builder} avoiding the need
         * to create one manually via {@link FieldPosition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldPosition.Builder#build()} is called immediately and its
         * result is passed to {@link #position(FieldPosition)}.
         * 
         * @param position
         *        a consumer that will call methods on {@link FieldPosition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #position(FieldPosition)
         */
        default Builder position(Consumer<FieldPosition.Builder> position) {
            return position(FieldPosition.builder().applyMutation(position).build());
        }

        /**
         * <p>
         * Specifies whether to hide a field.
         * </p>
         * 
         * @param excluded
         *        Specifies whether to hide a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excluded(Boolean excluded);

        /**
         * <p>
         * Describes the configuration for the default input value to display for a field.
         * </p>
         * 
         * @param inputType
         *        Describes the configuration for the default input value to display for a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputType(FieldInputConfig inputType);

        /**
         * <p>
         * Describes the configuration for the default input value to display for a field.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldInputConfig.Builder} avoiding the
         * need to create one manually via {@link FieldInputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldInputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputType(FieldInputConfig)}.
         * 
         * @param inputType
         *        a consumer that will call methods on {@link FieldInputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputType(FieldInputConfig)
         */
        default Builder inputType(Consumer<FieldInputConfig.Builder> inputType) {
            return inputType(FieldInputConfig.builder().applyMutation(inputType).build());
        }

        /**
         * <p>
         * The validations to perform on the value in the field.
         * </p>
         * 
         * @param validations
         *        The validations to perform on the value in the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validations(Collection<FieldValidationConfiguration> validations);

        /**
         * <p>
         * The validations to perform on the value in the field.
         * </p>
         * 
         * @param validations
         *        The validations to perform on the value in the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validations(FieldValidationConfiguration... validations);

        /**
         * <p>
         * The validations to perform on the value in the field.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.FieldValidationConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.FieldValidationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.FieldValidationConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link #validations(List<FieldValidationConfiguration>)}.
         * 
         * @param validations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.FieldValidationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validations(java.util.Collection<FieldValidationConfiguration>)
         */
        Builder validations(Consumer<FieldValidationConfiguration.Builder>... validations);
    }

    static final class BuilderImpl implements Builder {
        private String label;

        private FieldPosition position;

        private Boolean excluded;

        private FieldInputConfig inputType;

        private List<FieldValidationConfiguration> validations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FieldConfig model) {
            label(model.label);
            position(model.position);
            excluded(model.excluded);
            inputType(model.inputType);
            validations(model.validations);
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final FieldPosition.Builder getPosition() {
            return position != null ? position.toBuilder() : null;
        }

        public final void setPosition(FieldPosition.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(FieldPosition position) {
            this.position = position;
            return this;
        }

        public final Boolean getExcluded() {
            return excluded;
        }

        public final void setExcluded(Boolean excluded) {
            this.excluded = excluded;
        }

        @Override
        public final Builder excluded(Boolean excluded) {
            this.excluded = excluded;
            return this;
        }

        public final FieldInputConfig.Builder getInputType() {
            return inputType != null ? inputType.toBuilder() : null;
        }

        public final void setInputType(FieldInputConfig.BuilderImpl inputType) {
            this.inputType = inputType != null ? inputType.build() : null;
        }

        @Override
        public final Builder inputType(FieldInputConfig inputType) {
            this.inputType = inputType;
            return this;
        }

        public final List<FieldValidationConfiguration.Builder> getValidations() {
            List<FieldValidationConfiguration.Builder> result = ValidationsListCopier.copyToBuilder(this.validations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidations(Collection<FieldValidationConfiguration.BuilderImpl> validations) {
            this.validations = ValidationsListCopier.copyFromBuilder(validations);
        }

        @Override
        public final Builder validations(Collection<FieldValidationConfiguration> validations) {
            this.validations = ValidationsListCopier.copy(validations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validations(FieldValidationConfiguration... validations) {
            validations(Arrays.asList(validations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validations(Consumer<FieldValidationConfiguration.Builder>... validations) {
            validations(Stream.of(validations).map(c -> FieldValidationConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FieldConfig build() {
            return new FieldConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
