/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the validation configuration for a field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldValidationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldValidationConfiguration.Builder, FieldValidationConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FieldValidationConfiguration::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<String>> STR_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("strValues")
            .getter(getter(FieldValidationConfiguration::strValues))
            .setter(setter(Builder::strValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> NUM_VALUES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("numValues")
            .getter(getter(FieldValidationConfiguration::numValues))
            .setter(setter(Builder::numValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VALIDATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("validationMessage").getter(getter(FieldValidationConfiguration::validationMessage))
            .setter(setter(Builder::validationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, STR_VALUES_FIELD,
            NUM_VALUES_FIELD, VALIDATION_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final List<String> strValues;

    private final List<Integer> numValues;

    private final String validationMessage;

    private FieldValidationConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.strValues = builder.strValues;
        this.numValues = builder.numValues;
        this.validationMessage = builder.validationMessage;
    }

    /**
     * <p>
     * The validation to perform on an object type.<code/>
     * </p>
     * 
     * @return The validation to perform on an object type.<code/>
     */
    public final String type() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the StrValues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStrValues() {
        return strValues != null && !(strValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The validation to perform on a string value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStrValues} method.
     * </p>
     * 
     * @return The validation to perform on a string value.
     */
    public final List<String> strValues() {
        return strValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the NumValues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNumValues() {
        return numValues != null && !(numValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The validation to perform on a number value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNumValues} method.
     * </p>
     * 
     * @return The validation to perform on a number value.
     */
    public final List<Integer> numValues() {
        return numValues;
    }

    /**
     * <p>
     * The validation message to display.
     * </p>
     * 
     * @return The validation message to display.
     */
    public final String validationMessage() {
        return validationMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(hasStrValues() ? strValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNumValues() ? numValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(validationMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldValidationConfiguration)) {
            return false;
        }
        FieldValidationConfiguration other = (FieldValidationConfiguration) obj;
        return Objects.equals(type(), other.type()) && hasStrValues() == other.hasStrValues()
                && Objects.equals(strValues(), other.strValues()) && hasNumValues() == other.hasNumValues()
                && Objects.equals(numValues(), other.numValues())
                && Objects.equals(validationMessage(), other.validationMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldValidationConfiguration").add("Type", type())
                .add("StrValues", hasStrValues() ? strValues() : null).add("NumValues", hasNumValues() ? numValues() : null)
                .add("ValidationMessage", validationMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "strValues":
            return Optional.ofNullable(clazz.cast(strValues()));
        case "numValues":
            return Optional.ofNullable(clazz.cast(numValues()));
        case "validationMessage":
            return Optional.ofNullable(clazz.cast(validationMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("strValues", STR_VALUES_FIELD);
        map.put("numValues", NUM_VALUES_FIELD);
        map.put("validationMessage", VALIDATION_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldValidationConfiguration, T> g) {
        return obj -> g.apply((FieldValidationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldValidationConfiguration> {
        /**
         * <p>
         * The validation to perform on an object type.<code/>
         * </p>
         * 
         * @param type
         *        The validation to perform on an object type.<code/>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The validation to perform on a string value.
         * </p>
         * 
         * @param strValues
         *        The validation to perform on a string value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strValues(Collection<String> strValues);

        /**
         * <p>
         * The validation to perform on a string value.
         * </p>
         * 
         * @param strValues
         *        The validation to perform on a string value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strValues(String... strValues);

        /**
         * <p>
         * The validation to perform on a number value.
         * </p>
         * 
         * @param numValues
         *        The validation to perform on a number value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numValues(Collection<Integer> numValues);

        /**
         * <p>
         * The validation to perform on a number value.
         * </p>
         * 
         * @param numValues
         *        The validation to perform on a number value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numValues(Integer... numValues);

        /**
         * <p>
         * The validation message to display.
         * </p>
         * 
         * @param validationMessage
         *        The validation message to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationMessage(String validationMessage);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<String> strValues = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> numValues = DefaultSdkAutoConstructList.getInstance();

        private String validationMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldValidationConfiguration model) {
            type(model.type);
            strValues(model.strValues);
            numValues(model.numValues);
            validationMessage(model.validationMessage);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Collection<String> getStrValues() {
            if (strValues instanceof SdkAutoConstructList) {
                return null;
            }
            return strValues;
        }

        public final void setStrValues(Collection<String> strValues) {
            this.strValues = StrValuesCopier.copy(strValues);
        }

        @Override
        public final Builder strValues(Collection<String> strValues) {
            this.strValues = StrValuesCopier.copy(strValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder strValues(String... strValues) {
            strValues(Arrays.asList(strValues));
            return this;
        }

        public final Collection<Integer> getNumValues() {
            if (numValues instanceof SdkAutoConstructList) {
                return null;
            }
            return numValues;
        }

        public final void setNumValues(Collection<Integer> numValues) {
            this.numValues = NumValuesCopier.copy(numValues);
        }

        @Override
        public final Builder numValues(Collection<Integer> numValues) {
            this.numValues = NumValuesCopier.copy(numValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numValues(Integer... numValues) {
            numValues(Arrays.asList(numValues));
            return this;
        }

        public final String getValidationMessage() {
            return validationMessage;
        }

        public final void setValidationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
        }

        @Override
        public final Builder validationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
            return this;
        }

        @Override
        public FieldValidationConfiguration build() {
            return new FieldValidationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
