/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration for the file uploader field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileUploaderFieldConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FileUploaderFieldConfig.Builder, FileUploaderFieldConfig> {
    private static final SdkField<String> ACCESS_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessLevel").getter(getter(FileUploaderFieldConfig::accessLevelAsString))
            .setter(setter(Builder::accessLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLevel").build()).build();

    private static final SdkField<List<String>> ACCEPTED_FILE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("acceptedFileTypes")
            .getter(getter(FileUploaderFieldConfig::acceptedFileTypes))
            .setter(setter(Builder::acceptedFileTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptedFileTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> SHOW_THUMBNAILS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("showThumbnails").getter(getter(FileUploaderFieldConfig::showThumbnails))
            .setter(setter(Builder::showThumbnails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("showThumbnails").build()).build();

    private static final SdkField<Boolean> IS_RESUMABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isResumable").getter(getter(FileUploaderFieldConfig::isResumable)).setter(setter(Builder::isResumable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isResumable").build()).build();

    private static final SdkField<Integer> MAX_FILE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxFileCount").getter(getter(FileUploaderFieldConfig::maxFileCount))
            .setter(setter(Builder::maxFileCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFileCount").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxSize").getter(getter(FileUploaderFieldConfig::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_LEVEL_FIELD,
            ACCEPTED_FILE_TYPES_FIELD, SHOW_THUMBNAILS_FIELD, IS_RESUMABLE_FIELD, MAX_FILE_COUNT_FIELD, MAX_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessLevel;

    private final List<String> acceptedFileTypes;

    private final Boolean showThumbnails;

    private final Boolean isResumable;

    private final Integer maxFileCount;

    private final Integer maxSize;

    private FileUploaderFieldConfig(BuilderImpl builder) {
        this.accessLevel = builder.accessLevel;
        this.acceptedFileTypes = builder.acceptedFileTypes;
        this.showThumbnails = builder.showThumbnails;
        this.isResumable = builder.isResumable;
        this.maxFileCount = builder.maxFileCount;
        this.maxSize = builder.maxSize;
    }

    /**
     * <p>
     * The access level to assign to the uploaded files in the Amazon S3 bucket where they are stored. The valid values
     * for this property are <code>private</code>, <code>protected</code>, or <code>public</code>. For detailed
     * information about the permissions associated with each access level, see <a
     * href="https://docs.amplify.aws/lib/storage/configureaccess/q/platform/js/">File access levels</a> in the
     * <i>Amplify documentation</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessLevel} will
     * return {@link StorageAccessLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessLevelAsString}.
     * </p>
     * 
     * @return The access level to assign to the uploaded files in the Amazon S3 bucket where they are stored. The valid
     *         values for this property are <code>private</code>, <code>protected</code>, or <code>public</code>. For
     *         detailed information about the permissions associated with each access level, see <a
     *         href="https://docs.amplify.aws/lib/storage/configureaccess/q/platform/js/">File access levels</a> in the
     *         <i>Amplify documentation</i>.
     * @see StorageAccessLevel
     */
    public final StorageAccessLevel accessLevel() {
        return StorageAccessLevel.fromValue(accessLevel);
    }

    /**
     * <p>
     * The access level to assign to the uploaded files in the Amazon S3 bucket where they are stored. The valid values
     * for this property are <code>private</code>, <code>protected</code>, or <code>public</code>. For detailed
     * information about the permissions associated with each access level, see <a
     * href="https://docs.amplify.aws/lib/storage/configureaccess/q/platform/js/">File access levels</a> in the
     * <i>Amplify documentation</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessLevel} will
     * return {@link StorageAccessLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessLevelAsString}.
     * </p>
     * 
     * @return The access level to assign to the uploaded files in the Amazon S3 bucket where they are stored. The valid
     *         values for this property are <code>private</code>, <code>protected</code>, or <code>public</code>. For
     *         detailed information about the permissions associated with each access level, see <a
     *         href="https://docs.amplify.aws/lib/storage/configureaccess/q/platform/js/">File access levels</a> in the
     *         <i>Amplify documentation</i>.
     * @see StorageAccessLevel
     */
    public final String accessLevelAsString() {
        return accessLevel;
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceptedFileTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAcceptedFileTypes() {
        return acceptedFileTypes != null && !(acceptedFileTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The file types that are allowed to be uploaded by the file uploader. Provide this information in an array of
     * strings specifying the valid file extensions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceptedFileTypes} method.
     * </p>
     * 
     * @return The file types that are allowed to be uploaded by the file uploader. Provide this information in an array
     *         of strings specifying the valid file extensions.
     */
    public final List<String> acceptedFileTypes() {
        return acceptedFileTypes;
    }

    /**
     * <p>
     * Specifies whether to display or hide the image preview after selecting a file for upload. The default value is
     * <code>true</code> to display the image preview.
     * </p>
     * 
     * @return Specifies whether to display or hide the image preview after selecting a file for upload. The default
     *         value is <code>true</code> to display the image preview.
     */
    public final Boolean showThumbnails() {
        return showThumbnails;
    }

    /**
     * <p>
     * Allows the file upload operation to be paused and resumed. The default value is <code>false</code>.
     * </p>
     * <p>
     * When <code>isResumable</code> is set to <code>true</code>, the file uploader uses a multipart upload to break the
     * files into chunks before upload. The progress of the upload isn't continuous, because the file uploader uploads a
     * chunk at a time.
     * </p>
     * 
     * @return Allows the file upload operation to be paused and resumed. The default value is <code>false</code>.</p>
     *         <p>
     *         When <code>isResumable</code> is set to <code>true</code>, the file uploader uses a multipart upload to
     *         break the files into chunks before upload. The progress of the upload isn't continuous, because the file
     *         uploader uploads a chunk at a time.
     */
    public final Boolean isResumable() {
        return isResumable;
    }

    /**
     * <p>
     * Specifies the maximum number of files that can be selected to upload. The default value is an unlimited number of
     * files.
     * </p>
     * 
     * @return Specifies the maximum number of files that can be selected to upload. The default value is an unlimited
     *         number of files.
     */
    public final Integer maxFileCount() {
        return maxFileCount;
    }

    /**
     * <p>
     * The maximum file size in bytes that the file uploader will accept. The default value is an unlimited file size.
     * </p>
     * 
     * @return The maximum file size in bytes that the file uploader will accept. The default value is an unlimited file
     *         size.
     */
    public final Integer maxSize() {
        return maxSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceptedFileTypes() ? acceptedFileTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(showThumbnails());
        hashCode = 31 * hashCode + Objects.hashCode(isResumable());
        hashCode = 31 * hashCode + Objects.hashCode(maxFileCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileUploaderFieldConfig)) {
            return false;
        }
        FileUploaderFieldConfig other = (FileUploaderFieldConfig) obj;
        return Objects.equals(accessLevelAsString(), other.accessLevelAsString())
                && hasAcceptedFileTypes() == other.hasAcceptedFileTypes()
                && Objects.equals(acceptedFileTypes(), other.acceptedFileTypes())
                && Objects.equals(showThumbnails(), other.showThumbnails()) && Objects.equals(isResumable(), other.isResumable())
                && Objects.equals(maxFileCount(), other.maxFileCount()) && Objects.equals(maxSize(), other.maxSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileUploaderFieldConfig").add("AccessLevel", accessLevelAsString())
                .add("AcceptedFileTypes", hasAcceptedFileTypes() ? acceptedFileTypes() : null)
                .add("ShowThumbnails", showThumbnails()).add("IsResumable", isResumable()).add("MaxFileCount", maxFileCount())
                .add("MaxSize", maxSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessLevel":
            return Optional.ofNullable(clazz.cast(accessLevelAsString()));
        case "acceptedFileTypes":
            return Optional.ofNullable(clazz.cast(acceptedFileTypes()));
        case "showThumbnails":
            return Optional.ofNullable(clazz.cast(showThumbnails()));
        case "isResumable":
            return Optional.ofNullable(clazz.cast(isResumable()));
        case "maxFileCount":
            return Optional.ofNullable(clazz.cast(maxFileCount()));
        case "maxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessLevel", ACCESS_LEVEL_FIELD);
        map.put("acceptedFileTypes", ACCEPTED_FILE_TYPES_FIELD);
        map.put("showThumbnails", SHOW_THUMBNAILS_FIELD);
        map.put("isResumable", IS_RESUMABLE_FIELD);
        map.put("maxFileCount", MAX_FILE_COUNT_FIELD);
        map.put("maxSize", MAX_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileUploaderFieldConfig, T> g) {
        return obj -> g.apply((FileUploaderFieldConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileUploaderFieldConfig> {
        /**
         * <p>
         * The access level to assign to the uploaded files in the Amazon S3 bucket where they are stored. The valid
         * values for this property are <code>private</code>, <code>protected</code>, or <code>public</code>. For
         * detailed information about the permissions associated with each access level, see <a
         * href="https://docs.amplify.aws/lib/storage/configureaccess/q/platform/js/">File access levels</a> in the
         * <i>Amplify documentation</i>.
         * </p>
         * 
         * @param accessLevel
         *        The access level to assign to the uploaded files in the Amazon S3 bucket where they are stored. The
         *        valid values for this property are <code>private</code>, <code>protected</code>, or
         *        <code>public</code>. For detailed information about the permissions associated with each access level,
         *        see <a href="https://docs.amplify.aws/lib/storage/configureaccess/q/platform/js/">File access
         *        levels</a> in the <i>Amplify documentation</i>.
         * @see StorageAccessLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageAccessLevel
         */
        Builder accessLevel(String accessLevel);

        /**
         * <p>
         * The access level to assign to the uploaded files in the Amazon S3 bucket where they are stored. The valid
         * values for this property are <code>private</code>, <code>protected</code>, or <code>public</code>. For
         * detailed information about the permissions associated with each access level, see <a
         * href="https://docs.amplify.aws/lib/storage/configureaccess/q/platform/js/">File access levels</a> in the
         * <i>Amplify documentation</i>.
         * </p>
         * 
         * @param accessLevel
         *        The access level to assign to the uploaded files in the Amazon S3 bucket where they are stored. The
         *        valid values for this property are <code>private</code>, <code>protected</code>, or
         *        <code>public</code>. For detailed information about the permissions associated with each access level,
         *        see <a href="https://docs.amplify.aws/lib/storage/configureaccess/q/platform/js/">File access
         *        levels</a> in the <i>Amplify documentation</i>.
         * @see StorageAccessLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageAccessLevel
         */
        Builder accessLevel(StorageAccessLevel accessLevel);

        /**
         * <p>
         * The file types that are allowed to be uploaded by the file uploader. Provide this information in an array of
         * strings specifying the valid file extensions.
         * </p>
         * 
         * @param acceptedFileTypes
         *        The file types that are allowed to be uploaded by the file uploader. Provide this information in an
         *        array of strings specifying the valid file extensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptedFileTypes(Collection<String> acceptedFileTypes);

        /**
         * <p>
         * The file types that are allowed to be uploaded by the file uploader. Provide this information in an array of
         * strings specifying the valid file extensions.
         * </p>
         * 
         * @param acceptedFileTypes
         *        The file types that are allowed to be uploaded by the file uploader. Provide this information in an
         *        array of strings specifying the valid file extensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptedFileTypes(String... acceptedFileTypes);

        /**
         * <p>
         * Specifies whether to display or hide the image preview after selecting a file for upload. The default value
         * is <code>true</code> to display the image preview.
         * </p>
         * 
         * @param showThumbnails
         *        Specifies whether to display or hide the image preview after selecting a file for upload. The default
         *        value is <code>true</code> to display the image preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showThumbnails(Boolean showThumbnails);

        /**
         * <p>
         * Allows the file upload operation to be paused and resumed. The default value is <code>false</code>.
         * </p>
         * <p>
         * When <code>isResumable</code> is set to <code>true</code>, the file uploader uses a multipart upload to break
         * the files into chunks before upload. The progress of the upload isn't continuous, because the file uploader
         * uploads a chunk at a time.
         * </p>
         * 
         * @param isResumable
         *        Allows the file upload operation to be paused and resumed. The default value is <code>false</code>
         *        .</p>
         *        <p>
         *        When <code>isResumable</code> is set to <code>true</code>, the file uploader uses a multipart upload
         *        to break the files into chunks before upload. The progress of the upload isn't continuous, because the
         *        file uploader uploads a chunk at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isResumable(Boolean isResumable);

        /**
         * <p>
         * Specifies the maximum number of files that can be selected to upload. The default value is an unlimited
         * number of files.
         * </p>
         * 
         * @param maxFileCount
         *        Specifies the maximum number of files that can be selected to upload. The default value is an
         *        unlimited number of files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFileCount(Integer maxFileCount);

        /**
         * <p>
         * The maximum file size in bytes that the file uploader will accept. The default value is an unlimited file
         * size.
         * </p>
         * 
         * @param maxSize
         *        The maximum file size in bytes that the file uploader will accept. The default value is an unlimited
         *        file size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);
    }

    static final class BuilderImpl implements Builder {
        private String accessLevel;

        private List<String> acceptedFileTypes = DefaultSdkAutoConstructList.getInstance();

        private Boolean showThumbnails;

        private Boolean isResumable;

        private Integer maxFileCount;

        private Integer maxSize;

        private BuilderImpl() {
        }

        private BuilderImpl(FileUploaderFieldConfig model) {
            accessLevel(model.accessLevel);
            acceptedFileTypes(model.acceptedFileTypes);
            showThumbnails(model.showThumbnails);
            isResumable(model.isResumable);
            maxFileCount(model.maxFileCount);
            maxSize(model.maxSize);
        }

        public final String getAccessLevel() {
            return accessLevel;
        }

        public final void setAccessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
        }

        @Override
        public final Builder accessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        @Override
        public final Builder accessLevel(StorageAccessLevel accessLevel) {
            this.accessLevel(accessLevel == null ? null : accessLevel.toString());
            return this;
        }

        public final Collection<String> getAcceptedFileTypes() {
            if (acceptedFileTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return acceptedFileTypes;
        }

        public final void setAcceptedFileTypes(Collection<String> acceptedFileTypes) {
            this.acceptedFileTypes = StrValuesCopier.copy(acceptedFileTypes);
        }

        @Override
        public final Builder acceptedFileTypes(Collection<String> acceptedFileTypes) {
            this.acceptedFileTypes = StrValuesCopier.copy(acceptedFileTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptedFileTypes(String... acceptedFileTypes) {
            acceptedFileTypes(Arrays.asList(acceptedFileTypes));
            return this;
        }

        public final Boolean getShowThumbnails() {
            return showThumbnails;
        }

        public final void setShowThumbnails(Boolean showThumbnails) {
            this.showThumbnails = showThumbnails;
        }

        @Override
        public final Builder showThumbnails(Boolean showThumbnails) {
            this.showThumbnails = showThumbnails;
            return this;
        }

        public final Boolean getIsResumable() {
            return isResumable;
        }

        public final void setIsResumable(Boolean isResumable) {
            this.isResumable = isResumable;
        }

        @Override
        public final Builder isResumable(Boolean isResumable) {
            this.isResumable = isResumable;
            return this;
        }

        public final Integer getMaxFileCount() {
            return maxFileCount;
        }

        public final void setMaxFileCount(Integer maxFileCount) {
            this.maxFileCount = maxFileCount;
        }

        @Override
        public final Builder maxFileCount(Integer maxFileCount) {
            this.maxFileCount = maxFileCount;
            return this;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        @Override
        public FileUploaderFieldConfig build() {
            return new FileUploaderFieldConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
