/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the state configuration when an action modifies a property of another element within the same component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MutationActionSetStateParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<MutationActionSetStateParameter.Builder, MutationActionSetStateParameter> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(MutationActionSetStateParameter::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<String> PROPERTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("property").getter(getter(MutationActionSetStateParameter::property)).setter(setter(Builder::property))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("property").build()).build();

    private static final SdkField<ComponentProperty> SET_FIELD = SdkField.<ComponentProperty> builder(MarshallingType.SDK_POJO)
            .memberName("set").getter(getter(MutationActionSetStateParameter::set)).setter(setter(Builder::set))
            .constructor(ComponentProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("set").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD,
            PROPERTY_FIELD, SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String componentName;

    private final String property;

    private final ComponentProperty set;

    private MutationActionSetStateParameter(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.property = builder.property;
        this.set = builder.set;
    }

    /**
     * <p>
     * The name of the component that is being modified.
     * </p>
     * 
     * @return The name of the component that is being modified.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The name of the component property to apply the state configuration to.
     * </p>
     * 
     * @return The name of the component property to apply the state configuration to.
     */
    public final String property() {
        return property;
    }

    /**
     * <p>
     * The state configuration to assign to the property.
     * </p>
     * 
     * @return The state configuration to assign to the property.
     */
    public final ComponentProperty set() {
        return set;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(property());
        hashCode = 31 * hashCode + Objects.hashCode(set());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MutationActionSetStateParameter)) {
            return false;
        }
        MutationActionSetStateParameter other = (MutationActionSetStateParameter) obj;
        return Objects.equals(componentName(), other.componentName()) && Objects.equals(property(), other.property())
                && Objects.equals(set(), other.set());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MutationActionSetStateParameter").add("ComponentName", componentName())
                .add("Property", property()).add("Set", set()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "property":
            return Optional.ofNullable(clazz.cast(property()));
        case "set":
            return Optional.ofNullable(clazz.cast(set()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("property", PROPERTY_FIELD);
        map.put("set", SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MutationActionSetStateParameter, T> g) {
        return obj -> g.apply((MutationActionSetStateParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MutationActionSetStateParameter> {
        /**
         * <p>
         * The name of the component that is being modified.
         * </p>
         * 
         * @param componentName
         *        The name of the component that is being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The name of the component property to apply the state configuration to.
         * </p>
         * 
         * @param property
         *        The name of the component property to apply the state configuration to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder property(String property);

        /**
         * <p>
         * The state configuration to assign to the property.
         * </p>
         * 
         * @param set
         *        The state configuration to assign to the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder set(ComponentProperty set);

        /**
         * <p>
         * The state configuration to assign to the property.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentProperty.Builder} avoiding the
         * need to create one manually via {@link ComponentProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentProperty.Builder#build()} is called immediately and its
         * result is passed to {@link #set(ComponentProperty)}.
         * 
         * @param set
         *        a consumer that will call methods on {@link ComponentProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #set(ComponentProperty)
         */
        default Builder set(Consumer<ComponentProperty.Builder> set) {
            return set(ComponentProperty.builder().applyMutation(set).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String componentName;

        private String property;

        private ComponentProperty set;

        private BuilderImpl() {
        }

        private BuilderImpl(MutationActionSetStateParameter model) {
            componentName(model.componentName);
            property(model.property);
            set(model.set);
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getProperty() {
            return property;
        }

        public final void setProperty(String property) {
            this.property = property;
        }

        @Override
        public final Builder property(String property) {
            this.property = property;
            return this;
        }

        public final ComponentProperty.Builder getSet() {
            return set != null ? set.toBuilder() : null;
        }

        public final void setSet(ComponentProperty.BuilderImpl set) {
            this.set = set != null ? set.build() : null;
        }

        @Override
        @Transient
        public final Builder set(ComponentProperty set) {
            this.set = set;
            return this;
        }

        @Override
        public MutationActionSetStateParameter build() {
            return new MutationActionSetStateParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
