/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifyuibuilder.model.NumValuesCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.StrValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldValidationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldValidationConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FieldValidationConfiguration.getter(FieldValidationConfiguration::type)).setter(FieldValidationConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<String>> STR_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("strValues").getter(FieldValidationConfiguration.getter(FieldValidationConfiguration::strValues)).setter(FieldValidationConfiguration.setter(Builder::strValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> NUM_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("numValues").getter(FieldValidationConfiguration.getter(FieldValidationConfiguration::numValues)).setter(FieldValidationConfiguration.setter(Builder::numValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VALIDATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationMessage").getter(FieldValidationConfiguration.getter(FieldValidationConfiguration::validationMessage)).setter(FieldValidationConfiguration.setter(Builder::validationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, STR_VALUES_FIELD, NUM_VALUES_FIELD, VALIDATION_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FieldValidationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<String> strValues;
    private final List<Integer> numValues;
    private final String validationMessage;

    private FieldValidationConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.strValues = builder.strValues;
        this.numValues = builder.numValues;
        this.validationMessage = builder.validationMessage;
    }

    public final String type() {
        return this.type;
    }

    public final boolean hasStrValues() {
        return this.strValues != null && !(this.strValues instanceof SdkAutoConstructList);
    }

    public final List<String> strValues() {
        return this.strValues;
    }

    public final boolean hasNumValues() {
        return this.numValues != null && !(this.numValues instanceof SdkAutoConstructList);
    }

    public final List<Integer> numValues() {
        return this.numValues;
    }

    public final String validationMessage() {
        return this.validationMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStrValues() ? this.strValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNumValues() ? this.numValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.validationMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldValidationConfiguration)) {
            return false;
        }
        FieldValidationConfiguration other = (FieldValidationConfiguration)obj;
        return Objects.equals(this.type(), other.type()) && this.hasStrValues() == other.hasStrValues() && Objects.equals(this.strValues(), other.strValues()) && this.hasNumValues() == other.hasNumValues() && Objects.equals(this.numValues(), other.numValues()) && Objects.equals(this.validationMessage(), other.validationMessage());
    }

    public final String toString() {
        return ToString.builder((String)"FieldValidationConfiguration").add("Type", (Object)this.type()).add("StrValues", this.hasStrValues() ? this.strValues() : null).add("NumValues", this.hasNumValues() ? this.numValues() : null).add("ValidationMessage", (Object)this.validationMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "strValues": {
                return Optional.ofNullable(clazz.cast(this.strValues()));
            }
            case "numValues": {
                return Optional.ofNullable(clazz.cast(this.numValues()));
            }
            case "validationMessage": {
                return Optional.ofNullable(clazz.cast(this.validationMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("strValues", STR_VALUES_FIELD);
        map.put("numValues", NUM_VALUES_FIELD);
        map.put("validationMessage", VALIDATION_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldValidationConfiguration, T> g) {
        return obj -> g.apply((FieldValidationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<String> strValues = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> numValues = DefaultSdkAutoConstructList.getInstance();
        private String validationMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldValidationConfiguration model) {
            this.type(model.type);
            this.strValues(model.strValues);
            this.numValues(model.numValues);
            this.validationMessage(model.validationMessage);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Collection<String> getStrValues() {
            if (this.strValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.strValues;
        }

        public final void setStrValues(Collection<String> strValues) {
            this.strValues = StrValuesCopier.copy(strValues);
        }

        @Override
        public final Builder strValues(Collection<String> strValues) {
            this.strValues = StrValuesCopier.copy(strValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder strValues(String ... strValues) {
            this.strValues(Arrays.asList(strValues));
            return this;
        }

        public final Collection<Integer> getNumValues() {
            if (this.numValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.numValues;
        }

        public final void setNumValues(Collection<Integer> numValues) {
            this.numValues = NumValuesCopier.copy(numValues);
        }

        @Override
        public final Builder numValues(Collection<Integer> numValues) {
            this.numValues = NumValuesCopier.copy(numValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numValues(Integer ... numValues) {
            this.numValues(Arrays.asList(numValues));
            return this;
        }

        public final String getValidationMessage() {
            return this.validationMessage;
        }

        public final void setValidationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
        }

        @Override
        public final Builder validationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
            return this;
        }

        public FieldValidationConfiguration build() {
            return new FieldValidationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldValidationConfiguration> {
        public Builder type(String var1);

        public Builder strValues(Collection<String> var1);

        public Builder strValues(String ... var1);

        public Builder numValues(Collection<Integer> var1);

        public Builder numValues(Integer ... var1);

        public Builder validationMessage(String var1);
    }
}

