/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JSModule {
    ES2020("es2020"),
    ESNEXT("esnext"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JSModule> VALUE_MAP;
    private final String value;

    private JSModule(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JSModule fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JSModule> knownValues() {
        EnumSet<JSModule> knownValues = EnumSet.allOf(JSModule.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JSModule.class, JSModule::toString);
    }
}

