/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the API configuration for a code generation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApiConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ApiConfiguration.Builder, ApiConfiguration> {
    private static final SdkField<GraphQLRenderConfig> GRAPH_QL_CONFIG_FIELD = SdkField
            .<GraphQLRenderConfig> builder(MarshallingType.SDK_POJO).memberName("graphQLConfig")
            .getter(getter(ApiConfiguration::graphQLConfig)).setter(setter(Builder::graphQLConfig))
            .constructor(GraphQLRenderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphQLConfig").build()).build();

    private static final SdkField<DataStoreRenderConfig> DATA_STORE_CONFIG_FIELD = SdkField
            .<DataStoreRenderConfig> builder(MarshallingType.SDK_POJO).memberName("dataStoreConfig")
            .getter(getter(ApiConfiguration::dataStoreConfig)).setter(setter(Builder::dataStoreConfig))
            .constructor(DataStoreRenderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataStoreConfig").build()).build();

    private static final SdkField<NoApiRenderConfig> NO_API_CONFIG_FIELD = SdkField
            .<NoApiRenderConfig> builder(MarshallingType.SDK_POJO).memberName("noApiConfig")
            .getter(getter(ApiConfiguration::noApiConfig)).setter(setter(Builder::noApiConfig))
            .constructor(NoApiRenderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noApiConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_QL_CONFIG_FIELD,
            DATA_STORE_CONFIG_FIELD, NO_API_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GraphQLRenderConfig graphQLConfig;

    private final DataStoreRenderConfig dataStoreConfig;

    private final NoApiRenderConfig noApiConfig;

    private final Type type;

    private ApiConfiguration(BuilderImpl builder) {
        this.graphQLConfig = builder.graphQLConfig;
        this.dataStoreConfig = builder.dataStoreConfig;
        this.noApiConfig = builder.noApiConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * The configuration for an application using GraphQL APIs.
     * </p>
     * 
     * @return The configuration for an application using GraphQL APIs.
     */
    public final GraphQLRenderConfig graphQLConfig() {
        return graphQLConfig;
    }

    /**
     * <p>
     * The configuration for an application using DataStore APIs.
     * </p>
     * 
     * @return The configuration for an application using DataStore APIs.
     */
    public final DataStoreRenderConfig dataStoreConfig() {
        return dataStoreConfig;
    }

    /**
     * <p>
     * The configuration for an application with no API being used.
     * </p>
     * 
     * @return The configuration for an application with no API being used.
     */
    public final NoApiRenderConfig noApiConfig() {
        return noApiConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(graphQLConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dataStoreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(noApiConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiConfiguration)) {
            return false;
        }
        ApiConfiguration other = (ApiConfiguration) obj;
        return Objects.equals(graphQLConfig(), other.graphQLConfig())
                && Objects.equals(dataStoreConfig(), other.dataStoreConfig())
                && Objects.equals(noApiConfig(), other.noApiConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApiConfiguration").add("GraphQLConfig", graphQLConfig())
                .add("DataStoreConfig", dataStoreConfig()).add("NoApiConfig", noApiConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graphQLConfig":
            return Optional.ofNullable(clazz.cast(graphQLConfig()));
        case "dataStoreConfig":
            return Optional.ofNullable(clazz.cast(dataStoreConfig()));
        case "noApiConfig":
            return Optional.ofNullable(clazz.cast(noApiConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #graphQLConfig()} initialized to the given value.
     *
     * <p>
     * The configuration for an application using GraphQL APIs.
     * </p>
     * 
     * @param graphQLConfig
     *        The configuration for an application using GraphQL APIs.
     */
    public static ApiConfiguration fromGraphQLConfig(GraphQLRenderConfig graphQLConfig) {
        return builder().graphQLConfig(graphQLConfig).build();
    }

    /**
     * Create an instance of this class with {@link #graphQLConfig()} initialized to the given value.
     *
     * <p>
     * The configuration for an application using GraphQL APIs.
     * </p>
     * 
     * @param graphQLConfig
     *        The configuration for an application using GraphQL APIs.
     */
    public static ApiConfiguration fromGraphQLConfig(Consumer<GraphQLRenderConfig.Builder> graphQLConfig) {
        GraphQLRenderConfig.Builder builder = GraphQLRenderConfig.builder();
        graphQLConfig.accept(builder);
        return fromGraphQLConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dataStoreConfig()} initialized to the given value.
     *
     * <p>
     * The configuration for an application using DataStore APIs.
     * </p>
     * 
     * @param dataStoreConfig
     *        The configuration for an application using DataStore APIs.
     */
    public static ApiConfiguration fromDataStoreConfig(DataStoreRenderConfig dataStoreConfig) {
        return builder().dataStoreConfig(dataStoreConfig).build();
    }

    /**
     * Create an instance of this class with {@link #dataStoreConfig()} initialized to the given value.
     *
     * <p>
     * The configuration for an application using DataStore APIs.
     * </p>
     * 
     * @param dataStoreConfig
     *        The configuration for an application using DataStore APIs.
     */
    public static ApiConfiguration fromDataStoreConfig(Consumer<DataStoreRenderConfig.Builder> dataStoreConfig) {
        DataStoreRenderConfig.Builder builder = DataStoreRenderConfig.builder();
        dataStoreConfig.accept(builder);
        return fromDataStoreConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #noApiConfig()} initialized to the given value.
     *
     * <p>
     * The configuration for an application with no API being used.
     * </p>
     * 
     * @param noApiConfig
     *        The configuration for an application with no API being used.
     */
    public static ApiConfiguration fromNoApiConfig(NoApiRenderConfig noApiConfig) {
        return builder().noApiConfig(noApiConfig).build();
    }

    /**
     * Create an instance of this class with {@link #noApiConfig()} initialized to the given value.
     *
     * <p>
     * The configuration for an application with no API being used.
     * </p>
     * 
     * @param noApiConfig
     *        The configuration for an application with no API being used.
     */
    public static ApiConfiguration fromNoApiConfig(Consumer<NoApiRenderConfig.Builder> noApiConfig) {
        NoApiRenderConfig.Builder builder = NoApiRenderConfig.builder();
        noApiConfig.accept(builder);
        return fromNoApiConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("graphQLConfig", GRAPH_QL_CONFIG_FIELD);
        map.put("dataStoreConfig", DATA_STORE_CONFIG_FIELD);
        map.put("noApiConfig", NO_API_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiConfiguration, T> g) {
        return obj -> g.apply((ApiConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApiConfiguration> {
        /**
         * <p>
         * The configuration for an application using GraphQL APIs.
         * </p>
         * 
         * @param graphQLConfig
         *        The configuration for an application using GraphQL APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphQLConfig(GraphQLRenderConfig graphQLConfig);

        /**
         * <p>
         * The configuration for an application using GraphQL APIs.
         * </p>
         * This is a convenience method that creates an instance of the {@link GraphQLRenderConfig.Builder} avoiding the
         * need to create one manually via {@link GraphQLRenderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GraphQLRenderConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #graphQLConfig(GraphQLRenderConfig)}.
         * 
         * @param graphQLConfig
         *        a consumer that will call methods on {@link GraphQLRenderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #graphQLConfig(GraphQLRenderConfig)
         */
        default Builder graphQLConfig(Consumer<GraphQLRenderConfig.Builder> graphQLConfig) {
            return graphQLConfig(GraphQLRenderConfig.builder().applyMutation(graphQLConfig).build());
        }

        /**
         * <p>
         * The configuration for an application using DataStore APIs.
         * </p>
         * 
         * @param dataStoreConfig
         *        The configuration for an application using DataStore APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStoreConfig(DataStoreRenderConfig dataStoreConfig);

        /**
         * <p>
         * The configuration for an application using DataStore APIs.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataStoreRenderConfig.Builder} avoiding
         * the need to create one manually via {@link DataStoreRenderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataStoreRenderConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #dataStoreConfig(DataStoreRenderConfig)}.
         * 
         * @param dataStoreConfig
         *        a consumer that will call methods on {@link DataStoreRenderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataStoreConfig(DataStoreRenderConfig)
         */
        default Builder dataStoreConfig(Consumer<DataStoreRenderConfig.Builder> dataStoreConfig) {
            return dataStoreConfig(DataStoreRenderConfig.builder().applyMutation(dataStoreConfig).build());
        }

        /**
         * <p>
         * The configuration for an application with no API being used.
         * </p>
         * 
         * @param noApiConfig
         *        The configuration for an application with no API being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noApiConfig(NoApiRenderConfig noApiConfig);

        /**
         * <p>
         * The configuration for an application with no API being used.
         * </p>
         * This is a convenience method that creates an instance of the {@link NoApiRenderConfig.Builder} avoiding the
         * need to create one manually via {@link NoApiRenderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NoApiRenderConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #noApiConfig(NoApiRenderConfig)}.
         * 
         * @param noApiConfig
         *        a consumer that will call methods on {@link NoApiRenderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noApiConfig(NoApiRenderConfig)
         */
        default Builder noApiConfig(Consumer<NoApiRenderConfig.Builder> noApiConfig) {
            return noApiConfig(NoApiRenderConfig.builder().applyMutation(noApiConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GraphQLRenderConfig graphQLConfig;

        private DataStoreRenderConfig dataStoreConfig;

        private NoApiRenderConfig noApiConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ApiConfiguration model) {
            graphQLConfig(model.graphQLConfig);
            dataStoreConfig(model.dataStoreConfig);
            noApiConfig(model.noApiConfig);
        }

        public final GraphQLRenderConfig.Builder getGraphQLConfig() {
            return graphQLConfig != null ? graphQLConfig.toBuilder() : null;
        }

        public final void setGraphQLConfig(GraphQLRenderConfig.BuilderImpl graphQLConfig) {
            Object oldValue = this.graphQLConfig;
            this.graphQLConfig = graphQLConfig != null ? graphQLConfig.build() : null;
            handleUnionValueChange(Type.GRAPH_QL_CONFIG, oldValue, this.graphQLConfig);
        }

        @Override
        public final Builder graphQLConfig(GraphQLRenderConfig graphQLConfig) {
            Object oldValue = this.graphQLConfig;
            this.graphQLConfig = graphQLConfig;
            handleUnionValueChange(Type.GRAPH_QL_CONFIG, oldValue, this.graphQLConfig);
            return this;
        }

        public final DataStoreRenderConfig.Builder getDataStoreConfig() {
            return dataStoreConfig != null ? dataStoreConfig.toBuilder() : null;
        }

        public final void setDataStoreConfig(DataStoreRenderConfig.BuilderImpl dataStoreConfig) {
            Object oldValue = this.dataStoreConfig;
            this.dataStoreConfig = dataStoreConfig != null ? dataStoreConfig.build() : null;
            handleUnionValueChange(Type.DATA_STORE_CONFIG, oldValue, this.dataStoreConfig);
        }

        @Override
        public final Builder dataStoreConfig(DataStoreRenderConfig dataStoreConfig) {
            Object oldValue = this.dataStoreConfig;
            this.dataStoreConfig = dataStoreConfig;
            handleUnionValueChange(Type.DATA_STORE_CONFIG, oldValue, this.dataStoreConfig);
            return this;
        }

        public final NoApiRenderConfig.Builder getNoApiConfig() {
            return noApiConfig != null ? noApiConfig.toBuilder() : null;
        }

        public final void setNoApiConfig(NoApiRenderConfig.BuilderImpl noApiConfig) {
            Object oldValue = this.noApiConfig;
            this.noApiConfig = noApiConfig != null ? noApiConfig.build() : null;
            handleUnionValueChange(Type.NO_API_CONFIG, oldValue, this.noApiConfig);
        }

        @Override
        public final Builder noApiConfig(NoApiRenderConfig noApiConfig) {
            Object oldValue = this.noApiConfig;
            this.noApiConfig = noApiConfig;
            handleUnionValueChange(Type.NO_API_CONFIG, oldValue, this.noApiConfig);
            return this;
        }

        @Override
        public ApiConfiguration build() {
            return new ApiConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ApiConfiguration#type()
     */
    public enum Type {
        GRAPH_QL_CONFIG,

        DATA_STORE_CONFIG,

        NO_API_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
