/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the relationship between generic data models.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodegenGenericDataRelationshipType implements SdkPojo, Serializable,
        ToCopyableBuilder<CodegenGenericDataRelationshipType.Builder, CodegenGenericDataRelationshipType> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CodegenGenericDataRelationshipType::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> RELATED_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relatedModelName").getter(getter(CodegenGenericDataRelationshipType::relatedModelName))
            .setter(setter(Builder::relatedModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedModelName").build()).build();

    private static final SdkField<List<String>> RELATED_MODEL_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("relatedModelFields")
            .getter(getter(CodegenGenericDataRelationshipType::relatedModelFields))
            .setter(setter(Builder::relatedModelFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedModelFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> CAN_UNLINK_ASSOCIATED_MODEL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("canUnlinkAssociatedModel")
            .getter(getter(CodegenGenericDataRelationshipType::canUnlinkAssociatedModel))
            .setter(setter(Builder::canUnlinkAssociatedModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canUnlinkAssociatedModel").build())
            .build();

    private static final SdkField<String> RELATED_JOIN_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relatedJoinFieldName").getter(getter(CodegenGenericDataRelationshipType::relatedJoinFieldName))
            .setter(setter(Builder::relatedJoinFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedJoinFieldName").build())
            .build();

    private static final SdkField<String> RELATED_JOIN_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relatedJoinTableName").getter(getter(CodegenGenericDataRelationshipType::relatedJoinTableName))
            .setter(setter(Builder::relatedJoinTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedJoinTableName").build())
            .build();

    private static final SdkField<String> BELONGS_TO_FIELD_ON_RELATED_MODEL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("belongsToFieldOnRelatedModel")
            .getter(getter(CodegenGenericDataRelationshipType::belongsToFieldOnRelatedModel))
            .setter(setter(Builder::belongsToFieldOnRelatedModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("belongsToFieldOnRelatedModel")
                    .build()).build();

    private static final SdkField<List<String>> ASSOCIATED_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedFields")
            .getter(getter(CodegenGenericDataRelationshipType::associatedFields))
            .setter(setter(Builder::associatedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_HAS_MANY_INDEX_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isHasManyIndex").getter(getter(CodegenGenericDataRelationshipType::isHasManyIndex))
            .setter(setter(Builder::isHasManyIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isHasManyIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            RELATED_MODEL_NAME_FIELD, RELATED_MODEL_FIELDS_FIELD, CAN_UNLINK_ASSOCIATED_MODEL_FIELD,
            RELATED_JOIN_FIELD_NAME_FIELD, RELATED_JOIN_TABLE_NAME_FIELD, BELONGS_TO_FIELD_ON_RELATED_MODEL_FIELD,
            ASSOCIATED_FIELDS_FIELD, IS_HAS_MANY_INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String relatedModelName;

    private final List<String> relatedModelFields;

    private final Boolean canUnlinkAssociatedModel;

    private final String relatedJoinFieldName;

    private final String relatedJoinTableName;

    private final String belongsToFieldOnRelatedModel;

    private final List<String> associatedFields;

    private final Boolean isHasManyIndex;

    private CodegenGenericDataRelationshipType(BuilderImpl builder) {
        this.type = builder.type;
        this.relatedModelName = builder.relatedModelName;
        this.relatedModelFields = builder.relatedModelFields;
        this.canUnlinkAssociatedModel = builder.canUnlinkAssociatedModel;
        this.relatedJoinFieldName = builder.relatedJoinFieldName;
        this.relatedJoinTableName = builder.relatedJoinTableName;
        this.belongsToFieldOnRelatedModel = builder.belongsToFieldOnRelatedModel;
        this.associatedFields = builder.associatedFields;
        this.isHasManyIndex = builder.isHasManyIndex;
    }

    /**
     * <p>
     * The data relationship type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GenericDataRelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The data relationship type.
     * @see GenericDataRelationshipType
     */
    public final GenericDataRelationshipType type() {
        return GenericDataRelationshipType.fromValue(type);
    }

    /**
     * <p>
     * The data relationship type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GenericDataRelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The data relationship type.
     * @see GenericDataRelationshipType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the related model in the data relationship.
     * </p>
     * 
     * @return The name of the related model in the data relationship.
     */
    public final String relatedModelName() {
        return relatedModelName;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelatedModelFields property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRelatedModelFields() {
        return relatedModelFields != null && !(relatedModelFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The related model fields in the data relationship.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelatedModelFields} method.
     * </p>
     * 
     * @return The related model fields in the data relationship.
     */
    public final List<String> relatedModelFields() {
        return relatedModelFields;
    }

    /**
     * <p>
     * Specifies whether the relationship can unlink the associated model.
     * </p>
     * 
     * @return Specifies whether the relationship can unlink the associated model.
     */
    public final Boolean canUnlinkAssociatedModel() {
        return canUnlinkAssociatedModel;
    }

    /**
     * <p>
     * The name of the related join field in the data relationship.
     * </p>
     * 
     * @return The name of the related join field in the data relationship.
     */
    public final String relatedJoinFieldName() {
        return relatedJoinFieldName;
    }

    /**
     * <p>
     * The name of the related join table in the data relationship.
     * </p>
     * 
     * @return The name of the related join table in the data relationship.
     */
    public final String relatedJoinTableName() {
        return relatedJoinTableName;
    }

    /**
     * <p>
     * The value of the <code>belongsTo</code> field on the related data model.
     * </p>
     * 
     * @return The value of the <code>belongsTo</code> field on the related data model.
     */
    public final String belongsToFieldOnRelatedModel() {
        return belongsToFieldOnRelatedModel;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedFields() {
        return associatedFields != null && !(associatedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The associated fields of the data relationship.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedFields} method.
     * </p>
     * 
     * @return The associated fields of the data relationship.
     */
    public final List<String> associatedFields() {
        return associatedFields;
    }

    /**
     * <p>
     * Specifies whether the <code>@index</code> directive is supported for a <code>hasMany</code> data relationship.
     * </p>
     * 
     * @return Specifies whether the <code>@index</code> directive is supported for a <code>hasMany</code> data
     *         relationship.
     */
    public final Boolean isHasManyIndex() {
        return isHasManyIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relatedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedModelFields() ? relatedModelFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(canUnlinkAssociatedModel());
        hashCode = 31 * hashCode + Objects.hashCode(relatedJoinFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(relatedJoinTableName());
        hashCode = 31 * hashCode + Objects.hashCode(belongsToFieldOnRelatedModel());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedFields() ? associatedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isHasManyIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodegenGenericDataRelationshipType)) {
            return false;
        }
        CodegenGenericDataRelationshipType other = (CodegenGenericDataRelationshipType) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(relatedModelName(), other.relatedModelName())
                && hasRelatedModelFields() == other.hasRelatedModelFields()
                && Objects.equals(relatedModelFields(), other.relatedModelFields())
                && Objects.equals(canUnlinkAssociatedModel(), other.canUnlinkAssociatedModel())
                && Objects.equals(relatedJoinFieldName(), other.relatedJoinFieldName())
                && Objects.equals(relatedJoinTableName(), other.relatedJoinTableName())
                && Objects.equals(belongsToFieldOnRelatedModel(), other.belongsToFieldOnRelatedModel())
                && hasAssociatedFields() == other.hasAssociatedFields()
                && Objects.equals(associatedFields(), other.associatedFields())
                && Objects.equals(isHasManyIndex(), other.isHasManyIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodegenGenericDataRelationshipType").add("Type", typeAsString())
                .add("RelatedModelName", relatedModelName())
                .add("RelatedModelFields", hasRelatedModelFields() ? relatedModelFields() : null)
                .add("CanUnlinkAssociatedModel", canUnlinkAssociatedModel()).add("RelatedJoinFieldName", relatedJoinFieldName())
                .add("RelatedJoinTableName", relatedJoinTableName())
                .add("BelongsToFieldOnRelatedModel", belongsToFieldOnRelatedModel())
                .add("AssociatedFields", hasAssociatedFields() ? associatedFields() : null)
                .add("IsHasManyIndex", isHasManyIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "relatedModelName":
            return Optional.ofNullable(clazz.cast(relatedModelName()));
        case "relatedModelFields":
            return Optional.ofNullable(clazz.cast(relatedModelFields()));
        case "canUnlinkAssociatedModel":
            return Optional.ofNullable(clazz.cast(canUnlinkAssociatedModel()));
        case "relatedJoinFieldName":
            return Optional.ofNullable(clazz.cast(relatedJoinFieldName()));
        case "relatedJoinTableName":
            return Optional.ofNullable(clazz.cast(relatedJoinTableName()));
        case "belongsToFieldOnRelatedModel":
            return Optional.ofNullable(clazz.cast(belongsToFieldOnRelatedModel()));
        case "associatedFields":
            return Optional.ofNullable(clazz.cast(associatedFields()));
        case "isHasManyIndex":
            return Optional.ofNullable(clazz.cast(isHasManyIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("relatedModelName", RELATED_MODEL_NAME_FIELD);
        map.put("relatedModelFields", RELATED_MODEL_FIELDS_FIELD);
        map.put("canUnlinkAssociatedModel", CAN_UNLINK_ASSOCIATED_MODEL_FIELD);
        map.put("relatedJoinFieldName", RELATED_JOIN_FIELD_NAME_FIELD);
        map.put("relatedJoinTableName", RELATED_JOIN_TABLE_NAME_FIELD);
        map.put("belongsToFieldOnRelatedModel", BELONGS_TO_FIELD_ON_RELATED_MODEL_FIELD);
        map.put("associatedFields", ASSOCIATED_FIELDS_FIELD);
        map.put("isHasManyIndex", IS_HAS_MANY_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodegenGenericDataRelationshipType, T> g) {
        return obj -> g.apply((CodegenGenericDataRelationshipType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodegenGenericDataRelationshipType> {
        /**
         * <p>
         * The data relationship type.
         * </p>
         * 
         * @param type
         *        The data relationship type.
         * @see GenericDataRelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenericDataRelationshipType
         */
        Builder type(String type);

        /**
         * <p>
         * The data relationship type.
         * </p>
         * 
         * @param type
         *        The data relationship type.
         * @see GenericDataRelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenericDataRelationshipType
         */
        Builder type(GenericDataRelationshipType type);

        /**
         * <p>
         * The name of the related model in the data relationship.
         * </p>
         * 
         * @param relatedModelName
         *        The name of the related model in the data relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedModelName(String relatedModelName);

        /**
         * <p>
         * The related model fields in the data relationship.
         * </p>
         * 
         * @param relatedModelFields
         *        The related model fields in the data relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedModelFields(Collection<String> relatedModelFields);

        /**
         * <p>
         * The related model fields in the data relationship.
         * </p>
         * 
         * @param relatedModelFields
         *        The related model fields in the data relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedModelFields(String... relatedModelFields);

        /**
         * <p>
         * Specifies whether the relationship can unlink the associated model.
         * </p>
         * 
         * @param canUnlinkAssociatedModel
         *        Specifies whether the relationship can unlink the associated model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canUnlinkAssociatedModel(Boolean canUnlinkAssociatedModel);

        /**
         * <p>
         * The name of the related join field in the data relationship.
         * </p>
         * 
         * @param relatedJoinFieldName
         *        The name of the related join field in the data relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedJoinFieldName(String relatedJoinFieldName);

        /**
         * <p>
         * The name of the related join table in the data relationship.
         * </p>
         * 
         * @param relatedJoinTableName
         *        The name of the related join table in the data relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedJoinTableName(String relatedJoinTableName);

        /**
         * <p>
         * The value of the <code>belongsTo</code> field on the related data model.
         * </p>
         * 
         * @param belongsToFieldOnRelatedModel
         *        The value of the <code>belongsTo</code> field on the related data model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder belongsToFieldOnRelatedModel(String belongsToFieldOnRelatedModel);

        /**
         * <p>
         * The associated fields of the data relationship.
         * </p>
         * 
         * @param associatedFields
         *        The associated fields of the data relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedFields(Collection<String> associatedFields);

        /**
         * <p>
         * The associated fields of the data relationship.
         * </p>
         * 
         * @param associatedFields
         *        The associated fields of the data relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedFields(String... associatedFields);

        /**
         * <p>
         * Specifies whether the <code>@index</code> directive is supported for a <code>hasMany</code> data
         * relationship.
         * </p>
         * 
         * @param isHasManyIndex
         *        Specifies whether the <code>@index</code> directive is supported for a <code>hasMany</code> data
         *        relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isHasManyIndex(Boolean isHasManyIndex);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String relatedModelName;

        private List<String> relatedModelFields = DefaultSdkAutoConstructList.getInstance();

        private Boolean canUnlinkAssociatedModel;

        private String relatedJoinFieldName;

        private String relatedJoinTableName;

        private String belongsToFieldOnRelatedModel;

        private List<String> associatedFields = DefaultSdkAutoConstructList.getInstance();

        private Boolean isHasManyIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(CodegenGenericDataRelationshipType model) {
            type(model.type);
            relatedModelName(model.relatedModelName);
            relatedModelFields(model.relatedModelFields);
            canUnlinkAssociatedModel(model.canUnlinkAssociatedModel);
            relatedJoinFieldName(model.relatedJoinFieldName);
            relatedJoinTableName(model.relatedJoinTableName);
            belongsToFieldOnRelatedModel(model.belongsToFieldOnRelatedModel);
            associatedFields(model.associatedFields);
            isHasManyIndex(model.isHasManyIndex);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GenericDataRelationshipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getRelatedModelName() {
            return relatedModelName;
        }

        public final void setRelatedModelName(String relatedModelName) {
            this.relatedModelName = relatedModelName;
        }

        @Override
        public final Builder relatedModelName(String relatedModelName) {
            this.relatedModelName = relatedModelName;
            return this;
        }

        public final Collection<String> getRelatedModelFields() {
            if (relatedModelFields instanceof SdkAutoConstructList) {
                return null;
            }
            return relatedModelFields;
        }

        public final void setRelatedModelFields(Collection<String> relatedModelFields) {
            this.relatedModelFields = RelatedModelFieldsListCopier.copy(relatedModelFields);
        }

        @Override
        public final Builder relatedModelFields(Collection<String> relatedModelFields) {
            this.relatedModelFields = RelatedModelFieldsListCopier.copy(relatedModelFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedModelFields(String... relatedModelFields) {
            relatedModelFields(Arrays.asList(relatedModelFields));
            return this;
        }

        public final Boolean getCanUnlinkAssociatedModel() {
            return canUnlinkAssociatedModel;
        }

        public final void setCanUnlinkAssociatedModel(Boolean canUnlinkAssociatedModel) {
            this.canUnlinkAssociatedModel = canUnlinkAssociatedModel;
        }

        @Override
        public final Builder canUnlinkAssociatedModel(Boolean canUnlinkAssociatedModel) {
            this.canUnlinkAssociatedModel = canUnlinkAssociatedModel;
            return this;
        }

        public final String getRelatedJoinFieldName() {
            return relatedJoinFieldName;
        }

        public final void setRelatedJoinFieldName(String relatedJoinFieldName) {
            this.relatedJoinFieldName = relatedJoinFieldName;
        }

        @Override
        public final Builder relatedJoinFieldName(String relatedJoinFieldName) {
            this.relatedJoinFieldName = relatedJoinFieldName;
            return this;
        }

        public final String getRelatedJoinTableName() {
            return relatedJoinTableName;
        }

        public final void setRelatedJoinTableName(String relatedJoinTableName) {
            this.relatedJoinTableName = relatedJoinTableName;
        }

        @Override
        public final Builder relatedJoinTableName(String relatedJoinTableName) {
            this.relatedJoinTableName = relatedJoinTableName;
            return this;
        }

        public final String getBelongsToFieldOnRelatedModel() {
            return belongsToFieldOnRelatedModel;
        }

        public final void setBelongsToFieldOnRelatedModel(String belongsToFieldOnRelatedModel) {
            this.belongsToFieldOnRelatedModel = belongsToFieldOnRelatedModel;
        }

        @Override
        public final Builder belongsToFieldOnRelatedModel(String belongsToFieldOnRelatedModel) {
            this.belongsToFieldOnRelatedModel = belongsToFieldOnRelatedModel;
            return this;
        }

        public final Collection<String> getAssociatedFields() {
            if (associatedFields instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedFields;
        }

        public final void setAssociatedFields(Collection<String> associatedFields) {
            this.associatedFields = AssociatedFieldsListCopier.copy(associatedFields);
        }

        @Override
        public final Builder associatedFields(Collection<String> associatedFields) {
            this.associatedFields = AssociatedFieldsListCopier.copy(associatedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedFields(String... associatedFields) {
            associatedFields(Arrays.asList(associatedFields));
            return this;
        }

        public final Boolean getIsHasManyIndex() {
            return isHasManyIndex;
        }

        public final void setIsHasManyIndex(Boolean isHasManyIndex) {
            this.isHasManyIndex = isHasManyIndex;
        }

        @Override
        public final Builder isHasManyIndex(Boolean isHasManyIndex) {
            this.isHasManyIndex = isHasManyIndex;
            return this;
        }

        @Override
        public CodegenGenericDataRelationshipType build() {
            return new CodegenGenericDataRelationshipType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
