/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a conditional expression to set a component property. Use <code>ComponentConditionProperty</code> to set a
 * property to different values conditionally, based on the value of another property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentConditionProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentConditionProperty.Builder, ComponentConditionProperty> {
    private static final SdkField<String> PROPERTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("property").getter(getter(ComponentConditionProperty::property)).setter(setter(Builder::property))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("property").build()).build();

    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("field")
            .getter(getter(ComponentConditionProperty::field)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operator").getter(getter(ComponentConditionProperty::operator)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final SdkField<String> OPERAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("operand")
            .getter(getter(ComponentConditionProperty::operand)).setter(setter(Builder::operand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operand").build()).build();

    private static final SdkField<ComponentProperty> THEN_FIELD = SdkField.<ComponentProperty> builder(MarshallingType.SDK_POJO)
            .memberName("then").getter(getter(ComponentConditionProperty::then)).setter(setter(Builder::then))
            .constructor(ComponentProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("then").build()).build();

    private static final SdkField<ComponentProperty> ELSE_FIELD = SdkField.<ComponentProperty> builder(MarshallingType.SDK_POJO)
            .memberName("else").getter(getter(ComponentConditionProperty::elseValue)).setter(setter(Builder::elseValue))
            .constructor(ComponentProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("else").build()).build();

    private static final SdkField<String> OPERAND_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operandType").getter(getter(ComponentConditionProperty::operandType))
            .setter(setter(Builder::operandType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operandType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_FIELD, FIELD_FIELD,
            OPERATOR_FIELD, OPERAND_FIELD, THEN_FIELD, ELSE_FIELD, OPERAND_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String property;

    private final String field;

    private final String operator;

    private final String operand;

    private final ComponentProperty then;

    private final ComponentProperty elseValue;

    private final String operandType;

    private ComponentConditionProperty(BuilderImpl builder) {
        this.property = builder.property;
        this.field = builder.field;
        this.operator = builder.operator;
        this.operand = builder.operand;
        this.then = builder.then;
        this.elseValue = builder.elseValue;
        this.operandType = builder.operandType;
    }

    /**
     * <p>
     * The name of the conditional property.
     * </p>
     * 
     * @return The name of the conditional property.
     */
    public final String property() {
        return property;
    }

    /**
     * <p>
     * The name of a field. Specify this when the property is a data model.
     * </p>
     * 
     * @return The name of a field. Specify this when the property is a data model.
     */
    public final String field() {
        return field;
    }

    /**
     * <p>
     * The operator to use to perform the evaluation, such as <code>eq</code> to represent equals.
     * </p>
     * 
     * @return The operator to use to perform the evaluation, such as <code>eq</code> to represent equals.
     */
    public final String operator() {
        return operator;
    }

    /**
     * <p>
     * The value of the property to evaluate.
     * </p>
     * 
     * @return The value of the property to evaluate.
     */
    public final String operand() {
        return operand;
    }

    /**
     * <p>
     * The value to assign to the property if the condition is met.
     * </p>
     * 
     * @return The value to assign to the property if the condition is met.
     */
    public final ComponentProperty then() {
        return then;
    }

    /**
     * <p>
     * The value to assign to the property if the condition is not met.
     * </p>
     * 
     * @return The value to assign to the property if the condition is not met.
     */
    public final ComponentProperty elseValue() {
        return elseValue;
    }

    /**
     * <p>
     * The type of the property to evaluate.
     * </p>
     * 
     * @return The type of the property to evaluate.
     */
    public final String operandType() {
        return operandType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(property());
        hashCode = 31 * hashCode + Objects.hashCode(field());
        hashCode = 31 * hashCode + Objects.hashCode(operator());
        hashCode = 31 * hashCode + Objects.hashCode(operand());
        hashCode = 31 * hashCode + Objects.hashCode(then());
        hashCode = 31 * hashCode + Objects.hashCode(elseValue());
        hashCode = 31 * hashCode + Objects.hashCode(operandType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentConditionProperty)) {
            return false;
        }
        ComponentConditionProperty other = (ComponentConditionProperty) obj;
        return Objects.equals(property(), other.property()) && Objects.equals(field(), other.field())
                && Objects.equals(operator(), other.operator()) && Objects.equals(operand(), other.operand())
                && Objects.equals(then(), other.then()) && Objects.equals(elseValue(), other.elseValue())
                && Objects.equals(operandType(), other.operandType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentConditionProperty").add("Property", property()).add("Field", field())
                .add("Operator", operator()).add("Operand", operand()).add("Then", then()).add("Else", elseValue())
                .add("OperandType", operandType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "property":
            return Optional.ofNullable(clazz.cast(property()));
        case "field":
            return Optional.ofNullable(clazz.cast(field()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operator()));
        case "operand":
            return Optional.ofNullable(clazz.cast(operand()));
        case "then":
            return Optional.ofNullable(clazz.cast(then()));
        case "else":
            return Optional.ofNullable(clazz.cast(elseValue()));
        case "operandType":
            return Optional.ofNullable(clazz.cast(operandType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("property", PROPERTY_FIELD);
        map.put("field", FIELD_FIELD);
        map.put("operator", OPERATOR_FIELD);
        map.put("operand", OPERAND_FIELD);
        map.put("then", THEN_FIELD);
        map.put("else", ELSE_FIELD);
        map.put("operandType", OPERAND_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentConditionProperty, T> g) {
        return obj -> g.apply((ComponentConditionProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentConditionProperty> {
        /**
         * <p>
         * The name of the conditional property.
         * </p>
         * 
         * @param property
         *        The name of the conditional property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder property(String property);

        /**
         * <p>
         * The name of a field. Specify this when the property is a data model.
         * </p>
         * 
         * @param field
         *        The name of a field. Specify this when the property is a data model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(String field);

        /**
         * <p>
         * The operator to use to perform the evaluation, such as <code>eq</code> to represent equals.
         * </p>
         * 
         * @param operator
         *        The operator to use to perform the evaluation, such as <code>eq</code> to represent equals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operator(String operator);

        /**
         * <p>
         * The value of the property to evaluate.
         * </p>
         * 
         * @param operand
         *        The value of the property to evaluate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operand(String operand);

        /**
         * <p>
         * The value to assign to the property if the condition is met.
         * </p>
         * 
         * @param then
         *        The value to assign to the property if the condition is met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder then(ComponentProperty then);

        /**
         * <p>
         * The value to assign to the property if the condition is met.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentProperty.Builder} avoiding the
         * need to create one manually via {@link ComponentProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentProperty.Builder#build()} is called immediately and its
         * result is passed to {@link #then(ComponentProperty)}.
         * 
         * @param then
         *        a consumer that will call methods on {@link ComponentProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #then(ComponentProperty)
         */
        default Builder then(Consumer<ComponentProperty.Builder> then) {
            return then(ComponentProperty.builder().applyMutation(then).build());
        }

        /**
         * <p>
         * The value to assign to the property if the condition is not met.
         * </p>
         * 
         * @param elseValue
         *        The value to assign to the property if the condition is not met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elseValue(ComponentProperty elseValue);

        /**
         * <p>
         * The value to assign to the property if the condition is not met.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentProperty.Builder} avoiding the
         * need to create one manually via {@link ComponentProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentProperty.Builder#build()} is called immediately and its
         * result is passed to {@link #elseValue(ComponentProperty)}.
         * 
         * @param elseValue
         *        a consumer that will call methods on {@link ComponentProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elseValue(ComponentProperty)
         */
        default Builder elseValue(Consumer<ComponentProperty.Builder> elseValue) {
            return elseValue(ComponentProperty.builder().applyMutation(elseValue).build());
        }

        /**
         * <p>
         * The type of the property to evaluate.
         * </p>
         * 
         * @param operandType
         *        The type of the property to evaluate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operandType(String operandType);
    }

    static final class BuilderImpl implements Builder {
        private String property;

        private String field;

        private String operator;

        private String operand;

        private ComponentProperty then;

        private ComponentProperty elseValue;

        private String operandType;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentConditionProperty model) {
            property(model.property);
            field(model.field);
            operator(model.operator);
            operand(model.operand);
            then(model.then);
            elseValue(model.elseValue);
            operandType(model.operandType);
        }

        public final String getProperty() {
            return property;
        }

        public final void setProperty(String property) {
            this.property = property;
        }

        @Override
        public final Builder property(String property) {
            this.property = property;
            return this;
        }

        public final String getField() {
            return field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public final String getOperand() {
            return operand;
        }

        public final void setOperand(String operand) {
            this.operand = operand;
        }

        @Override
        public final Builder operand(String operand) {
            this.operand = operand;
            return this;
        }

        public final ComponentProperty.Builder getThen() {
            return then != null ? then.toBuilder() : null;
        }

        public final void setThen(ComponentProperty.BuilderImpl then) {
            this.then = then != null ? then.build() : null;
        }

        @Override
        public final Builder then(ComponentProperty then) {
            this.then = then;
            return this;
        }

        public final ComponentProperty.Builder getElseValue() {
            return elseValue != null ? elseValue.toBuilder() : null;
        }

        public final void setElseValue(ComponentProperty.BuilderImpl elseValue) {
            this.elseValue = elseValue != null ? elseValue.build() : null;
        }

        @Override
        public final Builder elseValue(ComponentProperty elseValue) {
            this.elseValue = elseValue;
            return this;
        }

        public final String getOperandType() {
            return operandType;
        }

        public final void setOperandType(String operandType) {
            this.operandType = operandType;
        }

        @Override
        public final Builder operandType(String operandType) {
            this.operandType = operandType;
            return this;
        }

        @Override
        public ComponentConditionProperty build() {
            return new ComponentConditionProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
