/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration for binding a component's properties to data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentDataConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentDataConfiguration.Builder, ComponentDataConfiguration> {
    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("model")
            .getter(getter(ComponentDataConfiguration::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()).build();

    private static final SdkField<List<SortProperty>> SORT_FIELD = SdkField
            .<List<SortProperty>> builder(MarshallingType.LIST)
            .memberName("sort")
            .getter(getter(ComponentDataConfiguration::sort))
            .setter(setter(Builder::sort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SortProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(SortProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Predicate> PREDICATE_FIELD = SdkField.<Predicate> builder(MarshallingType.SDK_POJO)
            .memberName("predicate").getter(getter(ComponentDataConfiguration::predicate)).setter(setter(Builder::predicate))
            .constructor(Predicate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predicate").build()).build();

    private static final SdkField<List<String>> IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("identifiers")
            .getter(getter(ComponentDataConfiguration::identifiers))
            .setter(setter(Builder::identifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_FIELD, SORT_FIELD,
            PREDICATE_FIELD, IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String model;

    private final List<SortProperty> sort;

    private final Predicate predicate;

    private final List<String> identifiers;

    private ComponentDataConfiguration(BuilderImpl builder) {
        this.model = builder.model;
        this.sort = builder.sort;
        this.predicate = builder.predicate;
        this.identifiers = builder.identifiers;
    }

    /**
     * <p>
     * The name of the data model to use to bind data to a component.
     * </p>
     * 
     * @return The name of the data model to use to bind data to a component.
     */
    public final String model() {
        return model;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sort property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSort() {
        return sort != null && !(sort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes how to sort the component's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSort} method.
     * </p>
     * 
     * @return Describes how to sort the component's properties.
     */
    public final List<SortProperty> sort() {
        return sort;
    }

    /**
     * <p>
     * Represents the conditional logic to use when binding data to a component. Use this property to retrieve only a
     * subset of the data in a collection.
     * </p>
     * 
     * @return Represents the conditional logic to use when binding data to a component. Use this property to retrieve
     *         only a subset of the data in a collection.
     */
    public final Predicate predicate() {
        return predicate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Identifiers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIdentifiers() {
        return identifiers != null && !(identifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IDs to use to bind data to a component. Use this property to bind specifically chosen data, rather than
     * data retrieved from a query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentifiers} method.
     * </p>
     * 
     * @return A list of IDs to use to bind data to a component. Use this property to bind specifically chosen data,
     *         rather than data retrieved from a query.
     */
    public final List<String> identifiers() {
        return identifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(hasSort() ? sort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(predicate());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentifiers() ? identifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentDataConfiguration)) {
            return false;
        }
        ComponentDataConfiguration other = (ComponentDataConfiguration) obj;
        return Objects.equals(model(), other.model()) && hasSort() == other.hasSort() && Objects.equals(sort(), other.sort())
                && Objects.equals(predicate(), other.predicate()) && hasIdentifiers() == other.hasIdentifiers()
                && Objects.equals(identifiers(), other.identifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentDataConfiguration").add("Model", model()).add("Sort", hasSort() ? sort() : null)
                .add("Predicate", predicate()).add("Identifiers", hasIdentifiers() ? identifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "model":
            return Optional.ofNullable(clazz.cast(model()));
        case "sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "predicate":
            return Optional.ofNullable(clazz.cast(predicate()));
        case "identifiers":
            return Optional.ofNullable(clazz.cast(identifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("model", MODEL_FIELD);
        map.put("sort", SORT_FIELD);
        map.put("predicate", PREDICATE_FIELD);
        map.put("identifiers", IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentDataConfiguration, T> g) {
        return obj -> g.apply((ComponentDataConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentDataConfiguration> {
        /**
         * <p>
         * The name of the data model to use to bind data to a component.
         * </p>
         * 
         * @param model
         *        The name of the data model to use to bind data to a component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * Describes how to sort the component's properties.
         * </p>
         * 
         * @param sort
         *        Describes how to sort the component's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(Collection<SortProperty> sort);

        /**
         * <p>
         * Describes how to sort the component's properties.
         * </p>
         * 
         * @param sort
         *        Describes how to sort the component's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(SortProperty... sort);

        /**
         * <p>
         * Describes how to sort the component's properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.SortProperty.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.amplifyuibuilder.model.SortProperty#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.SortProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #sort(List<SortProperty>)}.
         * 
         * @param sort
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.SortProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(java.util.Collection<SortProperty>)
         */
        Builder sort(Consumer<SortProperty.Builder>... sort);

        /**
         * <p>
         * Represents the conditional logic to use when binding data to a component. Use this property to retrieve only
         * a subset of the data in a collection.
         * </p>
         * 
         * @param predicate
         *        Represents the conditional logic to use when binding data to a component. Use this property to
         *        retrieve only a subset of the data in a collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicate(Predicate predicate);

        /**
         * <p>
         * Represents the conditional logic to use when binding data to a component. Use this property to retrieve only
         * a subset of the data in a collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link Predicate.Builder} avoiding the need to
         * create one manually via {@link Predicate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Predicate.Builder#build()} is called immediately and its result
         * is passed to {@link #predicate(Predicate)}.
         * 
         * @param predicate
         *        a consumer that will call methods on {@link Predicate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predicate(Predicate)
         */
        default Builder predicate(Consumer<Predicate.Builder> predicate) {
            return predicate(Predicate.builder().applyMutation(predicate).build());
        }

        /**
         * <p>
         * A list of IDs to use to bind data to a component. Use this property to bind specifically chosen data, rather
         * than data retrieved from a query.
         * </p>
         * 
         * @param identifiers
         *        A list of IDs to use to bind data to a component. Use this property to bind specifically chosen data,
         *        rather than data retrieved from a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifiers(Collection<String> identifiers);

        /**
         * <p>
         * A list of IDs to use to bind data to a component. Use this property to bind specifically chosen data, rather
         * than data retrieved from a query.
         * </p>
         * 
         * @param identifiers
         *        A list of IDs to use to bind data to a component. Use this property to bind specifically chosen data,
         *        rather than data retrieved from a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifiers(String... identifiers);
    }

    static final class BuilderImpl implements Builder {
        private String model;

        private List<SortProperty> sort = DefaultSdkAutoConstructList.getInstance();

        private Predicate predicate;

        private List<String> identifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentDataConfiguration model) {
            model(model.model);
            sort(model.sort);
            predicate(model.predicate);
            identifiers(model.identifiers);
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final List<SortProperty.Builder> getSort() {
            List<SortProperty.Builder> result = SortPropertyListCopier.copyToBuilder(this.sort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSort(Collection<SortProperty.BuilderImpl> sort) {
            this.sort = SortPropertyListCopier.copyFromBuilder(sort);
        }

        @Override
        public final Builder sort(Collection<SortProperty> sort) {
            this.sort = SortPropertyListCopier.copy(sort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sort(SortProperty... sort) {
            sort(Arrays.asList(sort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sort(Consumer<SortProperty.Builder>... sort) {
            sort(Stream.of(sort).map(c -> SortProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Predicate.Builder getPredicate() {
            return predicate != null ? predicate.toBuilder() : null;
        }

        public final void setPredicate(Predicate.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        @Override
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public final Collection<String> getIdentifiers() {
            if (identifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return identifiers;
        }

        public final void setIdentifiers(Collection<String> identifiers) {
            this.identifiers = IdentifierListCopier.copy(identifiers);
        }

        @Override
        public final Builder identifiers(Collection<String> identifiers) {
            this.identifiers = IdentifierListCopier.copy(identifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(String... identifiers) {
            identifiers(Arrays.asList(identifiers));
            return this;
        }

        @Override
        public ComponentDataConfiguration build() {
            return new ComponentDataConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
