/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComponentRequest extends AmplifyUiBuilderRequest implements
        ToCopyableBuilder<CreateComponentRequest.Builder, CreateComponentRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(CreateComponentRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(CreateComponentRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateComponentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<CreateComponentData> COMPONENT_TO_CREATE_FIELD = SdkField
            .<CreateComponentData> builder(MarshallingType.SDK_POJO)
            .memberName("componentToCreate")
            .getter(getter(CreateComponentRequest::componentToCreate))
            .setter(setter(Builder::componentToCreate))
            .constructor(CreateComponentData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentToCreate").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            ENVIRONMENT_NAME_FIELD, CLIENT_TOKEN_FIELD, COMPONENT_TO_CREATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appId;

    private final String environmentName;

    private final String clientToken;

    private final CreateComponentData componentToCreate;

    private CreateComponentRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
        this.clientToken = builder.clientToken;
        this.componentToCreate = builder.componentToCreate;
    }

    /**
     * <p>
     * The unique ID of the Amplify app to associate with the component.
     * </p>
     * 
     * @return The unique ID of the Amplify app to associate with the component.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of the backend environment that is a part of the Amplify app.
     * </p>
     * 
     * @return The name of the backend environment that is a part of the Amplify app.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The unique client token.
     * </p>
     * 
     * @return The unique client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Represents the configuration of the component to create.
     * </p>
     * 
     * @return Represents the configuration of the component to create.
     */
    public final CreateComponentData componentToCreate() {
        return componentToCreate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(componentToCreate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentRequest)) {
            return false;
        }
        CreateComponentRequest other = (CreateComponentRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(componentToCreate(), other.componentToCreate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComponentRequest").add("AppId", appId()).add("EnvironmentName", environmentName())
                .add("ClientToken", clientToken()).add("ComponentToCreate", componentToCreate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "componentToCreate":
            return Optional.ofNullable(clazz.cast(componentToCreate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appId", APP_ID_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("componentToCreate", COMPONENT_TO_CREATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentRequest, T> g) {
        return obj -> g.apply((CreateComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmplifyUiBuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateComponentRequest> {
        /**
         * <p>
         * The unique ID of the Amplify app to associate with the component.
         * </p>
         * 
         * @param appId
         *        The unique ID of the Amplify app to associate with the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of the backend environment that is a part of the Amplify app.
         * </p>
         * 
         * @param environmentName
         *        The name of the backend environment that is a part of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The unique client token.
         * </p>
         * 
         * @param clientToken
         *        The unique client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Represents the configuration of the component to create.
         * </p>
         * 
         * @param componentToCreate
         *        Represents the configuration of the component to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentToCreate(CreateComponentData componentToCreate);

        /**
         * <p>
         * Represents the configuration of the component to create.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateComponentData.Builder} avoiding the
         * need to create one manually via {@link CreateComponentData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateComponentData.Builder#build()} is called immediately and
         * its result is passed to {@link #componentToCreate(CreateComponentData)}.
         * 
         * @param componentToCreate
         *        a consumer that will call methods on {@link CreateComponentData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #componentToCreate(CreateComponentData)
         */
        default Builder componentToCreate(Consumer<CreateComponentData.Builder> componentToCreate) {
            return componentToCreate(CreateComponentData.builder().applyMutation(componentToCreate).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyUiBuilderRequest.BuilderImpl implements Builder {
        private String appId;

        private String environmentName;

        private String clientToken;

        private CreateComponentData componentToCreate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentRequest model) {
            super(model);
            appId(model.appId);
            environmentName(model.environmentName);
            clientToken(model.clientToken);
            componentToCreate(model.componentToCreate);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final CreateComponentData.Builder getComponentToCreate() {
            return componentToCreate != null ? componentToCreate.toBuilder() : null;
        }

        public final void setComponentToCreate(CreateComponentData.BuilderImpl componentToCreate) {
            this.componentToCreate = componentToCreate != null ? componentToCreate.build() : null;
        }

        @Override
        public final Builder componentToCreate(CreateComponentData componentToCreate) {
            this.componentToCreate = componentToCreate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComponentRequest build() {
            return new CreateComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
