/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration for an input field on a form. Use <code>FormInputValueProperty</code> to specify the
 * values to render or bind by default.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormInputValueProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<FormInputValueProperty.Builder, FormInputValueProperty> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(FormInputValueProperty::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<FormInputValuePropertyBindingProperties> BINDING_PROPERTIES_FIELD = SdkField
            .<FormInputValuePropertyBindingProperties> builder(MarshallingType.SDK_POJO).memberName("bindingProperties")
            .getter(getter(FormInputValueProperty::bindingProperties)).setter(setter(Builder::bindingProperties))
            .constructor(FormInputValuePropertyBindingProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindingProperties").build()).build();

    private static final SdkField<List<FormInputValueProperty>> CONCAT_FIELD = SdkField
            .<List<FormInputValueProperty>> builder(MarshallingType.LIST)
            .memberName("concat")
            .getter(getter(FormInputValueProperty::concat))
            .setter(setter(Builder::concat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concat").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FormInputValueProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormInputValueProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD,
            BINDING_PROPERTIES_FIELD, CONCAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private final FormInputValuePropertyBindingProperties bindingProperties;

    private final List<FormInputValueProperty> concat;

    private FormInputValueProperty(BuilderImpl builder) {
        this.value = builder.value;
        this.bindingProperties = builder.bindingProperties;
        this.concat = builder.concat;
    }

    /**
     * <p>
     * The value to assign to the input field.
     * </p>
     * 
     * @return The value to assign to the input field.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The information to bind fields to data at runtime.
     * </p>
     * 
     * @return The information to bind fields to data at runtime.
     */
    public final FormInputValuePropertyBindingProperties bindingProperties() {
        return bindingProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Concat property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConcat() {
        return concat != null && !(concat instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of form properties to concatenate to create the value to assign to this field property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConcat} method.
     * </p>
     * 
     * @return A list of form properties to concatenate to create the value to assign to this field property.
     */
    public final List<FormInputValueProperty> concat() {
        return concat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(bindingProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasConcat() ? concat() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormInputValueProperty)) {
            return false;
        }
        FormInputValueProperty other = (FormInputValueProperty) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(bindingProperties(), other.bindingProperties())
                && hasConcat() == other.hasConcat() && Objects.equals(concat(), other.concat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormInputValueProperty").add("Value", value()).add("BindingProperties", bindingProperties())
                .add("Concat", hasConcat() ? concat() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "bindingProperties":
            return Optional.ofNullable(clazz.cast(bindingProperties()));
        case "concat":
            return Optional.ofNullable(clazz.cast(concat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("value", VALUE_FIELD);
        map.put("bindingProperties", BINDING_PROPERTIES_FIELD);
        map.put("concat", CONCAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FormInputValueProperty, T> g) {
        return obj -> g.apply((FormInputValueProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormInputValueProperty> {
        /**
         * <p>
         * The value to assign to the input field.
         * </p>
         * 
         * @param value
         *        The value to assign to the input field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The information to bind fields to data at runtime.
         * </p>
         * 
         * @param bindingProperties
         *        The information to bind fields to data at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bindingProperties(FormInputValuePropertyBindingProperties bindingProperties);

        /**
         * <p>
         * The information to bind fields to data at runtime.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FormInputValuePropertyBindingProperties.Builder} avoiding the need to create one manually via
         * {@link FormInputValuePropertyBindingProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormInputValuePropertyBindingProperties.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #bindingProperties(FormInputValuePropertyBindingProperties)}.
         * 
         * @param bindingProperties
         *        a consumer that will call methods on {@link FormInputValuePropertyBindingProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bindingProperties(FormInputValuePropertyBindingProperties)
         */
        default Builder bindingProperties(Consumer<FormInputValuePropertyBindingProperties.Builder> bindingProperties) {
            return bindingProperties(FormInputValuePropertyBindingProperties.builder().applyMutation(bindingProperties).build());
        }

        /**
         * <p>
         * A list of form properties to concatenate to create the value to assign to this field property.
         * </p>
         * 
         * @param concat
         *        A list of form properties to concatenate to create the value to assign to this field property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concat(Collection<FormInputValueProperty> concat);

        /**
         * <p>
         * A list of form properties to concatenate to create the value to assign to this field property.
         * </p>
         * 
         * @param concat
         *        A list of form properties to concatenate to create the value to assign to this field property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concat(FormInputValueProperty... concat);

        /**
         * <p>
         * A list of form properties to concatenate to create the value to assign to this field property.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty.Builder#build()} is
         * called immediately and its result is passed to {@link #concat(List<FormInputValueProperty>)}.
         * 
         * @param concat
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.FormInputValueProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #concat(java.util.Collection<FormInputValueProperty>)
         */
        Builder concat(Consumer<Builder>... concat);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private FormInputValuePropertyBindingProperties bindingProperties;

        private List<FormInputValueProperty> concat = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FormInputValueProperty model) {
            value(model.value);
            bindingProperties(model.bindingProperties);
            concat(model.concat);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final FormInputValuePropertyBindingProperties.Builder getBindingProperties() {
            return bindingProperties != null ? bindingProperties.toBuilder() : null;
        }

        public final void setBindingProperties(FormInputValuePropertyBindingProperties.BuilderImpl bindingProperties) {
            this.bindingProperties = bindingProperties != null ? bindingProperties.build() : null;
        }

        @Override
        public final Builder bindingProperties(FormInputValuePropertyBindingProperties bindingProperties) {
            this.bindingProperties = bindingProperties;
            return this;
        }

        public final List<Builder> getConcat() {
            List<Builder> result = FormInputValuePropertyListCopier.copyToBuilder(this.concat);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConcat(Collection<BuilderImpl> concat) {
            this.concat = FormInputValuePropertyListCopier.copyFromBuilder(concat);
        }

        @Override
        public final Builder concat(Collection<FormInputValueProperty> concat) {
            this.concat = FormInputValuePropertyListCopier.copy(concat);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder concat(FormInputValueProperty... concat) {
            concat(Arrays.asList(concat));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder concat(Consumer<Builder>... concat) {
            concat(Stream.of(concat).map(c -> FormInputValueProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FormInputValueProperty build() {
            return new FormInputValueProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
