/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the basic information about a form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormSummary implements SdkPojo, Serializable, ToCopyableBuilder<FormSummary.Builder, FormSummary> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(FormSummary::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<FormDataTypeConfig> DATA_TYPE_FIELD = SdkField
            .<FormDataTypeConfig> builder(MarshallingType.SDK_POJO).memberName("dataType").getter(getter(FormSummary::dataType))
            .setter(setter(Builder::dataType)).constructor(FormDataTypeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(FormSummary::environmentName)).setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<String> FORM_ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formActionType").getter(getter(FormSummary::formActionTypeAsString))
            .setter(setter(Builder::formActionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formActionType").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(FormSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FormSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, DATA_TYPE_FIELD,
            ENVIRONMENT_NAME_FIELD, FORM_ACTION_TYPE_FIELD, ID_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appId;

    private final FormDataTypeConfig dataType;

    private final String environmentName;

    private final String formActionType;

    private final String id;

    private final String name;

    private FormSummary(BuilderImpl builder) {
        this.appId = builder.appId;
        this.dataType = builder.dataType;
        this.environmentName = builder.environmentName;
        this.formActionType = builder.formActionType;
        this.id = builder.id;
        this.name = builder.name;
    }

    /**
     * <p>
     * The unique ID for the app associated with the form summary.
     * </p>
     * 
     * @return The unique ID for the app associated with the form summary.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The form's data source type.
     * </p>
     * 
     * @return The form's data source type.
     */
    public final FormDataTypeConfig dataType() {
        return dataType;
    }

    /**
     * <p>
     * The name of the backend environment that is part of the Amplify app.
     * </p>
     * 
     * @return The name of the backend environment that is part of the Amplify app.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The type of operation to perform on the form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formActionType}
     * will return {@link FormActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formActionTypeAsString}.
     * </p>
     * 
     * @return The type of operation to perform on the form.
     * @see FormActionType
     */
    public final FormActionType formActionType() {
        return FormActionType.fromValue(formActionType);
    }

    /**
     * <p>
     * The type of operation to perform on the form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formActionType}
     * will return {@link FormActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formActionTypeAsString}.
     * </p>
     * 
     * @return The type of operation to perform on the form.
     * @see FormActionType
     */
    public final String formActionTypeAsString() {
        return formActionType;
    }

    /**
     * <p>
     * The ID of the form.
     * </p>
     * 
     * @return The ID of the form.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the form.
     * </p>
     * 
     * @return The name of the form.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(formActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormSummary)) {
            return false;
        }
        FormSummary other = (FormSummary) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(dataType(), other.dataType())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(formActionTypeAsString(), other.formActionTypeAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormSummary").add("AppId", appId()).add("DataType", dataType())
                .add("EnvironmentName", environmentName()).add("FormActionType", formActionTypeAsString()).add("Id", id())
                .add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "formActionType":
            return Optional.ofNullable(clazz.cast(formActionTypeAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appId", APP_ID_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("formActionType", FORM_ACTION_TYPE_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FormSummary, T> g) {
        return obj -> g.apply((FormSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormSummary> {
        /**
         * <p>
         * The unique ID for the app associated with the form summary.
         * </p>
         * 
         * @param appId
         *        The unique ID for the app associated with the form summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The form's data source type.
         * </p>
         * 
         * @param dataType
         *        The form's data source type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(FormDataTypeConfig dataType);

        /**
         * <p>
         * The form's data source type.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormDataTypeConfig.Builder} avoiding the
         * need to create one manually via {@link FormDataTypeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormDataTypeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dataType(FormDataTypeConfig)}.
         * 
         * @param dataType
         *        a consumer that will call methods on {@link FormDataTypeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataType(FormDataTypeConfig)
         */
        default Builder dataType(Consumer<FormDataTypeConfig.Builder> dataType) {
            return dataType(FormDataTypeConfig.builder().applyMutation(dataType).build());
        }

        /**
         * <p>
         * The name of the backend environment that is part of the Amplify app.
         * </p>
         * 
         * @param environmentName
         *        The name of the backend environment that is part of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The type of operation to perform on the form.
         * </p>
         * 
         * @param formActionType
         *        The type of operation to perform on the form.
         * @see FormActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormActionType
         */
        Builder formActionType(String formActionType);

        /**
         * <p>
         * The type of operation to perform on the form.
         * </p>
         * 
         * @param formActionType
         *        The type of operation to perform on the form.
         * @see FormActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormActionType
         */
        Builder formActionType(FormActionType formActionType);

        /**
         * <p>
         * The ID of the form.
         * </p>
         * 
         * @param id
         *        The ID of the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the form.
         * </p>
         * 
         * @param name
         *        The name of the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String appId;

        private FormDataTypeConfig dataType;

        private String environmentName;

        private String formActionType;

        private String id;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(FormSummary model) {
            appId(model.appId);
            dataType(model.dataType);
            environmentName(model.environmentName);
            formActionType(model.formActionType);
            id(model.id);
            name(model.name);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final FormDataTypeConfig.Builder getDataType() {
            return dataType != null ? dataType.toBuilder() : null;
        }

        public final void setDataType(FormDataTypeConfig.BuilderImpl dataType) {
            this.dataType = dataType != null ? dataType.build() : null;
        }

        @Override
        public final Builder dataType(FormDataTypeConfig dataType) {
            this.dataType = dataType;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getFormActionType() {
            return formActionType;
        }

        public final void setFormActionType(String formActionType) {
            this.formActionType = formActionType;
        }

        @Override
        public final Builder formActionType(String formActionType) {
            this.formActionType = formActionType;
            return this;
        }

        @Override
        public final Builder formActionType(FormActionType formActionType) {
            this.formActionType(formActionType == null ? null : formActionType.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public FormSummary build() {
            return new FormSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
