/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the feature flags that you can specify for a code generation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodegenFeatureFlags implements SdkPojo, Serializable,
        ToCopyableBuilder<CodegenFeatureFlags.Builder, CodegenFeatureFlags> {
    private static final SdkField<Boolean> IS_RELATIONSHIP_SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isRelationshipSupported").getter(getter(CodegenFeatureFlags::isRelationshipSupported))
            .setter(setter(Builder::isRelationshipSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRelationshipSupported").build())
            .build();

    private static final SdkField<Boolean> IS_NON_MODEL_SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isNonModelSupported").getter(getter(CodegenFeatureFlags::isNonModelSupported))
            .setter(setter(Builder::isNonModelSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNonModelSupported").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IS_RELATIONSHIP_SUPPORTED_FIELD, IS_NON_MODEL_SUPPORTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isRelationshipSupported;

    private final Boolean isNonModelSupported;

    private CodegenFeatureFlags(BuilderImpl builder) {
        this.isRelationshipSupported = builder.isRelationshipSupported;
        this.isNonModelSupported = builder.isNonModelSupported;
    }

    /**
     * <p>
     * Specifes whether a code generation job supports data relationships.
     * </p>
     * 
     * @return Specifes whether a code generation job supports data relationships.
     */
    public final Boolean isRelationshipSupported() {
        return isRelationshipSupported;
    }

    /**
     * <p>
     * Specifies whether a code generation job supports non models.
     * </p>
     * 
     * @return Specifies whether a code generation job supports non models.
     */
    public final Boolean isNonModelSupported() {
        return isNonModelSupported;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isRelationshipSupported());
        hashCode = 31 * hashCode + Objects.hashCode(isNonModelSupported());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodegenFeatureFlags)) {
            return false;
        }
        CodegenFeatureFlags other = (CodegenFeatureFlags) obj;
        return Objects.equals(isRelationshipSupported(), other.isRelationshipSupported())
                && Objects.equals(isNonModelSupported(), other.isNonModelSupported());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodegenFeatureFlags").add("IsRelationshipSupported", isRelationshipSupported())
                .add("IsNonModelSupported", isNonModelSupported()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isRelationshipSupported":
            return Optional.ofNullable(clazz.cast(isRelationshipSupported()));
        case "isNonModelSupported":
            return Optional.ofNullable(clazz.cast(isNonModelSupported()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isRelationshipSupported", IS_RELATIONSHIP_SUPPORTED_FIELD);
        map.put("isNonModelSupported", IS_NON_MODEL_SUPPORTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodegenFeatureFlags, T> g) {
        return obj -> g.apply((CodegenFeatureFlags) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodegenFeatureFlags> {
        /**
         * <p>
         * Specifes whether a code generation job supports data relationships.
         * </p>
         * 
         * @param isRelationshipSupported
         *        Specifes whether a code generation job supports data relationships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRelationshipSupported(Boolean isRelationshipSupported);

        /**
         * <p>
         * Specifies whether a code generation job supports non models.
         * </p>
         * 
         * @param isNonModelSupported
         *        Specifies whether a code generation job supports non models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNonModelSupported(Boolean isNonModelSupported);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isRelationshipSupported;

        private Boolean isNonModelSupported;

        private BuilderImpl() {
        }

        private BuilderImpl(CodegenFeatureFlags model) {
            isRelationshipSupported(model.isRelationshipSupported);
            isNonModelSupported(model.isNonModelSupported);
        }

        public final Boolean getIsRelationshipSupported() {
            return isRelationshipSupported;
        }

        public final void setIsRelationshipSupported(Boolean isRelationshipSupported) {
            this.isRelationshipSupported = isRelationshipSupported;
        }

        @Override
        public final Builder isRelationshipSupported(Boolean isRelationshipSupported) {
            this.isRelationshipSupported = isRelationshipSupported;
            return this;
        }

        public final Boolean getIsNonModelSupported() {
            return isNonModelSupported;
        }

        public final void setIsNonModelSupported(Boolean isNonModelSupported) {
            this.isNonModelSupported = isNonModelSupported;
        }

        @Override
        public final Builder isNonModelSupported(Boolean isNonModelSupported) {
            this.isNonModelSupported = isNonModelSupported;
            return this;
        }

        @Override
        public CodegenFeatureFlags build() {
            return new CodegenFeatureFlags(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
