/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data schema for a code generation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodegenJobGenericDataSchema implements SdkPojo, Serializable,
        ToCopyableBuilder<CodegenJobGenericDataSchema.Builder, CodegenJobGenericDataSchema> {
    private static final SdkField<String> DATA_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceType").getter(getter(CodegenJobGenericDataSchema::dataSourceTypeAsString))
            .setter(setter(Builder::dataSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceType").build()).build();

    private static final SdkField<Map<String, CodegenGenericDataModel>> MODELS_FIELD = SdkField
            .<Map<String, CodegenGenericDataModel>> builder(MarshallingType.MAP)
            .memberName("models")
            .getter(getter(CodegenJobGenericDataSchema::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CodegenGenericDataModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodegenGenericDataModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, CodegenGenericDataEnum>> ENUMS_FIELD = SdkField
            .<Map<String, CodegenGenericDataEnum>> builder(MarshallingType.MAP)
            .memberName("enums")
            .getter(getter(CodegenJobGenericDataSchema::enums))
            .setter(setter(Builder::enums))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enums").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CodegenGenericDataEnum> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodegenGenericDataEnum::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, CodegenGenericDataNonModel>> NON_MODELS_FIELD = SdkField
            .<Map<String, CodegenGenericDataNonModel>> builder(MarshallingType.MAP)
            .memberName("nonModels")
            .getter(getter(CodegenJobGenericDataSchema::nonModels))
            .setter(setter(Builder::nonModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonModels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CodegenGenericDataNonModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodegenGenericDataNonModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_TYPE_FIELD,
            MODELS_FIELD, ENUMS_FIELD, NON_MODELS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSourceType;

    private final Map<String, CodegenGenericDataModel> models;

    private final Map<String, CodegenGenericDataEnum> enums;

    private final Map<String, CodegenGenericDataNonModel> nonModels;

    private CodegenJobGenericDataSchema(BuilderImpl builder) {
        this.dataSourceType = builder.dataSourceType;
        this.models = builder.models;
        this.enums = builder.enums;
        this.nonModels = builder.nonModels;
    }

    /**
     * <p>
     * The type of the data source for the schema. Currently, the only valid value is an Amplify <code>DataStore</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSourceType}
     * will return {@link CodegenJobGenericDataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #dataSourceTypeAsString}.
     * </p>
     * 
     * @return The type of the data source for the schema. Currently, the only valid value is an Amplify
     *         <code>DataStore</code>.
     * @see CodegenJobGenericDataSourceType
     */
    public final CodegenJobGenericDataSourceType dataSourceType() {
        return CodegenJobGenericDataSourceType.fromValue(dataSourceType);
    }

    /**
     * <p>
     * The type of the data source for the schema. Currently, the only valid value is an Amplify <code>DataStore</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSourceType}
     * will return {@link CodegenJobGenericDataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #dataSourceTypeAsString}.
     * </p>
     * 
     * @return The type of the data source for the schema. Currently, the only valid value is an Amplify
     *         <code>DataStore</code>.
     * @see CodegenJobGenericDataSourceType
     */
    public final String dataSourceTypeAsString() {
        return dataSourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Models property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The name of a <code>CodegenGenericDataModel</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModels} method.
     * </p>
     * 
     * @return The name of a <code>CodegenGenericDataModel</code>.
     */
    public final Map<String, CodegenGenericDataModel> models() {
        return models;
    }

    /**
     * For responses, this returns true if the service returned a value for the Enums property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasEnums() {
        return enums != null && !(enums instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The name of a <code>CodegenGenericDataEnum</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnums} method.
     * </p>
     * 
     * @return The name of a <code>CodegenGenericDataEnum</code>.
     */
    public final Map<String, CodegenGenericDataEnum> enums() {
        return enums;
    }

    /**
     * For responses, this returns true if the service returned a value for the NonModels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNonModels() {
        return nonModels != null && !(nonModels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The name of a <code>CodegenGenericDataNonModel</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNonModels} method.
     * </p>
     * 
     * @return The name of a <code>CodegenGenericDataNonModel</code>.
     */
    public final Map<String, CodegenGenericDataNonModel> nonModels() {
        return nonModels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnums() ? enums() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNonModels() ? nonModels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodegenJobGenericDataSchema)) {
            return false;
        }
        CodegenJobGenericDataSchema other = (CodegenJobGenericDataSchema) obj;
        return Objects.equals(dataSourceTypeAsString(), other.dataSourceTypeAsString()) && hasModels() == other.hasModels()
                && Objects.equals(models(), other.models()) && hasEnums() == other.hasEnums()
                && Objects.equals(enums(), other.enums()) && hasNonModels() == other.hasNonModels()
                && Objects.equals(nonModels(), other.nonModels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodegenJobGenericDataSchema").add("DataSourceType", dataSourceTypeAsString())
                .add("Models", hasModels() ? models() : null).add("Enums", hasEnums() ? enums() : null)
                .add("NonModels", hasNonModels() ? nonModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSourceType":
            return Optional.ofNullable(clazz.cast(dataSourceTypeAsString()));
        case "models":
            return Optional.ofNullable(clazz.cast(models()));
        case "enums":
            return Optional.ofNullable(clazz.cast(enums()));
        case "nonModels":
            return Optional.ofNullable(clazz.cast(nonModels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataSourceType", DATA_SOURCE_TYPE_FIELD);
        map.put("models", MODELS_FIELD);
        map.put("enums", ENUMS_FIELD);
        map.put("nonModels", NON_MODELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodegenJobGenericDataSchema, T> g) {
        return obj -> g.apply((CodegenJobGenericDataSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodegenJobGenericDataSchema> {
        /**
         * <p>
         * The type of the data source for the schema. Currently, the only valid value is an Amplify
         * <code>DataStore</code>.
         * </p>
         * 
         * @param dataSourceType
         *        The type of the data source for the schema. Currently, the only valid value is an Amplify
         *        <code>DataStore</code>.
         * @see CodegenJobGenericDataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodegenJobGenericDataSourceType
         */
        Builder dataSourceType(String dataSourceType);

        /**
         * <p>
         * The type of the data source for the schema. Currently, the only valid value is an Amplify
         * <code>DataStore</code>.
         * </p>
         * 
         * @param dataSourceType
         *        The type of the data source for the schema. Currently, the only valid value is an Amplify
         *        <code>DataStore</code>.
         * @see CodegenJobGenericDataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodegenJobGenericDataSourceType
         */
        Builder dataSourceType(CodegenJobGenericDataSourceType dataSourceType);

        /**
         * <p>
         * The name of a <code>CodegenGenericDataModel</code>.
         * </p>
         * 
         * @param models
         *        The name of a <code>CodegenGenericDataModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Map<String, CodegenGenericDataModel> models);

        /**
         * <p>
         * The name of a <code>CodegenGenericDataEnum</code>.
         * </p>
         * 
         * @param enums
         *        The name of a <code>CodegenGenericDataEnum</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enums(Map<String, CodegenGenericDataEnum> enums);

        /**
         * <p>
         * The name of a <code>CodegenGenericDataNonModel</code>.
         * </p>
         * 
         * @param nonModels
         *        The name of a <code>CodegenGenericDataNonModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonModels(Map<String, CodegenGenericDataNonModel> nonModels);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceType;

        private Map<String, CodegenGenericDataModel> models = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, CodegenGenericDataEnum> enums = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, CodegenGenericDataNonModel> nonModels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodegenJobGenericDataSchema model) {
            dataSourceType(model.dataSourceType);
            models(model.models);
            enums(model.enums);
            nonModels(model.nonModels);
        }

        public final String getDataSourceType() {
            return dataSourceType;
        }

        public final void setDataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
        }

        @Override
        public final Builder dataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        @Override
        public final Builder dataSourceType(CodegenJobGenericDataSourceType dataSourceType) {
            this.dataSourceType(dataSourceType == null ? null : dataSourceType.toString());
            return this;
        }

        public final Map<String, CodegenGenericDataModel.Builder> getModels() {
            Map<String, CodegenGenericDataModel.Builder> result = CodegenGenericDataModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setModels(Map<String, CodegenGenericDataModel.BuilderImpl> models) {
            this.models = CodegenGenericDataModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Map<String, CodegenGenericDataModel> models) {
            this.models = CodegenGenericDataModelsCopier.copy(models);
            return this;
        }

        public final Map<String, CodegenGenericDataEnum.Builder> getEnums() {
            Map<String, CodegenGenericDataEnum.Builder> result = CodegenGenericDataEnumsCopier.copyToBuilder(this.enums);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEnums(Map<String, CodegenGenericDataEnum.BuilderImpl> enums) {
            this.enums = CodegenGenericDataEnumsCopier.copyFromBuilder(enums);
        }

        @Override
        public final Builder enums(Map<String, CodegenGenericDataEnum> enums) {
            this.enums = CodegenGenericDataEnumsCopier.copy(enums);
            return this;
        }

        public final Map<String, CodegenGenericDataNonModel.Builder> getNonModels() {
            Map<String, CodegenGenericDataNonModel.Builder> result = CodegenGenericDataNonModelsCopier
                    .copyToBuilder(this.nonModels);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setNonModels(Map<String, CodegenGenericDataNonModel.BuilderImpl> nonModels) {
            this.nonModels = CodegenGenericDataNonModelsCopier.copyFromBuilder(nonModels);
        }

        @Override
        public final Builder nonModels(Map<String, CodegenGenericDataNonModel> nonModels) {
            this.nonModels = CodegenGenericDataNonModelsCopier.copy(nonModels);
            return this;
        }

        @Override
        public CodegenJobGenericDataSchema build() {
            return new CodegenJobGenericDataSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
