/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stores the configuration information for a visual helper element for a form. A sectional element can be a header, a
 * text block, or a divider. These elements are static and not associated with any data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SectionalElement implements SdkPojo, Serializable,
        ToCopyableBuilder<SectionalElement.Builder, SectionalElement> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SectionalElement::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<FieldPosition> POSITION_FIELD = SdkField.<FieldPosition> builder(MarshallingType.SDK_POJO)
            .memberName("position").getter(getter(SectionalElement::position)).setter(setter(Builder::position))
            .constructor(FieldPosition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(SectionalElement::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<Integer> LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("level")
            .getter(getter(SectionalElement::level)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()).build();

    private static final SdkField<String> ORIENTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orientation").getter(getter(SectionalElement::orientation)).setter(setter(Builder::orientation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orientation").build()).build();

    private static final SdkField<Boolean> EXCLUDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("excluded").getter(getter(SectionalElement::excluded)).setter(setter(Builder::excluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excluded").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, POSITION_FIELD,
            TEXT_FIELD, LEVEL_FIELD, ORIENTATION_FIELD, EXCLUDED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final FieldPosition position;

    private final String text;

    private final Integer level;

    private final String orientation;

    private final Boolean excluded;

    private SectionalElement(BuilderImpl builder) {
        this.type = builder.type;
        this.position = builder.position;
        this.text = builder.text;
        this.level = builder.level;
        this.orientation = builder.orientation;
        this.excluded = builder.excluded;
    }

    /**
     * <p>
     * The type of sectional element. Valid values are <code>Heading</code>, <code>Text</code>, and <code>Divider</code>
     * .
     * </p>
     * 
     * @return The type of sectional element. Valid values are <code>Heading</code>, <code>Text</code>, and
     *         <code>Divider</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * Specifies the position of the text in a field for a <code>Text</code> sectional element.
     * </p>
     * 
     * @return Specifies the position of the text in a field for a <code>Text</code> sectional element.
     */
    public final FieldPosition position() {
        return position;
    }

    /**
     * <p>
     * The text for a <code>Text</code> sectional element.
     * </p>
     * 
     * @return The text for a <code>Text</code> sectional element.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * Specifies the size of the font for a <code>Heading</code> sectional element. Valid values are
     * <code>1 | 2 | 3 | 4 | 5 | 6</code>.
     * </p>
     * 
     * @return Specifies the size of the font for a <code>Heading</code> sectional element. Valid values are
     *         <code>1 | 2 | 3 | 4 | 5 | 6</code>.
     */
    public final Integer level() {
        return level;
    }

    /**
     * <p>
     * Specifies the orientation for a <code>Divider</code> sectional element. Valid values are <code>horizontal</code>
     * or <code>vertical</code>.
     * </p>
     * 
     * @return Specifies the orientation for a <code>Divider</code> sectional element. Valid values are
     *         <code>horizontal</code> or <code>vertical</code>.
     */
    public final String orientation() {
        return orientation;
    }

    /**
     * <p>
     * Excludes a sectional element that was generated by default for a specified data model.
     * </p>
     * 
     * @return Excludes a sectional element that was generated by default for a specified data model.
     */
    public final Boolean excluded() {
        return excluded;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(level());
        hashCode = 31 * hashCode + Objects.hashCode(orientation());
        hashCode = 31 * hashCode + Objects.hashCode(excluded());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SectionalElement)) {
            return false;
        }
        SectionalElement other = (SectionalElement) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(position(), other.position())
                && Objects.equals(text(), other.text()) && Objects.equals(level(), other.level())
                && Objects.equals(orientation(), other.orientation()) && Objects.equals(excluded(), other.excluded());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SectionalElement").add("Type", type()).add("Position", position()).add("Text", text())
                .add("Level", level()).add("Orientation", orientation()).add("Excluded", excluded()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "level":
            return Optional.ofNullable(clazz.cast(level()));
        case "orientation":
            return Optional.ofNullable(clazz.cast(orientation()));
        case "excluded":
            return Optional.ofNullable(clazz.cast(excluded()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("position", POSITION_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("orientation", ORIENTATION_FIELD);
        map.put("excluded", EXCLUDED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SectionalElement, T> g) {
        return obj -> g.apply((SectionalElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SectionalElement> {
        /**
         * <p>
         * The type of sectional element. Valid values are <code>Heading</code>, <code>Text</code>, and
         * <code>Divider</code>.
         * </p>
         * 
         * @param type
         *        The type of sectional element. Valid values are <code>Heading</code>, <code>Text</code>, and
         *        <code>Divider</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the position of the text in a field for a <code>Text</code> sectional element.
         * </p>
         * 
         * @param position
         *        Specifies the position of the text in a field for a <code>Text</code> sectional element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(FieldPosition position);

        /**
         * <p>
         * Specifies the position of the text in a field for a <code>Text</code> sectional element.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldPosition.Builder} avoiding the need
         * to create one manually via {@link FieldPosition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldPosition.Builder#build()} is called immediately and its
         * result is passed to {@link #position(FieldPosition)}.
         * 
         * @param position
         *        a consumer that will call methods on {@link FieldPosition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #position(FieldPosition)
         */
        default Builder position(Consumer<FieldPosition.Builder> position) {
            return position(FieldPosition.builder().applyMutation(position).build());
        }

        /**
         * <p>
         * The text for a <code>Text</code> sectional element.
         * </p>
         * 
         * @param text
         *        The text for a <code>Text</code> sectional element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * Specifies the size of the font for a <code>Heading</code> sectional element. Valid values are
         * <code>1 | 2 | 3 | 4 | 5 | 6</code>.
         * </p>
         * 
         * @param level
         *        Specifies the size of the font for a <code>Heading</code> sectional element. Valid values are
         *        <code>1 | 2 | 3 | 4 | 5 | 6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder level(Integer level);

        /**
         * <p>
         * Specifies the orientation for a <code>Divider</code> sectional element. Valid values are
         * <code>horizontal</code> or <code>vertical</code>.
         * </p>
         * 
         * @param orientation
         *        Specifies the orientation for a <code>Divider</code> sectional element. Valid values are
         *        <code>horizontal</code> or <code>vertical</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orientation(String orientation);

        /**
         * <p>
         * Excludes a sectional element that was generated by default for a specified data model.
         * </p>
         * 
         * @param excluded
         *        Excludes a sectional element that was generated by default for a specified data model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excluded(Boolean excluded);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private FieldPosition position;

        private String text;

        private Integer level;

        private String orientation;

        private Boolean excluded;

        private BuilderImpl() {
        }

        private BuilderImpl(SectionalElement model) {
            type(model.type);
            position(model.position);
            text(model.text);
            level(model.level);
            orientation(model.orientation);
            excluded(model.excluded);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final FieldPosition.Builder getPosition() {
            return position != null ? position.toBuilder() : null;
        }

        public final void setPosition(FieldPosition.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(FieldPosition position) {
            this.position = position;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final Integer getLevel() {
            return level;
        }

        public final void setLevel(Integer level) {
            this.level = level;
        }

        @Override
        public final Builder level(Integer level) {
            this.level = level;
            return this;
        }

        public final String getOrientation() {
            return orientation;
        }

        public final void setOrientation(String orientation) {
            this.orientation = orientation;
        }

        @Override
        public final Builder orientation(String orientation) {
            this.orientation = orientation;
            return this;
        }

        public final Boolean getExcluded() {
            return excluded;
        }

        public final void setExcluded(Boolean excluded) {
            this.excluded = excluded;
        }

        @Override
        public final Builder excluded(Boolean excluded) {
            this.excluded = excluded;
            return this;
        }

        @Override
        public SectionalElement build() {
            return new SectionalElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
