/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The code generation job resource configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCodegenJobData implements SdkPojo, Serializable,
        ToCopyableBuilder<StartCodegenJobData.Builder, StartCodegenJobData> {
    private static final SdkField<CodegenJobRenderConfig> RENDER_CONFIG_FIELD = SdkField
            .<CodegenJobRenderConfig> builder(MarshallingType.SDK_POJO).memberName("renderConfig")
            .getter(getter(StartCodegenJobData::renderConfig)).setter(setter(Builder::renderConfig))
            .constructor(CodegenJobRenderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderConfig").build()).build();

    private static final SdkField<CodegenJobGenericDataSchema> GENERIC_DATA_SCHEMA_FIELD = SdkField
            .<CodegenJobGenericDataSchema> builder(MarshallingType.SDK_POJO).memberName("genericDataSchema")
            .getter(getter(StartCodegenJobData::genericDataSchema)).setter(setter(Builder::genericDataSchema))
            .constructor(CodegenJobGenericDataSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("genericDataSchema").build()).build();

    private static final SdkField<Boolean> AUTO_GENERATE_FORMS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoGenerateForms").getter(getter(StartCodegenJobData::autoGenerateForms))
            .setter(setter(Builder::autoGenerateForms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoGenerateForms").build()).build();

    private static final SdkField<CodegenFeatureFlags> FEATURES_FIELD = SdkField
            .<CodegenFeatureFlags> builder(MarshallingType.SDK_POJO).memberName("features")
            .getter(getter(StartCodegenJobData::features)).setter(setter(Builder::features))
            .constructor(CodegenFeatureFlags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartCodegenJobData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENDER_CONFIG_FIELD,
            GENERIC_DATA_SCHEMA_FIELD, AUTO_GENERATE_FORMS_FIELD, FEATURES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CodegenJobRenderConfig renderConfig;

    private final CodegenJobGenericDataSchema genericDataSchema;

    private final Boolean autoGenerateForms;

    private final CodegenFeatureFlags features;

    private final Map<String, String> tags;

    private StartCodegenJobData(BuilderImpl builder) {
        this.renderConfig = builder.renderConfig;
        this.genericDataSchema = builder.genericDataSchema;
        this.autoGenerateForms = builder.autoGenerateForms;
        this.features = builder.features;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The code generation configuration for the codegen job.
     * </p>
     * 
     * @return The code generation configuration for the codegen job.
     */
    public final CodegenJobRenderConfig renderConfig() {
        return renderConfig;
    }

    /**
     * <p>
     * The data schema to use for a code generation job.
     * </p>
     * 
     * @return The data schema to use for a code generation job.
     */
    public final CodegenJobGenericDataSchema genericDataSchema() {
        return genericDataSchema;
    }

    /**
     * <p>
     * Specifies whether to autogenerate forms in the code generation job.
     * </p>
     * 
     * @return Specifies whether to autogenerate forms in the code generation job.
     */
    public final Boolean autoGenerateForms() {
        return autoGenerateForms;
    }

    /**
     * <p>
     * The feature flags for a code generation job.
     * </p>
     * 
     * @return The feature flags for a code generation job.
     */
    public final CodegenFeatureFlags features() {
        return features;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more key-value pairs to use when tagging the code generation job data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more key-value pairs to use when tagging the code generation job data.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(renderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(genericDataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(autoGenerateForms());
        hashCode = 31 * hashCode + Objects.hashCode(features());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCodegenJobData)) {
            return false;
        }
        StartCodegenJobData other = (StartCodegenJobData) obj;
        return Objects.equals(renderConfig(), other.renderConfig())
                && Objects.equals(genericDataSchema(), other.genericDataSchema())
                && Objects.equals(autoGenerateForms(), other.autoGenerateForms()) && Objects.equals(features(), other.features())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCodegenJobData").add("RenderConfig", renderConfig())
                .add("GenericDataSchema", genericDataSchema()).add("AutoGenerateForms", autoGenerateForms())
                .add("Features", features()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "renderConfig":
            return Optional.ofNullable(clazz.cast(renderConfig()));
        case "genericDataSchema":
            return Optional.ofNullable(clazz.cast(genericDataSchema()));
        case "autoGenerateForms":
            return Optional.ofNullable(clazz.cast(autoGenerateForms()));
        case "features":
            return Optional.ofNullable(clazz.cast(features()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("renderConfig", RENDER_CONFIG_FIELD);
        map.put("genericDataSchema", GENERIC_DATA_SCHEMA_FIELD);
        map.put("autoGenerateForms", AUTO_GENERATE_FORMS_FIELD);
        map.put("features", FEATURES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCodegenJobData, T> g) {
        return obj -> g.apply((StartCodegenJobData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartCodegenJobData> {
        /**
         * <p>
         * The code generation configuration for the codegen job.
         * </p>
         * 
         * @param renderConfig
         *        The code generation configuration for the codegen job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderConfig(CodegenJobRenderConfig renderConfig);

        /**
         * <p>
         * The code generation configuration for the codegen job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodegenJobRenderConfig.Builder} avoiding
         * the need to create one manually via {@link CodegenJobRenderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodegenJobRenderConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #renderConfig(CodegenJobRenderConfig)}.
         * 
         * @param renderConfig
         *        a consumer that will call methods on {@link CodegenJobRenderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renderConfig(CodegenJobRenderConfig)
         */
        default Builder renderConfig(Consumer<CodegenJobRenderConfig.Builder> renderConfig) {
            return renderConfig(CodegenJobRenderConfig.builder().applyMutation(renderConfig).build());
        }

        /**
         * <p>
         * The data schema to use for a code generation job.
         * </p>
         * 
         * @param genericDataSchema
         *        The data schema to use for a code generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder genericDataSchema(CodegenJobGenericDataSchema genericDataSchema);

        /**
         * <p>
         * The data schema to use for a code generation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodegenJobGenericDataSchema.Builder}
         * avoiding the need to create one manually via {@link CodegenJobGenericDataSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodegenJobGenericDataSchema.Builder#build()} is called
         * immediately and its result is passed to {@link #genericDataSchema(CodegenJobGenericDataSchema)}.
         * 
         * @param genericDataSchema
         *        a consumer that will call methods on {@link CodegenJobGenericDataSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #genericDataSchema(CodegenJobGenericDataSchema)
         */
        default Builder genericDataSchema(Consumer<CodegenJobGenericDataSchema.Builder> genericDataSchema) {
            return genericDataSchema(CodegenJobGenericDataSchema.builder().applyMutation(genericDataSchema).build());
        }

        /**
         * <p>
         * Specifies whether to autogenerate forms in the code generation job.
         * </p>
         * 
         * @param autoGenerateForms
         *        Specifies whether to autogenerate forms in the code generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoGenerateForms(Boolean autoGenerateForms);

        /**
         * <p>
         * The feature flags for a code generation job.
         * </p>
         * 
         * @param features
         *        The feature flags for a code generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(CodegenFeatureFlags features);

        /**
         * <p>
         * The feature flags for a code generation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodegenFeatureFlags.Builder} avoiding the
         * need to create one manually via {@link CodegenFeatureFlags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodegenFeatureFlags.Builder#build()} is called immediately and
         * its result is passed to {@link #features(CodegenFeatureFlags)}.
         * 
         * @param features
         *        a consumer that will call methods on {@link CodegenFeatureFlags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #features(CodegenFeatureFlags)
         */
        default Builder features(Consumer<CodegenFeatureFlags.Builder> features) {
            return features(CodegenFeatureFlags.builder().applyMutation(features).build());
        }

        /**
         * <p>
         * One or more key-value pairs to use when tagging the code generation job data.
         * </p>
         * 
         * @param tags
         *        One or more key-value pairs to use when tagging the code generation job data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private CodegenJobRenderConfig renderConfig;

        private CodegenJobGenericDataSchema genericDataSchema;

        private Boolean autoGenerateForms;

        private CodegenFeatureFlags features;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartCodegenJobData model) {
            renderConfig(model.renderConfig);
            genericDataSchema(model.genericDataSchema);
            autoGenerateForms(model.autoGenerateForms);
            features(model.features);
            tags(model.tags);
        }

        public final CodegenJobRenderConfig.Builder getRenderConfig() {
            return renderConfig != null ? renderConfig.toBuilder() : null;
        }

        public final void setRenderConfig(CodegenJobRenderConfig.BuilderImpl renderConfig) {
            this.renderConfig = renderConfig != null ? renderConfig.build() : null;
        }

        @Override
        public final Builder renderConfig(CodegenJobRenderConfig renderConfig) {
            this.renderConfig = renderConfig;
            return this;
        }

        public final CodegenJobGenericDataSchema.Builder getGenericDataSchema() {
            return genericDataSchema != null ? genericDataSchema.toBuilder() : null;
        }

        public final void setGenericDataSchema(CodegenJobGenericDataSchema.BuilderImpl genericDataSchema) {
            this.genericDataSchema = genericDataSchema != null ? genericDataSchema.build() : null;
        }

        @Override
        public final Builder genericDataSchema(CodegenJobGenericDataSchema genericDataSchema) {
            this.genericDataSchema = genericDataSchema;
            return this;
        }

        public final Boolean getAutoGenerateForms() {
            return autoGenerateForms;
        }

        public final void setAutoGenerateForms(Boolean autoGenerateForms) {
            this.autoGenerateForms = autoGenerateForms;
        }

        @Override
        public final Builder autoGenerateForms(Boolean autoGenerateForms) {
            this.autoGenerateForms = autoGenerateForms;
            return this;
        }

        public final CodegenFeatureFlags.Builder getFeatures() {
            return features != null ? features.toBuilder() : null;
        }

        public final void setFeatures(CodegenFeatureFlags.BuilderImpl features) {
            this.features = features != null ? features.build() : null;
        }

        @Override
        public final Builder features(CodegenFeatureFlags features) {
            this.features = features;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public StartCodegenJobData build() {
            return new StartCodegenJobData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
