/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Associates a complex object with a display value. Use <code>ValueMapping</code> to store how to represent complex
 * objects when they are displayed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValueMapping implements SdkPojo, Serializable, ToCopyableBuilder<ValueMapping.Builder, ValueMapping> {
    private static final SdkField<FormInputValueProperty> DISPLAY_VALUE_FIELD = SdkField
            .<FormInputValueProperty> builder(MarshallingType.SDK_POJO).memberName("displayValue")
            .getter(getter(ValueMapping::displayValue)).setter(setter(Builder::displayValue))
            .constructor(FormInputValueProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayValue").build()).build();

    private static final SdkField<FormInputValueProperty> VALUE_FIELD = SdkField
            .<FormInputValueProperty> builder(MarshallingType.SDK_POJO).memberName("value").getter(getter(ValueMapping::value))
            .setter(setter(Builder::value)).constructor(FormInputValueProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_VALUE_FIELD,
            VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FormInputValueProperty displayValue;

    private final FormInputValueProperty value;

    private ValueMapping(BuilderImpl builder) {
        this.displayValue = builder.displayValue;
        this.value = builder.value;
    }

    /**
     * <p>
     * The value to display for the complex object.
     * </p>
     * 
     * @return The value to display for the complex object.
     */
    public final FormInputValueProperty displayValue() {
        return displayValue;
    }

    /**
     * <p>
     * The complex object.
     * </p>
     * 
     * @return The complex object.
     */
    public final FormInputValueProperty value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayValue());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValueMapping)) {
            return false;
        }
        ValueMapping other = (ValueMapping) obj;
        return Objects.equals(displayValue(), other.displayValue()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValueMapping").add("DisplayValue", displayValue()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "displayValue":
            return Optional.ofNullable(clazz.cast(displayValue()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("displayValue", DISPLAY_VALUE_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValueMapping, T> g) {
        return obj -> g.apply((ValueMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValueMapping> {
        /**
         * <p>
         * The value to display for the complex object.
         * </p>
         * 
         * @param displayValue
         *        The value to display for the complex object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayValue(FormInputValueProperty displayValue);

        /**
         * <p>
         * The value to display for the complex object.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormInputValueProperty.Builder} avoiding
         * the need to create one manually via {@link FormInputValueProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormInputValueProperty.Builder#build()} is called immediately and
         * its result is passed to {@link #displayValue(FormInputValueProperty)}.
         * 
         * @param displayValue
         *        a consumer that will call methods on {@link FormInputValueProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayValue(FormInputValueProperty)
         */
        default Builder displayValue(Consumer<FormInputValueProperty.Builder> displayValue) {
            return displayValue(FormInputValueProperty.builder().applyMutation(displayValue).build());
        }

        /**
         * <p>
         * The complex object.
         * </p>
         * 
         * @param value
         *        The complex object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(FormInputValueProperty value);

        /**
         * <p>
         * The complex object.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormInputValueProperty.Builder} avoiding
         * the need to create one manually via {@link FormInputValueProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormInputValueProperty.Builder#build()} is called immediately and
         * its result is passed to {@link #value(FormInputValueProperty)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link FormInputValueProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(FormInputValueProperty)
         */
        default Builder value(Consumer<FormInputValueProperty.Builder> value) {
            return value(FormInputValueProperty.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FormInputValueProperty displayValue;

        private FormInputValueProperty value;

        private BuilderImpl() {
        }

        private BuilderImpl(ValueMapping model) {
            displayValue(model.displayValue);
            value(model.value);
        }

        public final FormInputValueProperty.Builder getDisplayValue() {
            return displayValue != null ? displayValue.toBuilder() : null;
        }

        public final void setDisplayValue(FormInputValueProperty.BuilderImpl displayValue) {
            this.displayValue = displayValue != null ? displayValue.build() : null;
        }

        @Override
        public final Builder displayValue(FormInputValueProperty displayValue) {
            this.displayValue = displayValue;
            return this;
        }

        public final FormInputValueProperty.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(FormInputValueProperty.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(FormInputValueProperty value) {
            this.value = value;
            return this;
        }

        @Override
        public ValueMapping build() {
            return new ValueMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
