/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayException;
import software.amazon.awssdk.services.apigateway.model.BadRequestException;
import software.amazon.awssdk.services.apigateway.model.ConflictException;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.CreateModelRequest;
import software.amazon.awssdk.services.apigateway.model.CreateModelResponse;
import software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.CreateResourceRequest;
import software.amazon.awssdk.services.apigateway.model.CreateResourceResponse;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.CreateStageRequest;
import software.amazon.awssdk.services.apigateway.model.CreateStageResponse;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.CreateVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.CreateVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteModelRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteModelResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteResourceRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteResourceResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteStageRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteStageResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheRequest;
import software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheResponse;
import software.amazon.awssdk.services.apigateway.model.FlushStageCacheRequest;
import software.amazon.awssdk.services.apigateway.model.FlushStageCacheResponse;
import software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.GetAccountRequest;
import software.amazon.awssdk.services.apigateway.model.GetAccountResponse;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersResponse;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse;
import software.amazon.awssdk.services.apigateway.model.GetExportRequest;
import software.amazon.awssdk.services.apigateway.model.GetExportResponse;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesRequest;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesResponse;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelTemplateRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelTemplateResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelsRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelsResponse;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsRequest;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourceRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourceResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourcesRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourcesResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApisRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApisResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypeRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypeResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypesRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypesResponse;
import software.amazon.awssdk.services.apigateway.model.GetStageRequest;
import software.amazon.awssdk.services.apigateway.model.GetStageResponse;
import software.amazon.awssdk.services.apigateway.model.GetStagesRequest;
import software.amazon.awssdk.services.apigateway.model.GetStagesResponse;
import software.amazon.awssdk.services.apigateway.model.GetTagsRequest;
import software.amazon.awssdk.services.apigateway.model.GetTagsResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsageRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsageResponse;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysResponse;
import software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsRequest;
import software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsResponse;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.LimitExceededException;
import software.amazon.awssdk.services.apigateway.model.NotFoundException;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutMethodRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponse;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.PutRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.ServiceUnavailableException;
import software.amazon.awssdk.services.apigateway.model.TagResourceRequest;
import software.amazon.awssdk.services.apigateway.model.TagResourceResponse;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse;
import software.amazon.awssdk.services.apigateway.model.TooManyRequestsException;
import software.amazon.awssdk.services.apigateway.model.UnauthorizedException;
import software.amazon.awssdk.services.apigateway.model.UntagResourceRequest;
import software.amazon.awssdk.services.apigateway.model.UntagResourceResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateAccountRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateAccountResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateModelRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateModelResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateResourceRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateResourceResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateStageRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateStageResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateUsageRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.transform.CreateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateApiKeyResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateAuthorizerResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateBasePathMappingResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDocumentationPartResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDocumentationVersionResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDomainNameResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateModelResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateRequestValidatorResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateResourceResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateRestApiResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateStageResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateUsagePlanKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateUsagePlanKeyResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateUsagePlanResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateVpcLinkResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteApiKeyResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteAuthorizerResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteBasePathMappingResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteClientCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDocumentationPartResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDocumentationVersionResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDomainNameResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteGatewayResponseResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteIntegrationResponseResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteIntegrationResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteMethodResponseResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteMethodResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteModelResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteRequestValidatorResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteResourceResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteRestApiResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteStageResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteUsagePlanKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteUsagePlanKeyResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteUsagePlanResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteVpcLinkResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.FlushStageAuthorizersCacheRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.FlushStageAuthorizersCacheResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.FlushStageCacheRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.FlushStageCacheResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GenerateClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GenerateClientCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAccountRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAccountResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetApiKeyResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetApiKeysRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetApiKeysResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAuthorizerResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAuthorizersRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAuthorizersResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetBasePathMappingResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetBasePathMappingsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetBasePathMappingsResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetClientCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetClientCertificatesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetClientCertificatesResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDeploymentsResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationPartResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationPartsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationPartsResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationVersionResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationVersionsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDomainNameResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDomainNamesResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetExportRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetExportResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetGatewayResponseResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetGatewayResponsesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetGatewayResponsesResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetIntegrationResponseResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetIntegrationResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetMethodResponseResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetMethodResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelTemplateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelTemplateResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelsResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRequestValidatorResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRequestValidatorsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRequestValidatorsResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetResourceResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetResourcesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetResourcesResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRestApiResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRestApisRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRestApisResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkTypeRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkTypeResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkTypesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkTypesResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetStageResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetStagesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetStagesResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetTagsResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanKeyResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanKeysRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanKeysResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlansRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlansResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsageResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetVpcLinkResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetVpcLinksRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetVpcLinksResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportApiKeysRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportApiKeysResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportDocumentationPartsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportDocumentationPartsResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportRestApiResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutGatewayResponseResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutIntegrationResponseResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutIntegrationResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutMethodResponseResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutMethodResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutRestApiResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.TagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.TestInvokeAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.TestInvokeAuthorizerResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.TestInvokeMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.TestInvokeMethodResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UntagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateAccountRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateAccountResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateApiKeyResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateAuthorizerResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateBasePathMappingResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateClientCertificateResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDeploymentResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDocumentationPartResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDocumentationVersionResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDomainNameResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateGatewayResponseResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateIntegrationResponseResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateIntegrationResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateMethodResponseResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateMethodResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateModelResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateRequestValidatorResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateResourceResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateRestApiResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateStageResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateUsagePlanResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateUsageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateUsageResponseUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateVpcLinkResponseUnmarshaller;

/**
 * Internal implementation of {@link ApiGatewayClient}.
 *
 * @see ApiGatewayClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultApiGatewayClient implements ApiGatewayClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultApiGatewayClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(false);
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Create an <a>ApiKey</a> resource.
     * </p>
     * <div class="seeAlso"><a href="http://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html">AWS
     * CLI</a></div>
     *
     * @param createApiKeyRequest
     *        Request to create an <a>ApiKey</a> resource.
     * @return Result of the CreateApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateApiKey
     */
    @Override
    public CreateApiKeyResponse createApiKey(CreateApiKeyRequest createApiKeyRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateApiKeyResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateApiKeyRequest, CreateApiKeyResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createApiKeyRequest).withMarshaller(new CreateApiKeyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds a new <a>Authorizer</a> resource to an existing <a>RestApi</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="http://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html">AWS CLI</a></div>
     *
     * @param createAuthorizerRequest
     *        Request to add a new <a>Authorizer</a> to an existing <a>RestApi</a> resource.
     * @return Result of the CreateAuthorizer operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateAuthorizer
     */
    @Override
    public CreateAuthorizerResponse createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, LimitExceededException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateAuthorizerResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateAuthorizerRequest, CreateAuthorizerResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createAuthorizerRequest).withMarshaller(new CreateAuthorizerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param createBasePathMappingRequest
     *        Requests API Gateway to create a new <a>BasePathMapping</a> resource.
     * @return Result of the CreateBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateBasePathMapping
     */
    @Override
    public CreateBasePathMappingResponse createBasePathMapping(CreateBasePathMappingRequest createBasePathMappingRequest)
            throws UnauthorizedException, ConflictException, BadRequestException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateBasePathMappingResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateBasePathMappingRequest, CreateBasePathMappingResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createBasePathMappingRequest)
                .withMarshaller(new CreateBasePathMappingRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a <a>Deployment</a> resource, which makes a specified <a>RestApi</a> callable over the internet.
     * </p>
     *
     * @param createDeploymentRequest
     *        Requests API Gateway to create a <a>Deployment</a> resource.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDeployment
     */
    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest)
            throws UnauthorizedException, BadRequestException, NotFoundException, ConflictException, LimitExceededException,
            TooManyRequestsException, ServiceUnavailableException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateDeploymentResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDeploymentRequest).withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the CreateDocumentationPart operation.
     *
     * @param createDocumentationPartRequest
     *        Creates a new documentation part of a given API.
     * @return Result of the CreateDocumentationPart operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDocumentationPart
     */
    @Override
    public CreateDocumentationPartResponse createDocumentationPart(CreateDocumentationPartRequest createDocumentationPartRequest)
            throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateDocumentationPartResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateDocumentationPartRequest, CreateDocumentationPartResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDocumentationPartRequest)
                .withMarshaller(new CreateDocumentationPartRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the CreateDocumentationVersion operation.
     *
     * @param createDocumentationVersionRequest
     *        Creates a new documentation version of a given API.
     * @return Result of the CreateDocumentationVersion operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDocumentationVersion
     */
    @Override
    public CreateDocumentationVersionResponse createDocumentationVersion(
            CreateDocumentationVersionRequest createDocumentationVersionRequest) throws BadRequestException, ConflictException,
            UnauthorizedException, NotFoundException, LimitExceededException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateDocumentationVersionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler
                .execute(new ClientExecutionParams<CreateDocumentationVersionRequest, CreateDocumentationVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createDocumentationVersionRequest)
                        .withMarshaller(new CreateDocumentationVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new domain name.
     * </p>
     *
     * @param createDomainNameRequest
     *        A request to create a new domain name.
     * @return Result of the CreateDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDomainName
     */
    @Override
    public CreateDomainNameResponse createDomainName(CreateDomainNameRequest createDomainNameRequest)
            throws UnauthorizedException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateDomainNameResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateDomainNameRequest, CreateDomainNameResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDomainNameRequest).withMarshaller(new CreateDomainNameRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds a new <a>Model</a> resource to an existing <a>RestApi</a> resource.
     * </p>
     *
     * @param createModelRequest
     *        Request to add a new <a>Model</a> to an existing <a>RestApi</a> resource.
     * @return Result of the CreateModel operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateModel
     */
    @Override
    public CreateModelResponse createModel(CreateModelRequest createModelRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateModelResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateModelResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateModelRequest, CreateModelResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createModelRequest).withMarshaller(new CreateModelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a <a>ReqeustValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param createRequestValidatorRequest
     *        Creates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the CreateRequestValidator operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateRequestValidator
     */
    @Override
    public CreateRequestValidatorResponse createRequestValidator(CreateRequestValidatorRequest createRequestValidatorRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateRequestValidatorResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateRequestValidatorRequest, CreateRequestValidatorResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createRequestValidatorRequest)
                .withMarshaller(new CreateRequestValidatorRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a <a>Resource</a> resource.
     * </p>
     *
     * @param createResourceRequest
     *        Requests API Gateway to create a <a>Resource</a> resource.
     * @return Result of the CreateResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateResource
     */
    @Override
    public CreateResourceResponse createResource(CreateResourceRequest createResourceRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, LimitExceededException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateResourceResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateResourceRequest, CreateResourceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createResourceRequest).withMarshaller(new CreateResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new <a>RestApi</a> resource.
     * </p>
     *
     * @param createRestApiRequest
     *        The POST Request to add a new <a>RestApi</a> resource to your collection.
     * @return Result of the CreateRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateRestApi
     */
    @Override
    public CreateRestApiResponse createRestApi(CreateRestApiRequest createRestApiRequest) throws UnauthorizedException,
            LimitExceededException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<CreateRestApiResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateRestApiResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateRestApiRequest, CreateRestApiResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createRestApiRequest).withMarshaller(new CreateRestApiRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new <a>Stage</a> resource that references a pre-existing <a>Deployment</a> for the API.
     * </p>
     *
     * @param createStageRequest
     *        Requests API Gateway to create a <a>Stage</a> resource.
     * @return Result of the CreateStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateStage
     */
    @Override
    public CreateStageResponse createStage(CreateStageRequest createStageRequest) throws UnauthorizedException,
            BadRequestException, NotFoundException, ConflictException, LimitExceededException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateStageResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateStageResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateStageRequest, CreateStageResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createStageRequest).withMarshaller(new CreateStageRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the
     * payload.
     * </p>
     *
     * @param createUsagePlanRequest
     *        The POST request to create a usage plan with the name, description, throttle limits and quota limits, as
     *        well as the associated API stages, specified in the payload.
     * @return Result of the CreateUsagePlan operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateUsagePlan
     */
    @Override
    public CreateUsagePlanResponse createUsagePlan(CreateUsagePlanRequest createUsagePlanRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, LimitExceededException, ConflictException, NotFoundException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateUsagePlanResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateUsagePlanRequest, CreateUsagePlanResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createUsagePlanRequest).withMarshaller(new CreateUsagePlanRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a usage plan key for adding an existing API key to a usage plan.
     * </p>
     *
     * @param createUsagePlanKeyRequest
     *        The POST request to create a usage plan key for adding an existing API key to a usage plan.
     * @return Result of the CreateUsagePlanKey operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateUsagePlanKey
     */
    @Override
    public CreateUsagePlanKeyResponse createUsagePlanKey(CreateUsagePlanKeyRequest createUsagePlanKeyRequest)
            throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateUsagePlanKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateUsagePlanKeyResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateUsagePlanKeyRequest, CreateUsagePlanKeyResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createUsagePlanKeyRequest).withMarshaller(new CreateUsagePlanKeyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically
     * takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC
     * Endpoint services.
     * </p>
     *
     * @param createVpcLinkRequest
     *        Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that
     *        typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create
     *        and update VPC Endpoint services.
     * @return Result of the CreateVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateVpcLink
     */
    @Override
    public CreateVpcLinkResponse createVpcLink(CreateVpcLinkRequest createVpcLinkRequest) throws UnauthorizedException,
            BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<CreateVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateVpcLinkResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<CreateVpcLinkRequest, CreateVpcLinkResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createVpcLinkRequest).withMarshaller(new CreateVpcLinkRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the <a>ApiKey</a> resource.
     * </p>
     *
     * @param deleteApiKeyRequest
     *        A request to delete the <a>ApiKey</a> resource.
     * @return Result of the DeleteApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteApiKey
     */
    @Override
    public DeleteApiKeyResponse deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteApiKeyResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteApiKeyRequest, DeleteApiKeyResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteApiKeyRequest).withMarshaller(new DeleteApiKeyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="http://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html">AWS CLI</a></div>
     *
     * @param deleteAuthorizerRequest
     *        Request to delete an existing <a>Authorizer</a> resource.
     * @return Result of the DeleteAuthorizer operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteAuthorizer
     */
    @Override
    public DeleteAuthorizerResponse deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteAuthorizerResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteAuthorizerRequest, DeleteAuthorizerResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteAuthorizerRequest).withMarshaller(new DeleteAuthorizerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param deleteBasePathMappingRequest
     *        A request to delete the <a>BasePathMapping</a> resource.
     * @return Result of the DeleteBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteBasePathMapping
     */
    @Override
    public DeleteBasePathMappingResponse deleteBasePathMapping(DeleteBasePathMappingRequest deleteBasePathMappingRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteBasePathMappingResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteBasePathMappingRequest, DeleteBasePathMappingResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteBasePathMappingRequest)
                .withMarshaller(new DeleteBasePathMappingRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param deleteClientCertificateRequest
     *        A request to delete the <a>ClientCertificate</a> resource.
     * @return Result of the DeleteClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteClientCertificate
     */
    @Override
    public DeleteClientCertificateResponse deleteClientCertificate(DeleteClientCertificateRequest deleteClientCertificateRequest)
            throws UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteClientCertificateResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteClientCertificateRequest, DeleteClientCertificateResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteClientCertificateRequest)
                .withMarshaller(new DeleteClientCertificateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a <a>Deployment</a> resource. Deleting a deployment will only succeed if there are no <a>Stage</a>
     * resources associated with it.
     * </p>
     *
     * @param deleteDeploymentRequest
     *        Requests API Gateway to delete a <a>Deployment</a> resource.
     * @return Result of the DeleteDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDeployment
     */
    @Override
    public DeleteDeploymentResponse deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteDeploymentResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteDeploymentRequest, DeleteDeploymentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteDeploymentRequest).withMarshaller(new DeleteDeploymentRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the DeleteDocumentationPart operation.
     *
     * @param deleteDocumentationPartRequest
     *        Deletes an existing documentation part of an API.
     * @return Result of the DeleteDocumentationPart operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDocumentationPart
     */
    @Override
    public DeleteDocumentationPartResponse deleteDocumentationPart(DeleteDocumentationPartRequest deleteDocumentationPartRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteDocumentationPartResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteDocumentationPartRequest, DeleteDocumentationPartResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteDocumentationPartRequest)
                .withMarshaller(new DeleteDocumentationPartRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the DeleteDocumentationVersion operation.
     *
     * @param deleteDocumentationVersionRequest
     *        Deletes an existing documentation version of an API.
     * @return Result of the DeleteDocumentationVersion operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDocumentationVersion
     */
    @Override
    public DeleteDocumentationVersionResponse deleteDocumentationVersion(
            DeleteDocumentationVersionRequest deleteDocumentationVersionRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<DeleteDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteDocumentationVersionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteDocumentationVersionRequest, DeleteDocumentationVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteDocumentationVersionRequest)
                        .withMarshaller(new DeleteDocumentationVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the <a>DomainName</a> resource.
     * </p>
     *
     * @param deleteDomainNameRequest
     *        A request to delete the <a>DomainName</a> resource.
     * @return Result of the DeleteDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDomainName
     */
    @Override
    public DeleteDomainNameResponse deleteDomainName(DeleteDomainNameRequest deleteDomainNameRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<DeleteDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteDomainNameResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteDomainNameRequest, DeleteDomainNameResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteDomainNameRequest).withMarshaller(new DeleteDomainNameRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a> and
     * resets it with the default settings.
     * </p>
     *
     * @param deleteGatewayResponseRequest
     *        Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given
     *        <a>RestApi</a> and resets it with the default settings.
     * @return Result of the DeleteGatewayResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteGatewayResponse
     */
    @Override
    public DeleteGatewayResponseResponse deleteGatewayResponse(DeleteGatewayResponseRequest deleteGatewayResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteGatewayResponseResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteGatewayResponseRequest, DeleteGatewayResponseResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteGatewayResponseRequest)
                .withMarshaller(new DeleteGatewayResponseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Represents a delete integration.
     * </p>
     *
     * @param deleteIntegrationRequest
     *        Represents a delete integration request.
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteIntegration
     */
    @Override
    public DeleteIntegrationResponse deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteIntegrationResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteIntegrationRequest, DeleteIntegrationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteIntegrationRequest).withMarshaller(new DeleteIntegrationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Represents a delete integration response.
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     *        Represents a delete integration response request.
     * @return Result of the DeleteIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteIntegrationResponse
     */
    @Override
    public DeleteIntegrationResponseResponse deleteIntegrationResponse(
            DeleteIntegrationResponseRequest deleteIntegrationResponseRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<DeleteIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteIntegrationResponseResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteIntegrationResponseRequest, DeleteIntegrationResponseResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteIntegrationResponseRequest)
                        .withMarshaller(new DeleteIntegrationResponseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an existing <a>Method</a> resource.
     * </p>
     *
     * @param deleteMethodRequest
     *        Request to delete an existing <a>Method</a> resource.
     * @return Result of the DeleteMethod operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteMethod
     */
    @Override
    public DeleteMethodResponse deleteMethod(DeleteMethodRequest deleteMethodRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<DeleteMethodResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteMethodResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteMethodRequest, DeleteMethodResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteMethodRequest).withMarshaller(new DeleteMethodRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an existing <a>MethodResponse</a> resource.
     * </p>
     *
     * @param deleteMethodResponseRequest
     *        A request to delete an existing <a>MethodResponse</a> resource.
     * @return Result of the DeleteMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteMethodResponse
     */
    @Override
    public DeleteMethodResponseResponse deleteMethodResponse(DeleteMethodResponseRequest deleteMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteMethodResponseResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteMethodResponseRequest, DeleteMethodResponseResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteMethodResponseRequest)
                .withMarshaller(new DeleteMethodResponseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     *
     * @param deleteModelRequest
     *        Request to delete an existing model in an existing <a>RestApi</a> resource.
     * @return Result of the DeleteModel operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteModel
     */
    @Override
    public DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteModelResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteModelResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteModelRequest, DeleteModelResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteModelRequest).withMarshaller(new DeleteModelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param deleteRequestValidatorRequest
     *        Deletes a specified <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the DeleteRequestValidator operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteRequestValidator
     */
    @Override
    public DeleteRequestValidatorResponse deleteRequestValidator(DeleteRequestValidatorRequest deleteRequestValidatorRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteRequestValidatorResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteRequestValidatorRequest, DeleteRequestValidatorResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteRequestValidatorRequest)
                .withMarshaller(new DeleteRequestValidatorRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a <a>Resource</a> resource.
     * </p>
     *
     * @param deleteResourceRequest
     *        Request to delete a <a>Resource</a>.
     * @return Result of the DeleteResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteResource
     */
    @Override
    public DeleteResourceResponse deleteResource(DeleteResourceRequest deleteResourceRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteResourceResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteResourceRequest, DeleteResourceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteResourceRequest).withMarshaller(new DeleteResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the specified API.
     * </p>
     *
     * @param deleteRestApiRequest
     *        Request to delete the specified API from your collection.
     * @return Result of the DeleteRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteRestApi
     */
    @Override
    public DeleteRestApiResponse deleteRestApi(DeleteRestApiRequest deleteRestApiRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<DeleteRestApiResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteRestApiResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteRestApiRequest, DeleteRestApiResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteRestApiRequest).withMarshaller(new DeleteRestApiRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a <a>Stage</a> resource.
     * </p>
     *
     * @param deleteStageRequest
     *        Requests API Gateway to delete a <a>Stage</a> resource.
     * @return Result of the DeleteStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteStage
     */
    @Override
    public DeleteStageResponse deleteStage(DeleteStageRequest deleteStageRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<DeleteStageResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteStageResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteStageRequest, DeleteStageResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteStageRequest).withMarshaller(new DeleteStageRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a usage plan of a given plan Id.
     * </p>
     *
     * @param deleteUsagePlanRequest
     *        The DELETE request to delete a usage plan of a given plan Id.
     * @return Result of the DeleteUsagePlan operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteUsagePlan
     */
    @Override
    public DeleteUsagePlanResponse deleteUsagePlan(DeleteUsagePlanRequest deleteUsagePlanRequest) throws UnauthorizedException,
            TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<DeleteUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteUsagePlanResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteUsagePlanRequest, DeleteUsagePlanResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteUsagePlanRequest).withMarshaller(new DeleteUsagePlanRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a usage plan key and remove the underlying API key from the associated usage plan.
     * </p>
     *
     * @param deleteUsagePlanKeyRequest
     *        The DELETE request to delete a usage plan key and remove the underlying API key from the associated usage
     *        plan.
     * @return Result of the DeleteUsagePlanKey operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteUsagePlanKey
     */
    @Override
    public DeleteUsagePlanKeyResponse deleteUsagePlanKey(DeleteUsagePlanKeyRequest deleteUsagePlanKeyRequest)
            throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<DeleteUsagePlanKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteUsagePlanKeyResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteUsagePlanKeyRequest, DeleteUsagePlanKeyResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteUsagePlanKeyRequest).withMarshaller(new DeleteUsagePlanKeyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an existing <a>VpcLink</a> of a specified identifier.
     * </p>
     *
     * @param deleteVpcLinkRequest
     *        Deletes an existing <a>VpcLink</a> of a specified identifier.
     * @return Result of the DeleteVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteVpcLink
     */
    @Override
    public DeleteVpcLinkResponse deleteVpcLink(DeleteVpcLinkRequest deleteVpcLinkRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<DeleteVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteVpcLinkResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<DeleteVpcLinkRequest, DeleteVpcLinkResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteVpcLinkRequest).withMarshaller(new DeleteVpcLinkRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Flushes all authorizer cache entries on a stage.
     * </p>
     *
     * @param flushStageAuthorizersCacheRequest
     *        Request to flush authorizer cache entries on a specified stage.
     * @return Result of the FlushStageAuthorizersCache operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.FlushStageAuthorizersCache
     */
    @Override
    public FlushStageAuthorizersCacheResponse flushStageAuthorizersCache(
            FlushStageAuthorizersCacheRequest flushStageAuthorizersCacheRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<FlushStageAuthorizersCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new FlushStageAuthorizersCacheResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler
                .execute(new ClientExecutionParams<FlushStageAuthorizersCacheRequest, FlushStageAuthorizersCacheResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(flushStageAuthorizersCacheRequest)
                        .withMarshaller(new FlushStageAuthorizersCacheRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Flushes a stage's cache.
     * </p>
     *
     * @param flushStageCacheRequest
     *        Requests API Gateway to flush a stage's cache.
     * @return Result of the FlushStageCache operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.FlushStageCache
     */
    @Override
    public FlushStageCacheResponse flushStageCache(FlushStageCacheRequest flushStageCacheRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<FlushStageCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new FlushStageCacheResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<FlushStageCacheRequest, FlushStageCacheResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(flushStageCacheRequest).withMarshaller(new FlushStageCacheRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Generates a <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param generateClientCertificateRequest
     *        A request to generate a <a>ClientCertificate</a> resource.
     * @return Result of the GenerateClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GenerateClientCertificate
     */
    @Override
    public GenerateClientCertificateResponse generateClientCertificate(
            GenerateClientCertificateRequest generateClientCertificateRequest) throws UnauthorizedException,
            TooManyRequestsException, LimitExceededException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GenerateClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GenerateClientCertificateResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler
                .execute(new ClientExecutionParams<GenerateClientCertificateRequest, GenerateClientCertificateResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(generateClientCertificateRequest)
                        .withMarshaller(new GenerateClientCertificateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about the current <a>Account</a> resource.
     * </p>
     *
     * @param getAccountRequest
     *        Requests API Gateway to get information about the current <a>Account</a> resource.
     * @return Result of the GetAccount operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAccount
     */
    @Override
    public GetAccountResponse getAccount(GetAccountRequest getAccountRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetAccountResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetAccountRequest, GetAccountResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getAccountRequest)
                .withMarshaller(new GetAccountRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKey</a> resource.
     * </p>
     *
     * @param getApiKeyRequest
     *        A request to get information about the current <a>ApiKey</a> resource.
     * @return Result of the GetApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKey
     */
    @Override
    public GetApiKeyResponse getApiKey(GetApiKeyRequest getApiKeyRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetApiKeyResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetApiKeyRequest, GetApiKeyResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getApiKeyRequest)
                .withMarshaller(new GetApiKeyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKeys</a> resource.
     * </p>
     *
     * @param getApiKeysRequest
     *        A request to get information about the current <a>ApiKeys</a> resource.
     * @return Result of the GetApiKeys operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKeys
     */
    @Override
    public GetApiKeysResponse getApiKeys(GetApiKeysRequest getApiKeysRequest) throws BadRequestException, UnauthorizedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetApiKeysResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetApiKeysResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetApiKeysRequest, GetApiKeysResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getApiKeysRequest)
                .withMarshaller(new GetApiKeysRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describe an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a href="http://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html">AWS
     * CLI</a></div>
     *
     * @param getAuthorizerRequest
     *        Request to describe an existing <a>Authorizer</a> resource.
     * @return Result of the GetAuthorizer operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAuthorizer
     */
    @Override
    public GetAuthorizerResponse getAuthorizer(GetAuthorizerRequest getAuthorizerRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetAuthorizerResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetAuthorizerRequest, GetAuthorizerResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getAuthorizerRequest).withMarshaller(new GetAuthorizerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describe an existing <a>Authorizers</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="http://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html">AWS CLI</a></div>
     *
     * @param getAuthorizersRequest
     *        Request to describe an existing <a>Authorizers</a> resource.
     * @return Result of the GetAuthorizers operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAuthorizers
     */
    @Override
    public GetAuthorizersResponse getAuthorizers(GetAuthorizersRequest getAuthorizersRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetAuthorizersResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetAuthorizersResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetAuthorizersRequest, GetAuthorizersResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getAuthorizersRequest).withMarshaller(new GetAuthorizersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describe a <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param getBasePathMappingRequest
     *        Request to describe a <a>BasePathMapping</a> resource.
     * @return Result of the GetBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetBasePathMapping
     */
    @Override
    public GetBasePathMappingResponse getBasePathMapping(GetBasePathMappingRequest getBasePathMappingRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBasePathMappingResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetBasePathMappingRequest, GetBasePathMappingResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getBasePathMappingRequest).withMarshaller(new GetBasePathMappingRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Represents a collection of <a>BasePathMapping</a> resources.
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A request to get information about a collection of <a>BasePathMapping</a> resources.
     * @return Result of the GetBasePathMappings operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetBasePathMappings
     */
    @Override
    public GetBasePathMappingsResponse getBasePathMappings(GetBasePathMappingsRequest getBasePathMappingsRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetBasePathMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBasePathMappingsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetBasePathMappingsRequest, GetBasePathMappingsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getBasePathMappingsRequest).withMarshaller(new GetBasePathMappingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about the current <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param getClientCertificateRequest
     *        A request to get information about the current <a>ClientCertificate</a> resource.
     * @return Result of the GetClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificate
     */
    @Override
    public GetClientCertificateResponse getClientCertificate(GetClientCertificateRequest getClientCertificateRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetClientCertificateResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetClientCertificateRequest, GetClientCertificateResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getClientCertificateRequest)
                .withMarshaller(new GetClientCertificateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a collection of <a>ClientCertificate</a> resources.
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A request to get information about a collection of <a>ClientCertificate</a> resources.
     * @return Result of the GetClientCertificates operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificates
     */
    @Override
    public GetClientCertificatesResponse getClientCertificates(GetClientCertificatesRequest getClientCertificatesRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetClientCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetClientCertificatesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetClientCertificatesRequest, GetClientCertificatesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getClientCertificatesRequest)
                .withMarshaller(new GetClientCertificatesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about a <a>Deployment</a> resource.
     * </p>
     *
     * @param getDeploymentRequest
     *        Requests API Gateway to get information about a <a>Deployment</a> resource.
     * @return Result of the GetDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDeployment
     */
    @Override
    public GetDeploymentResponse getDeployment(GetDeploymentRequest getDeploymentRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDeploymentResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetDeploymentRequest, GetDeploymentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDeploymentRequest).withMarshaller(new GetDeploymentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about a <a>Deployments</a> collection.
     * </p>
     *
     * @param getDeploymentsRequest
     *        Requests API Gateway to get information about a <a>Deployments</a> collection.
     * @return Result of the GetDeployments operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDeployments
     */
    @Override
    public GetDeploymentsResponse getDeployments(GetDeploymentsRequest getDeploymentsRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDeploymentsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetDeploymentsRequest, GetDeploymentsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDeploymentsRequest).withMarshaller(new GetDeploymentsRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the GetDocumentationPart operation.
     *
     * @param getDocumentationPartRequest
     *        Gets a specified documentation part of a given API.
     * @return Result of the GetDocumentationPart operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationPart
     */
    @Override
    public GetDocumentationPartResponse getDocumentationPart(GetDocumentationPartRequest getDocumentationPartRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDocumentationPartResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetDocumentationPartRequest, GetDocumentationPartResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDocumentationPartRequest)
                .withMarshaller(new GetDocumentationPartRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the GetDocumentationParts operation.
     *
     * @param getDocumentationPartsRequest
     *        Gets the documentation parts of an API. The result may be filtered by the type, name, or path of API
     *        entities (targets).
     * @return Result of the GetDocumentationParts operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationParts
     */
    @Override
    public GetDocumentationPartsResponse getDocumentationParts(GetDocumentationPartsRequest getDocumentationPartsRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetDocumentationPartsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDocumentationPartsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetDocumentationPartsRequest, GetDocumentationPartsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDocumentationPartsRequest)
                .withMarshaller(new GetDocumentationPartsRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the GetDocumentationVersion operation.
     *
     * @param getDocumentationVersionRequest
     *        Gets a documentation snapshot of an API.
     * @return Result of the GetDocumentationVersion operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationVersion
     */
    @Override
    public GetDocumentationVersionResponse getDocumentationVersion(GetDocumentationVersionRequest getDocumentationVersionRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDocumentationVersionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetDocumentationVersionRequest, GetDocumentationVersionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDocumentationVersionRequest)
                .withMarshaller(new GetDocumentationVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the GetDocumentationVersions operation.
     *
     * @param getDocumentationVersionsRequest
     *        Gets the documentation versions of an API.
     * @return Result of the GetDocumentationVersions operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationVersions
     */
    @Override
    public GetDocumentationVersionsResponse getDocumentationVersions(
            GetDocumentationVersionsRequest getDocumentationVersionsRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetDocumentationVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDocumentationVersionsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler
                .execute(new ClientExecutionParams<GetDocumentationVersionsRequest, GetDocumentationVersionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getDocumentationVersionsRequest)
                        .withMarshaller(new GetDocumentationVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
     * </p>
     *
     * @param getDomainNameRequest
     *        Request to get the name of a <a>DomainName</a> resource.
     * @return Result of the GetDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainName
     */
    @Override
    public GetDomainNameResponse getDomainName(GetDomainNameRequest getDomainNameRequest) throws UnauthorizedException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDomainNameResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetDomainNameRequest, GetDomainNameResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDomainNameRequest).withMarshaller(new GetDomainNameRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Represents a collection of <a>DomainName</a> resources.
     * </p>
     *
     * @param getDomainNamesRequest
     *        Request to describe a collection of <a>DomainName</a> resources.
     * @return Result of the GetDomainNames operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainNames
     */
    @Override
    public GetDomainNamesResponse getDomainNames(GetDomainNamesRequest getDomainNamesRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetDomainNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDomainNamesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetDomainNamesRequest, GetDomainNamesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDomainNamesRequest).withMarshaller(new GetDomainNamesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Exports a deployed version of a <a>RestApi</a> in a specified format.
     * </p>
     *
     * @param getExportRequest
     *        Request a new export of a <a>RestApi</a> for a particular <a>Stage</a>.
     * @return Result of the GetExport operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetExport
     */
    @Override
    public GetExportResponse getExport(GetExportRequest getExportRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetExportResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(false),
                new GetExportResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetExportRequest, GetExportResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getExportRequest)
                .withMarshaller(new GetExportRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * </p>
     *
     * @param getGatewayResponseRequest
     *        Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * @return Result of the GetGatewayResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetGatewayResponse
     */
    @Override
    public GetGatewayResponseResponse getGatewayResponse(GetGatewayResponseRequest getGatewayResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetGatewayResponseResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetGatewayResponseRequest, GetGatewayResponseResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getGatewayResponseRequest).withMarshaller(new GetGatewayResponseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added any
     * definitions for gateway responses, the result will be the API Gateway-generated default <a>GatewayResponses</a>
     * collection for the supported response types.
     * </p>
     *
     * @param getGatewayResponsesRequest
     *        Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added
     *        any definitions for gateway responses, the result will be the API Gateway-generated default
     *        <a>GatewayResponses</a> collection for the supported response types.
     * @return Result of the GetGatewayResponses operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetGatewayResponses
     */
    @Override
    public GetGatewayResponsesResponse getGatewayResponses(GetGatewayResponsesRequest getGatewayResponsesRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetGatewayResponsesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetGatewayResponsesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetGatewayResponsesRequest, GetGatewayResponsesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getGatewayResponsesRequest).withMarshaller(new GetGatewayResponsesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get the integration settings.
     * </p>
     *
     * @param getIntegrationRequest
     *        Represents a request to get the integration configuration.
     * @return Result of the GetIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetIntegration
     */
    @Override
    public GetIntegrationResponse getIntegration(GetIntegrationRequest getIntegrationRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetIntegrationResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetIntegrationRequest, GetIntegrationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getIntegrationRequest).withMarshaller(new GetIntegrationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Represents a get integration response.
     * </p>
     *
     * @param getIntegrationResponseRequest
     *        Represents a get integration response request.
     * @return Result of the GetIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetIntegrationResponse
     */
    @Override
    public GetIntegrationResponseResponse getIntegrationResponse(GetIntegrationResponseRequest getIntegrationResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetIntegrationResponseResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetIntegrationResponseRequest, GetIntegrationResponseResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getIntegrationResponseRequest)
                .withMarshaller(new GetIntegrationResponseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describe an existing <a>Method</a> resource.
     * </p>
     *
     * @param getMethodRequest
     *        Request to describe an existing <a>Method</a> resource.
     * @return Result of the GetMethod operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetMethod
     */
    @Override
    public GetMethodResponse getMethod(GetMethodRequest getMethodRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetMethodResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetMethodResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetMethodRequest, GetMethodResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getMethodRequest)
                .withMarshaller(new GetMethodRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describes a <a>MethodResponse</a> resource.
     * </p>
     *
     * @param getMethodResponseRequest
     *        Request to describe a <a>MethodResponse</a> resource.
     * @return Result of the GetMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetMethodResponse
     */
    @Override
    public GetMethodResponseResponse getMethodResponse(GetMethodResponseRequest getMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetMethodResponseResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetMethodResponseRequest, GetMethodResponseResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getMethodResponseRequest).withMarshaller(new GetMethodResponseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describes an existing model defined for a <a>RestApi</a> resource.
     * </p>
     *
     * @param getModelRequest
     *        Request to list information about a model in an existing <a>RestApi</a> resource.
     * @return Result of the GetModel operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModel
     */
    @Override
    public GetModelResponse getModel(GetModelRequest getModelRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetModelResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetModelResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetModelRequest, GetModelResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getModelRequest)
                .withMarshaller(new GetModelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Generates a sample mapping template that can be used to transform a payload into the structure of a model.
     * </p>
     *
     * @param getModelTemplateRequest
     *        Request to generate a sample mapping template used to transform the payload.
     * @return Result of the GetModelTemplate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModelTemplate
     */
    @Override
    public GetModelTemplateResponse getModelTemplate(GetModelTemplateRequest getModelTemplateRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetModelTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetModelTemplateResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetModelTemplateRequest, GetModelTemplateResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getModelTemplateRequest).withMarshaller(new GetModelTemplateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describes existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * </p>
     *
     * @param getModelsRequest
     *        Request to list existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * @return Result of the GetModels operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModels
     */
    @Override
    public GetModelsResponse getModels(GetModelsRequest getModelsRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetModelsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetModelsRequest, GetModelsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getModelsRequest)
                .withMarshaller(new GetModelsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param getRequestValidatorRequest
     *        Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the GetRequestValidator operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRequestValidator
     */
    @Override
    public GetRequestValidatorResponse getRequestValidator(GetRequestValidatorRequest getRequestValidatorRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetRequestValidatorResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetRequestValidatorRequest, GetRequestValidatorResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getRequestValidatorRequest).withMarshaller(new GetRequestValidatorRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.
     * </p>
     *
     * @param getRequestValidatorsRequest
     *        Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.
     * @return Result of the GetRequestValidators operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRequestValidators
     */
    @Override
    public GetRequestValidatorsResponse getRequestValidators(GetRequestValidatorsRequest getRequestValidatorsRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetRequestValidatorsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetRequestValidatorsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetRequestValidatorsRequest, GetRequestValidatorsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getRequestValidatorsRequest)
                .withMarshaller(new GetRequestValidatorsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists information about a resource.
     * </p>
     *
     * @param getResourceRequest
     *        Request to list information about a resource.
     * @return Result of the GetResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetResource
     */
    @Override
    public GetResourceResponse getResource(GetResourceRequest getResourceRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetResourceResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetResourceRequest, GetResourceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getResourceRequest).withMarshaller(new GetResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists information about a collection of <a>Resource</a> resources.
     * </p>
     *
     * @param getResourcesRequest
     *        Request to list information about a collection of resources.
     * @return Result of the GetResources operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetResources
     */
    @Override
    public GetResourcesResponse getResources(GetResourcesRequest getResourcesRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetResourcesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetResourcesRequest, GetResourcesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getResourcesRequest).withMarshaller(new GetResourcesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the <a>RestApi</a> resource in the collection.
     * </p>
     *
     * @param getRestApiRequest
     *        The GET request to list an existing <a>RestApi</a> defined for your collection.
     * @return Result of the GetRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApi
     */
    @Override
    public GetRestApiResponse getRestApi(GetRestApiRequest getRestApiRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetRestApiResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetRestApiResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetRestApiRequest, GetRestApiResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getRestApiRequest)
                .withMarshaller(new GetRestApiRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the <a>RestApis</a> resources for your collection.
     * </p>
     *
     * @param getRestApisRequest
     *        The GET request to list existing <a>RestApis</a> defined for your collection.
     * @return Result of the GetRestApis operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApis
     */
    @Override
    public GetRestApisResponse getRestApis(GetRestApisRequest getRestApisRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetRestApisResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetRestApisResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetRestApisRequest, GetRestApisResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getRestApisRequest).withMarshaller(new GetRestApisRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Generates a client SDK for a <a>RestApi</a> and <a>Stage</a>.
     * </p>
     *
     * @param getSdkRequest
     *        Request a new generated client SDK for a <a>RestApi</a> and <a>Stage</a>.
     * @return Result of the GetSdk operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdk
     */
    @Override
    public GetSdkResponse getSdk(GetSdkRequest getSdkRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetSdkResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(false).withHasStreamingSuccessResponse(false), new GetSdkResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetSdkRequest, GetSdkResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getSdkRequest)
                .withMarshaller(new GetSdkRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the GetSdkType operation.
     *
     * @param getSdkTypeRequest
     *        Get an <a>SdkType</a> instance.
     * @return Result of the GetSdkType operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdkType
     */
    @Override
    public GetSdkTypeResponse getSdkType(GetSdkTypeRequest getSdkTypeRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetSdkTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetSdkTypeResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetSdkTypeRequest, GetSdkTypeResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getSdkTypeRequest)
                .withMarshaller(new GetSdkTypeRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the GetSdkTypes operation.
     *
     * @param getSdkTypesRequest
     *        Get the <a>SdkTypes</a> collection.
     * @return Result of the GetSdkTypes operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdkTypes
     */
    @Override
    public GetSdkTypesResponse getSdkTypes(GetSdkTypesRequest getSdkTypesRequest) throws UnauthorizedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetSdkTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetSdkTypesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetSdkTypesRequest, GetSdkTypesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getSdkTypesRequest).withMarshaller(new GetSdkTypesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about a <a>Stage</a> resource.
     * </p>
     *
     * @param getStageRequest
     *        Requests API Gateway to get information about a <a>Stage</a> resource.
     * @return Result of the GetStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetStage
     */
    @Override
    public GetStageResponse getStage(GetStageRequest getStageRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetStageResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetStageResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetStageRequest, GetStageResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getStageRequest)
                .withMarshaller(new GetStageRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about one or more <a>Stage</a> resources.
     * </p>
     *
     * @param getStagesRequest
     *        Requests API Gateway to get information about one or more <a>Stage</a> resources.
     * @return Result of the GetStages operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetStages
     */
    @Override
    public GetStagesResponse getStages(GetStagesRequest getStagesRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetStagesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetStagesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetStagesRequest, GetStagesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getStagesRequest)
                .withMarshaller(new GetStagesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the <a>Tags</a> collection for a given resource.
     * </p>
     *
     * @param getTagsRequest
     *        Gets the <a>Tags</a> collection for a given resource.
     * @return Result of the GetTags operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetTags
     */
    @Override
    public GetTagsResponse getTags(GetTagsRequest getTagsRequest) throws BadRequestException, UnauthorizedException,
            TooManyRequestsException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetTagsResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetTagsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetTagsRequest, GetTagsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getTagsRequest)
                .withMarshaller(new GetTagsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the usage data of a usage plan in a specified time interval.
     * </p>
     *
     * @param getUsageRequest
     *        The GET request to get the usage data of a usage plan in a specified time interval.
     * @return Result of the GetUsage operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsage
     */
    @Override
    public GetUsageResponse getUsage(GetUsageRequest getUsageRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetUsageResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetUsageResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetUsageRequest, GetUsageResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getUsageRequest)
                .withMarshaller(new GetUsageRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a usage plan of a given plan identifier.
     * </p>
     *
     * @param getUsagePlanRequest
     *        The GET request to get a usage plan of a given plan identifier.
     * @return Result of the GetUsagePlan operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlan
     */
    @Override
    public GetUsagePlanResponse getUsagePlan(GetUsagePlanRequest getUsagePlanRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetUsagePlanResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetUsagePlanRequest, GetUsagePlanResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getUsagePlanRequest).withMarshaller(new GetUsagePlanRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a usage plan key of a given key identifier.
     * </p>
     *
     * @param getUsagePlanKeyRequest
     *        The GET request to get a usage plan key of a given key identifier.
     * @return Result of the GetUsagePlanKey operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlanKey
     */
    @Override
    public GetUsagePlanKeyResponse getUsagePlanKey(GetUsagePlanKeyRequest getUsagePlanKeyRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetUsagePlanKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetUsagePlanKeyResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetUsagePlanKeyRequest, GetUsagePlanKeyResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getUsagePlanKeyRequest).withMarshaller(new GetUsagePlanKeyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
     * @return Result of the GetUsagePlanKeys operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlanKeys
     */
    @Override
    public GetUsagePlanKeysResponse getUsagePlanKeys(GetUsagePlanKeysRequest getUsagePlanKeysRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<GetUsagePlanKeysResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetUsagePlanKeysResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetUsagePlanKeysRequest, GetUsagePlanKeysResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getUsagePlanKeysRequest).withMarshaller(new GetUsagePlanKeysRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     *
     * @param getUsagePlansRequest
     *        The GET request to get all the usage plans of the caller's account.
     * @return Result of the GetUsagePlans operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlans
     */
    @Override
    public GetUsagePlansResponse getUsagePlans(GetUsagePlansRequest getUsagePlansRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, ConflictException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetUsagePlansResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetUsagePlansResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetUsagePlansRequest, GetUsagePlansResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getUsagePlansRequest).withMarshaller(new GetUsagePlansRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a specified VPC link under the caller's account in a region.
     * </p>
     *
     * @param getVpcLinkRequest
     *        Gets a specified VPC link under the caller's account in a region.
     * @return Result of the GetVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLink
     */
    @Override
    public GetVpcLinkResponse getVpcLink(GetVpcLinkRequest getVpcLinkRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetVpcLinkResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetVpcLinkRequest, GetVpcLinkResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getVpcLinkRequest)
                .withMarshaller(new GetVpcLinkRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * </p>
     *
     * @param getVpcLinksRequest
     *        Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * @return Result of the GetVpcLinks operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLinks
     */
    @Override
    public GetVpcLinksResponse getVpcLinks(GetVpcLinksRequest getVpcLinksRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<GetVpcLinksResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetVpcLinksResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<GetVpcLinksRequest, GetVpcLinksResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getVpcLinksRequest).withMarshaller(new GetVpcLinksRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Import API keys from an external source, such as a CSV-formatted file.
     * </p>
     *
     * @param importApiKeysRequest
     *        The POST request to import API keys from an external source, such as a CSV-formatted file.
     * @return Result of the ImportApiKeys operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.ImportApiKeys
     */
    @Override
    public ImportApiKeysResponse importApiKeys(ImportApiKeysRequest importApiKeysRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<ImportApiKeysResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ImportApiKeysResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<ImportApiKeysRequest, ImportApiKeysResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(importApiKeysRequest).withMarshaller(new ImportApiKeysRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the ImportDocumentationParts operation.
     *
     * @param importDocumentationPartsRequest
     *        Import documentation parts from an external (e.g., Swagger) definition file.
     * @return Result of the ImportDocumentationParts operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.ImportDocumentationParts
     */
    @Override
    public ImportDocumentationPartsResponse importDocumentationParts(
            ImportDocumentationPartsRequest importDocumentationPartsRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, LimitExceededException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<ImportDocumentationPartsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ImportDocumentationPartsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler
                .execute(new ClientExecutionParams<ImportDocumentationPartsRequest, ImportDocumentationPartsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(importDocumentationPartsRequest)
                        .withMarshaller(new ImportDocumentationPartsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * A feature of the API Gateway control service for creating a new API from an external API definition file.
     * </p>
     *
     * @param importRestApiRequest
     *        A POST request to import an API to API Gateway using an input of an API definition file.
     * @return Result of the ImportRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.ImportRestApi
     */
    @Override
    public ImportRestApiResponse importRestApi(ImportRestApiRequest importRestApiRequest) throws UnauthorizedException,
            LimitExceededException, BadRequestException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<ImportRestApiResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ImportRestApiResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<ImportRestApiRequest, ImportRestApiResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(importRestApiRequest).withMarshaller(new ImportRestApiRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the given
     * <a>RestApi</a>.
     * </p>
     *
     * @param putGatewayResponseRequest
     *        Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the
     *        given <a>RestApi</a>.
     * @return Result of the PutGatewayResponse operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutGatewayResponse
     */
    @Override
    public PutGatewayResponseResponse putGatewayResponse(PutGatewayResponseRequest putGatewayResponseRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<PutGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutGatewayResponseResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<PutGatewayResponseRequest, PutGatewayResponseResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putGatewayResponseRequest).withMarshaller(new PutGatewayResponseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Sets up a method's integration.
     * </p>
     *
     * @param putIntegrationRequest
     *        Sets up a method's integration.
     * @return Result of the PutIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutIntegration
     */
    @Override
    public PutIntegrationResponse putIntegration(PutIntegrationRequest putIntegrationRequest) throws UnauthorizedException,
            BadRequestException, ConflictException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<PutIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutIntegrationResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<PutIntegrationRequest, PutIntegrationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putIntegrationRequest).withMarshaller(new PutIntegrationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Represents a put integration.
     * </p>
     *
     * @param putIntegrationResponseRequest
     *        Represents a put integration response request.
     * @return Result of the PutIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutIntegrationResponse
     */
    @Override
    public PutIntegrationResponseResponse putIntegrationResponse(PutIntegrationResponseRequest putIntegrationResponseRequest)
            throws UnauthorizedException, NotFoundException, LimitExceededException, BadRequestException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<PutIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutIntegrationResponseResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<PutIntegrationResponseRequest, PutIntegrationResponseResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putIntegrationResponseRequest)
                .withMarshaller(new PutIntegrationResponseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Add a method to an existing <a>Resource</a> resource.
     * </p>
     *
     * @param putMethodRequest
     *        Request to add a method to an existing <a>Resource</a> resource.
     * @return Result of the PutMethod operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutMethod
     */
    @Override
    public PutMethodResponse putMethod(PutMethodRequest putMethodRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, ConflictException, LimitExceededException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<PutMethodResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutMethodResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<PutMethodRequest, PutMethodResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putMethodRequest)
                .withMarshaller(new PutMethodRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds a <a>MethodResponse</a> to an existing <a>Method</a> resource.
     * </p>
     *
     * @param putMethodResponseRequest
     *        Request to add a <a>MethodResponse</a> to an existing <a>Method</a> resource.
     * @return Result of the PutMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutMethodResponse
     */
    @Override
    public PutMethodResponseResponse putMethodResponse(PutMethodResponseRequest putMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<PutMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutMethodResponseResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<PutMethodResponseRequest, PutMethodResponseResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putMethodResponseRequest).withMarshaller(new PutMethodResponseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * A feature of the API Gateway control service for updating an existing API with an input of external API
     * definitions. The update can take the form of merging the supplied definition into the existing API or overwriting
     * the existing API.
     * </p>
     *
     * @param putRestApiRequest
     *        A PUT request to update an existing API, with external API definitions specified as the request body.
     * @return Result of the PutRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutRestApi
     */
    @Override
    public PutRestApiResponse putRestApi(PutRestApiRequest putRestApiRequest) throws UnauthorizedException,
            LimitExceededException, NotFoundException, BadRequestException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<PutRestApiResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutRestApiResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<PutRestApiRequest, PutRestApiResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putRestApiRequest)
                .withMarshaller(new PutRestApiRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds or updates a tag on a given resource.
     * </p>
     *
     * @param tagResourceRequest
     *        Adds or updates a tag on a given resource.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.TagResource
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, NotFoundException, LimitExceededException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new TagResourceResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(tagResourceRequest).withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Simulate the execution of an <a>Authorizer</a> in your <a>RestApi</a> with headers, parameters, and an incoming
     * request body.
     * </p>
     * <div class="seeAlso"> <a
     * href="http://docs.aws.amazon.com/apigateway/latest/developerguide/use-custom-authorizer.html">Enable custom
     * authorizers</a> </div>
     *
     * @param testInvokeAuthorizerRequest
     *        Make a request to simulate the execution of an <a>Authorizer</a>.
     * @return Result of the TestInvokeAuthorizer operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.TestInvokeAuthorizer
     */
    @Override
    public TestInvokeAuthorizerResponse testInvokeAuthorizer(TestInvokeAuthorizerRequest testInvokeAuthorizerRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<TestInvokeAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new TestInvokeAuthorizerResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<TestInvokeAuthorizerRequest, TestInvokeAuthorizerResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(testInvokeAuthorizerRequest)
                .withMarshaller(new TestInvokeAuthorizerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Simulate the execution of a <a>Method</a> in your <a>RestApi</a> with headers, parameters, and an incoming
     * request body.
     * </p>
     *
     * @param testInvokeMethodRequest
     *        Make a request to simulate the execution of a <a>Method</a>.
     * @return Result of the TestInvokeMethod operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.TestInvokeMethod
     */
    @Override
    public TestInvokeMethodResponse testInvokeMethod(TestInvokeMethodRequest testInvokeMethodRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<TestInvokeMethodResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new TestInvokeMethodResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<TestInvokeMethodRequest, TestInvokeMethodResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(testInvokeMethodRequest).withMarshaller(new TestInvokeMethodRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a tag from a given resource.
     * </p>
     *
     * @param untagResourceRequest
     *        Removes a tag from a given resource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UntagResource
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, NotFoundException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UntagResourceResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(untagResourceRequest).withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes information about the current <a>Account</a> resource.
     * </p>
     *
     * @param updateAccountRequest
     *        Requests API Gateway to change information about the current <a>Account</a> resource.
     * @return Result of the UpdateAccount operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateAccount
     */
    @Override
    public UpdateAccountResponse updateAccount(UpdateAccountRequest updateAccountRequest) throws UnauthorizedException,
            BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<UpdateAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateAccountResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateAccountRequest, UpdateAccountResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateAccountRequest).withMarshaller(new UpdateAccountRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes information about an <a>ApiKey</a> resource.
     * </p>
     *
     * @param updateApiKeyRequest
     *        A request to change information about an <a>ApiKey</a> resource.
     * @return Result of the UpdateApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateApiKey
     */
    @Override
    public UpdateApiKeyResponse updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateApiKeyResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateApiKeyRequest, UpdateApiKeyResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateApiKeyRequest).withMarshaller(new UpdateApiKeyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="http://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html">AWS CLI</a></div>
     *
     * @param updateAuthorizerRequest
     *        Request to update an existing <a>Authorizer</a> resource.
     * @return Result of the UpdateAuthorizer operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateAuthorizer
     */
    @Override
    public UpdateAuthorizerResponse updateAuthorizer(UpdateAuthorizerRequest updateAuthorizerRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateAuthorizerResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateAuthorizerRequest, UpdateAuthorizerResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateAuthorizerRequest).withMarshaller(new UpdateAuthorizerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes information about the <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param updateBasePathMappingRequest
     *        A request to change information about the <a>BasePathMapping</a> resource.
     * @return Result of the UpdateBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateBasePathMapping
     */
    @Override
    public UpdateBasePathMappingResponse updateBasePathMapping(UpdateBasePathMappingRequest updateBasePathMappingRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateBasePathMappingResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateBasePathMappingRequest, UpdateBasePathMappingResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateBasePathMappingRequest)
                .withMarshaller(new UpdateBasePathMappingRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes information about an <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param updateClientCertificateRequest
     *        A request to change information about an <a>ClientCertificate</a> resource.
     * @return Result of the UpdateClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateClientCertificate
     */
    @Override
    public UpdateClientCertificateResponse updateClientCertificate(UpdateClientCertificateRequest updateClientCertificateRequest)
            throws UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateClientCertificateResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateClientCertificateRequest, UpdateClientCertificateResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateClientCertificateRequest)
                .withMarshaller(new UpdateClientCertificateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes information about a <a>Deployment</a> resource.
     * </p>
     *
     * @param updateDeploymentRequest
     *        Requests API Gateway to change information about a <a>Deployment</a> resource.
     * @return Result of the UpdateDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDeployment
     */
    @Override
    public UpdateDeploymentResponse updateDeployment(UpdateDeploymentRequest updateDeploymentRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateDeploymentResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateDeploymentRequest, UpdateDeploymentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateDeploymentRequest).withMarshaller(new UpdateDeploymentRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the UpdateDocumentationPart operation.
     *
     * @param updateDocumentationPartRequest
     *        Updates an existing documentation part of a given API.
     * @return Result of the UpdateDocumentationPart operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDocumentationPart
     */
    @Override
    public UpdateDocumentationPartResponse updateDocumentationPart(UpdateDocumentationPartRequest updateDocumentationPartRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, ConflictException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateDocumentationPartResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateDocumentationPartRequest, UpdateDocumentationPartResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateDocumentationPartRequest)
                .withMarshaller(new UpdateDocumentationPartRequestMarshaller(protocolFactory)));
    }

    /**
     * Invokes the UpdateDocumentationVersion operation.
     *
     * @param updateDocumentationVersionRequest
     *        Updates an existing documentation version of an API.
     * @return Result of the UpdateDocumentationVersion operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDocumentationVersion
     */
    @Override
    public UpdateDocumentationVersionResponse updateDocumentationVersion(
            UpdateDocumentationVersionRequest updateDocumentationVersionRequest) throws UnauthorizedException, NotFoundException,
            ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<UpdateDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateDocumentationVersionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateDocumentationVersionRequest, UpdateDocumentationVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(updateDocumentationVersionRequest)
                        .withMarshaller(new UpdateDocumentationVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes information about the <a>DomainName</a> resource.
     * </p>
     *
     * @param updateDomainNameRequest
     *        A request to change information about the <a>DomainName</a> resource.
     * @return Result of the UpdateDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDomainName
     */
    @Override
    public UpdateDomainNameResponse updateDomainName(UpdateDomainNameRequest updateDomainNameRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, ConflictException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateDomainNameResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateDomainNameRequest, UpdateDomainNameResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateDomainNameRequest).withMarshaller(new UpdateDomainNameRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * </p>
     *
     * @param updateGatewayResponseRequest
     *        Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * @return Result of the UpdateGatewayResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateGatewayResponse
     */
    @Override
    public UpdateGatewayResponseResponse updateGatewayResponse(UpdateGatewayResponseRequest updateGatewayResponseRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateGatewayResponseResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateGatewayResponseRequest, UpdateGatewayResponseResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateGatewayResponseRequest)
                .withMarshaller(new UpdateGatewayResponseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Represents an update integration.
     * </p>
     *
     * @param updateIntegrationRequest
     *        Represents an update integration request.
     * @return Result of the UpdateIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateIntegration
     */
    @Override
    public UpdateIntegrationResponse updateIntegration(UpdateIntegrationRequest updateIntegrationRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateIntegrationResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateIntegrationRequest, UpdateIntegrationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateIntegrationRequest).withMarshaller(new UpdateIntegrationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Represents an update integration response.
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        Represents an update integration response request.
     * @return Result of the UpdateIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateIntegrationResponse
     */
    @Override
    public UpdateIntegrationResponseResponse updateIntegrationResponse(
            UpdateIntegrationResponseRequest updateIntegrationResponseRequest) throws UnauthorizedException, NotFoundException,
            ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<UpdateIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateIntegrationResponseResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateIntegrationResponseRequest, UpdateIntegrationResponseResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(updateIntegrationResponseRequest)
                        .withMarshaller(new UpdateIntegrationResponseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing <a>Method</a> resource.
     * </p>
     *
     * @param updateMethodRequest
     *        Request to update an existing <a>Method</a> resource.
     * @return Result of the UpdateMethod operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateMethod
     */
    @Override
    public UpdateMethodResponse updateMethod(UpdateMethodRequest updateMethodRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateMethodResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateMethodResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateMethodRequest, UpdateMethodResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateMethodRequest).withMarshaller(new UpdateMethodRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing <a>MethodResponse</a> resource.
     * </p>
     *
     * @param updateMethodResponseRequest
     *        A request to update an existing <a>MethodResponse</a> resource.
     * @return Result of the UpdateMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateMethodResponse
     */
    @Override
    public UpdateMethodResponseResponse updateMethodResponse(UpdateMethodResponseRequest updateMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateMethodResponseResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateMethodResponseRequest, UpdateMethodResponseResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateMethodResponseRequest)
                .withMarshaller(new UpdateMethodResponseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes information about a model.
     * </p>
     *
     * @param updateModelRequest
     *        Request to update an existing model in an existing <a>RestApi</a> resource.
     * @return Result of the UpdateModel operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateModel
     */
    @Override
    public UpdateModelResponse updateModel(UpdateModelRequest updateModelRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateModelResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateModelResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateModelRequest, UpdateModelResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateModelRequest).withMarshaller(new UpdateModelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param updateRequestValidatorRequest
     *        Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the UpdateRequestValidator operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateRequestValidator
     */
    @Override
    public UpdateRequestValidatorResponse updateRequestValidator(UpdateRequestValidatorRequest updateRequestValidatorRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateRequestValidatorResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateRequestValidatorRequest, UpdateRequestValidatorResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateRequestValidatorRequest)
                .withMarshaller(new UpdateRequestValidatorRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes information about a <a>Resource</a> resource.
     * </p>
     *
     * @param updateResourceRequest
     *        Request to change information about a <a>Resource</a> resource.
     * @return Result of the UpdateResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateResource
     */
    @Override
    public UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateResourceResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateResourceRequest, UpdateResourceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateResourceRequest).withMarshaller(new UpdateResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes information about the specified API.
     * </p>
     *
     * @param updateRestApiRequest
     *        Request to update an existing <a>RestApi</a> resource in your collection.
     * @return Result of the UpdateRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateRestApi
     */
    @Override
    public UpdateRestApiResponse updateRestApi(UpdateRestApiRequest updateRestApiRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateRestApiResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateRestApiResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateRestApiRequest, UpdateRestApiResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateRestApiRequest).withMarshaller(new UpdateRestApiRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes information about a <a>Stage</a> resource.
     * </p>
     *
     * @param updateStageRequest
     *        Requests API Gateway to change information about a <a>Stage</a> resource.
     * @return Result of the UpdateStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateStage
     */
    @Override
    public UpdateStageResponse updateStage(UpdateStageRequest updateStageRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateStageResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateStageResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateStageRequest, UpdateStageResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateStageRequest).withMarshaller(new UpdateStageRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
     * </p>
     *
     * @param updateUsageRequest
     *        The PATCH request to grant a temporary extension to the remaining quota of a usage plan associated with a
     *        specified API key.
     * @return Result of the UpdateUsage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateUsage
     */
    @Override
    public UpdateUsageResponse updateUsage(UpdateUsageRequest updateUsageRequest) throws UnauthorizedException,
            TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            ApiGatewayException {

        HttpResponseHandler<UpdateUsageResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateUsageResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateUsageRequest, UpdateUsageResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateUsageRequest).withMarshaller(new UpdateUsageRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a usage plan of a given plan Id.
     * </p>
     *
     * @param updateUsagePlanRequest
     *        The PATCH request to update a usage plan of a given plan Id.
     * @return Result of the UpdateUsagePlan operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateUsagePlan
     */
    @Override
    public UpdateUsagePlanResponse updateUsagePlan(UpdateUsagePlanRequest updateUsagePlanRequest) throws UnauthorizedException,
            TooManyRequestsException, BadRequestException, NotFoundException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateUsagePlanResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateUsagePlanRequest, UpdateUsagePlanResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateUsagePlanRequest).withMarshaller(new UpdateUsagePlanRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing <a>VpcLink</a> of a specified identifier.
     * </p>
     *
     * @param updateVpcLinkRequest
     *        Updates an existing <a>VpcLink</a> of a specified identifier.
     * @return Result of the UpdateVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateVpcLink
     */
    @Override
    public UpdateVpcLinkResponse updateVpcLink(UpdateVpcLinkRequest updateVpcLinkRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {

        HttpResponseHandler<UpdateVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateVpcLinkResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory);

        return clientHandler.execute(new ClientExecutionParams<UpdateVpcLinkRequest, UpdateVpcLinkResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateVpcLinkRequest).withMarshaller(new UpdateVpcLinkRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(
                new JsonClientMetadata()
                        .withSupportsCbor(supportsCbor)
                        .withSupportsIon(false)
                        .withBaseServiceExceptionClass(software.amazon.awssdk.services.apigateway.model.ApiGatewayException.class)
                        .withContentTypeOverride("")
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(
                                        LimitExceededException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(
                                        NotFoundException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withModeledClass(
                                        UnauthorizedException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ConflictException").withModeledClass(
                                        ConflictException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(
                                        ServiceUnavailableException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(
                                        TooManyRequestsException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(
                                        BadRequestException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1")
                        .protocol(AwsJsonProtocol.REST_JSON).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
