/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.AccessLogSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Access log settings, including the access log format and access log destination ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessLogSettings implements StructuredPojo, ToCopyableBuilder<AccessLogSettings.Builder, AccessLogSettings> {
    private final String format;

    private final String destinationArn;

    private AccessLogSettings(BuilderImpl builder) {
        this.format = builder.format;
        this.destinationArn = builder.destinationArn;
    }

    /**
     * <p>
     * A single line format of the access logs of data, as specified by selected <a href=
     * "http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference"
     * >$context variables</a>. The format must include at least <code>$context.requestId</code>.
     * </p>
     * 
     * @return A single line format of the access logs of data, as specified by selected <a href=
     *         "http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference"
     *         >$context variables</a>. The format must include at least <code>$context.requestId</code>.
     */
    public String format() {
        return format;
    }

    /**
     * <p>
     * The ARN of the CloudWatch Logs log group to receive access logs.
     * </p>
     * 
     * @return The ARN of the CloudWatch Logs log group to receive access logs.
     */
    public String destinationArn() {
        return destinationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessLogSettings)) {
            return false;
        }
        AccessLogSettings other = (AccessLogSettings) obj;
        return Objects.equals(format(), other.format()) && Objects.equals(destinationArn(), other.destinationArn());
    }

    @Override
    public String toString() {
        return ToString.builder("AccessLogSettings").add("Format", format()).add("DestinationArn", destinationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(format()));
        case "destinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccessLogSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AccessLogSettings> {
        /**
         * <p>
         * A single line format of the access logs of data, as specified by selected <a href=
         * "http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference"
         * >$context variables</a>. The format must include at least <code>$context.requestId</code>.
         * </p>
         * 
         * @param format
         *        A single line format of the access logs of data, as specified by selected <a href=
         *        "http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference"
         *        >$context variables</a>. The format must include at least <code>$context.requestId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The ARN of the CloudWatch Logs log group to receive access logs.
         * </p>
         * 
         * @param destinationArn
         *        The ARN of the CloudWatch Logs log group to receive access logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String destinationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessLogSettings model) {
            format(model.format);
            destinationArn(model.destinationArn);
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public AccessLogSettings build() {
            return new AccessLogSettings(this);
        }
    }
}
