/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a new documentation part of a given API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDocumentationPartRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateDocumentationPartRequest.Builder, CreateDocumentationPartRequest> {
    private final String restApiId;

    private final DocumentationPartLocation location;

    private final String properties;

    private CreateDocumentationPartRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.location = builder.location;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The location of the targeted API entity of the to-be-created documentation part.
     * </p>
     * 
     * @return [Required] The location of the targeted API entity of the to-be-created documentation part.
     */
    public DocumentationPartLocation location() {
        return location;
    }

    /**
     * <p>
     * [Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are
     * API-specific, but only Swagger-compliant key-value pairs can be exported and, hence, published.
     * </p>
     * 
     * @return [Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are
     *         API-specific, but only Swagger-compliant key-value pairs can be exported and, hence, published.
     */
    public String properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDocumentationPartRequest)) {
            return false;
        }
        CreateDocumentationPartRequest other = (CreateDocumentationPartRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(location(), other.location())
                && Objects.equals(properties(), other.properties());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateDocumentationPartRequest").add("RestApiId", restApiId()).add("Location", location())
                .add("Properties", properties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, CreateDocumentationPartRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The location of the targeted API entity of the to-be-created documentation part.
         * </p>
         * 
         * @param location
         *        [Required] The location of the targeted API entity of the to-be-created documentation part.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(DocumentationPartLocation location);

        /**
         * <p>
         * [Required] The location of the targeted API entity of the to-be-created documentation part.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentationPartLocation.Builder} avoiding the
         * need to create one manually via {@link DocumentationPartLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentationPartLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #location(DocumentationPartLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link DocumentationPartLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(DocumentationPartLocation)
         */
        default Builder location(Consumer<DocumentationPartLocation.Builder> location) {
            return location(DocumentationPartLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * [Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are
         * API-specific, but only Swagger-compliant key-value pairs can be exported and, hence, published.
         * </p>
         * 
         * @param properties
         *        [Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are
         *        API-specific, but only Swagger-compliant key-value pairs can be exported and, hence, published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(String properties);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private DocumentationPartLocation location;

        private String properties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDocumentationPartRequest model) {
            super(model);
            restApiId(model.restApiId);
            location(model.location);
            properties(model.properties);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final DocumentationPartLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(DocumentationPartLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(DocumentationPartLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getProperties() {
            return properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDocumentationPartRequest build() {
            return new CreateDocumentationPartRequest(this);
        }
    }
}
