/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a new documentation version of a given API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDocumentationVersionRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateDocumentationVersionRequest.Builder, CreateDocumentationVersionRequest> {
    private final String restApiId;

    private final String documentationVersion;

    private final String stageName;

    private final String description;

    private CreateDocumentationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.documentationVersion = builder.documentationVersion;
        this.stageName = builder.stageName;
        this.description = builder.description;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The version identifier of the new snapshot.
     * </p>
     * 
     * @return [Required] The version identifier of the new snapshot.
     */
    public String documentationVersion() {
        return documentationVersion;
    }

    /**
     * <p>
     * The stage name to be associated with the new documentation snapshot.
     * </p>
     * 
     * @return The stage name to be associated with the new documentation snapshot.
     */
    public String stageName() {
        return stageName;
    }

    /**
     * <p>
     * A description about the new documentation snapshot.
     * </p>
     * 
     * @return A description about the new documentation snapshot.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(documentationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDocumentationVersionRequest)) {
            return false;
        }
        CreateDocumentationVersionRequest other = (CreateDocumentationVersionRequest) obj;
        return Objects.equals(restApiId(), other.restApiId())
                && Objects.equals(documentationVersion(), other.documentationVersion())
                && Objects.equals(stageName(), other.stageName()) && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateDocumentationVersionRequest").add("RestApiId", restApiId())
                .add("DocumentationVersion", documentationVersion()).add("StageName", stageName())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "documentationVersion":
            return Optional.ofNullable(clazz.cast(documentationVersion()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, CreateDocumentationVersionRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The version identifier of the new snapshot.
         * </p>
         * 
         * @param documentationVersion
         *        [Required] The version identifier of the new snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationVersion(String documentationVersion);

        /**
         * <p>
         * The stage name to be associated with the new documentation snapshot.
         * </p>
         * 
         * @param stageName
         *        The stage name to be associated with the new documentation snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * A description about the new documentation snapshot.
         * </p>
         * 
         * @param description
         *        A description about the new documentation snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String documentationVersion;

        private String stageName;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDocumentationVersionRequest model) {
            super(model);
            restApiId(model.restApiId);
            documentationVersion(model.documentationVersion);
            stageName(model.stageName);
            description(model.description);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getDocumentationVersion() {
            return documentationVersion;
        }

        @Override
        public final Builder documentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        public final void setDocumentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDocumentationVersionRequest build() {
            return new CreateDocumentationVersionRequest(this);
        }
    }
}
