/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The POST request to create a usage plan key for adding an existing API key to a usage plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUsagePlanKeyRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateUsagePlanKeyRequest.Builder, CreateUsagePlanKeyRequest> {
    private final String usagePlanId;

    private final String keyId;

    private final String keyType;

    private CreateUsagePlanKeyRequest(BuilderImpl builder) {
        super(builder);
        this.usagePlanId = builder.usagePlanId;
        this.keyId = builder.keyId;
        this.keyType = builder.keyType;
    }

    /**
     * <p>
     * [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-created
     * <a>UsagePlanKey</a> resource representing a plan customer.
     * </p>
     * 
     * @return [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the
     *         to-be-created <a>UsagePlanKey</a> resource representing a plan customer.
     */
    public String usagePlanId() {
        return usagePlanId;
    }

    /**
     * <p>
     * [Required] The identifier of a <a>UsagePlanKey</a> resource for a plan customer.
     * </p>
     * 
     * @return [Required] The identifier of a <a>UsagePlanKey</a> resource for a plan customer.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * [Required] The type of a <a>UsagePlanKey</a> resource for a plan customer.
     * </p>
     * 
     * @return [Required] The type of a <a>UsagePlanKey</a> resource for a plan customer.
     */
    public String keyType() {
        return keyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usagePlanId());
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(keyType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUsagePlanKeyRequest)) {
            return false;
        }
        CreateUsagePlanKeyRequest other = (CreateUsagePlanKeyRequest) obj;
        return Objects.equals(usagePlanId(), other.usagePlanId()) && Objects.equals(keyId(), other.keyId())
                && Objects.equals(keyType(), other.keyType());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateUsagePlanKeyRequest").add("UsagePlanId", usagePlanId()).add("KeyId", keyId())
                .add("KeyType", keyType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usagePlanId":
            return Optional.ofNullable(clazz.cast(usagePlanId()));
        case "keyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        case "keyType":
            return Optional.ofNullable(clazz.cast(keyType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, CreateUsagePlanKeyRequest> {
        /**
         * <p>
         * [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-created
         * <a>UsagePlanKey</a> resource representing a plan customer.
         * </p>
         * 
         * @param usagePlanId
         *        [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the
         *        to-be-created <a>UsagePlanKey</a> resource representing a plan customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePlanId(String usagePlanId);

        /**
         * <p>
         * [Required] The identifier of a <a>UsagePlanKey</a> resource for a plan customer.
         * </p>
         * 
         * @param keyId
         *        [Required] The identifier of a <a>UsagePlanKey</a> resource for a plan customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * [Required] The type of a <a>UsagePlanKey</a> resource for a plan customer.
         * </p>
         * 
         * @param keyType
         *        [Required] The type of a <a>UsagePlanKey</a> resource for a plan customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyType(String keyType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String usagePlanId;

        private String keyId;

        private String keyType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUsagePlanKeyRequest model) {
            super(model);
            usagePlanId(model.usagePlanId);
            keyId(model.keyId);
            keyType(model.keyType);
        }

        public final String getUsagePlanId() {
            return usagePlanId;
        }

        @Override
        public final Builder usagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
            return this;
        }

        public final void setUsagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getKeyType() {
            return keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUsagePlanKeyRequest build() {
            return new CreateUsagePlanKeyRequest(this);
        }
    }
}
