/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to delete the <a>ApiKey</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteApiKeyRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<DeleteApiKeyRequest.Builder, DeleteApiKeyRequest> {
    private final String apiKey;

    private DeleteApiKeyRequest(BuilderImpl builder) {
        super(builder);
        this.apiKey = builder.apiKey;
    }

    /**
     * <p>
     * [Required] The identifier of the <a>ApiKey</a> resource to be deleted.
     * </p>
     * 
     * @return [Required] The identifier of the <a>ApiKey</a> resource to be deleted.
     */
    public String apiKey() {
        return apiKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApiKeyRequest)) {
            return false;
        }
        DeleteApiKeyRequest other = (DeleteApiKeyRequest) obj;
        return Objects.equals(apiKey(), other.apiKey());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteApiKeyRequest").add("ApiKey", apiKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiKey":
            return Optional.ofNullable(clazz.cast(apiKey()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, DeleteApiKeyRequest> {
        /**
         * <p>
         * [Required] The identifier of the <a>ApiKey</a> resource to be deleted.
         * </p>
         * 
         * @param apiKey
         *        [Required] The identifier of the <a>ApiKey</a> resource to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKey(String apiKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String apiKey;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApiKeyRequest model) {
            super(model);
            apiKey(model.apiKey);
        }

        public final String getApiKey() {
            return apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApiKeyRequest build() {
            return new DeleteApiKeyRequest(this);
        }
    }
}
