/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to delete the specified API from your collection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRestApiRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<DeleteRestApiRequest.Builder, DeleteRestApiRequest> {
    private final String restApiId;

    private DeleteRestApiRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRestApiRequest)) {
            return false;
        }
        DeleteRestApiRequest other = (DeleteRestApiRequest) obj;
        return Objects.equals(restApiId(), other.restApiId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteRestApiRequest").add("RestApiId", restApiId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, DeleteRestApiRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRestApiRequest model) {
            super(model);
            restApiId(model.restApiId);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRestApiRequest build() {
            return new DeleteRestApiRequest(this);
        }
    }
}
