/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Deletes an existing <a>VpcLink</a> of a specified identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcLinkRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<DeleteVpcLinkRequest.Builder, DeleteVpcLinkRequest> {
    private final String vpcLinkId;

    private DeleteVpcLinkRequest(BuilderImpl builder) {
        super(builder);
        this.vpcLinkId = builder.vpcLinkId;
    }

    /**
     * <p>
     * [Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this
     * <a>VpcLink</a>.
     * </p>
     * 
     * @return [Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this
     *         <a>VpcLink</a>.
     */
    public String vpcLinkId() {
        return vpcLinkId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcLinkId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcLinkRequest)) {
            return false;
        }
        DeleteVpcLinkRequest other = (DeleteVpcLinkRequest) obj;
        return Objects.equals(vpcLinkId(), other.vpcLinkId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteVpcLinkRequest").add("VpcLinkId", vpcLinkId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpcLinkId":
            return Optional.ofNullable(clazz.cast(vpcLinkId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, DeleteVpcLinkRequest> {
        /**
         * <p>
         * [Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this
         * <a>VpcLink</a>.
         * </p>
         * 
         * @param vpcLinkId
         *        [Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this
         *        <a>VpcLink</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcLinkId(String vpcLinkId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String vpcLinkId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcLinkRequest model) {
            super(model);
            vpcLinkId(model.vpcLinkId);
        }

        public final String getVpcLinkId() {
            return vpcLinkId;
        }

        @Override
        public final Builder vpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
            return this;
        }

        public final void setVpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpcLinkRequest build() {
            return new DeleteVpcLinkRequest(this);
        }
    }
}
