/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to flush authorizer cache entries on a specified stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlushStageAuthorizersCacheRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<FlushStageAuthorizersCacheRequest.Builder, FlushStageAuthorizersCacheRequest> {
    private final String restApiId;

    private final String stageName;

    private FlushStageAuthorizersCacheRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.stageName = builder.stageName;
    }

    /**
     * <p>
     * The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The name of the stage to flush.
     * </p>
     * 
     * @return The name of the stage to flush.
     */
    public String stageName() {
        return stageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlushStageAuthorizersCacheRequest)) {
            return false;
        }
        FlushStageAuthorizersCacheRequest other = (FlushStageAuthorizersCacheRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(stageName(), other.stageName());
    }

    @Override
    public String toString() {
        return ToString.builder("FlushStageAuthorizersCacheRequest").add("RestApiId", restApiId()).add("StageName", stageName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, FlushStageAuthorizersCacheRequest> {
        /**
         * <p>
         * The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The name of the stage to flush.
         * </p>
         * 
         * @param stageName
         *        The name of the stage to flush.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(FlushStageAuthorizersCacheRequest model) {
            super(model);
            restApiId(model.restApiId);
            stageName(model.stageName);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public FlushStageAuthorizersCacheRequest build() {
            return new FlushStageAuthorizersCacheRequest(this);
        }
    }
}
