/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to get information about the current <a>ApiKey</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApiKeyRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetApiKeyRequest.Builder, GetApiKeyRequest> {
    private final String apiKey;

    private final Boolean includeValue;

    private GetApiKeyRequest(BuilderImpl builder) {
        super(builder);
        this.apiKey = builder.apiKey;
        this.includeValue = builder.includeValue;
    }

    /**
     * <p>
     * [Required] The identifier of the <a>ApiKey</a> resource.
     * </p>
     * 
     * @return [Required] The identifier of the <a>ApiKey</a> resource.
     */
    public String apiKey() {
        return apiKey;
    }

    /**
     * <p>
     * A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the key
     * value.
     * </p>
     * 
     * @return A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the
     *         key value.
     */
    public Boolean includeValue() {
        return includeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(includeValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApiKeyRequest)) {
            return false;
        }
        GetApiKeyRequest other = (GetApiKeyRequest) obj;
        return Objects.equals(apiKey(), other.apiKey()) && Objects.equals(includeValue(), other.includeValue());
    }

    @Override
    public String toString() {
        return ToString.builder("GetApiKeyRequest").add("ApiKey", apiKey()).add("IncludeValue", includeValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiKey":
            return Optional.ofNullable(clazz.cast(apiKey()));
        case "includeValue":
            return Optional.ofNullable(clazz.cast(includeValue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, GetApiKeyRequest> {
        /**
         * <p>
         * [Required] The identifier of the <a>ApiKey</a> resource.
         * </p>
         * 
         * @param apiKey
         *        [Required] The identifier of the <a>ApiKey</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKey(String apiKey);

        /**
         * <p>
         * A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the key
         * value.
         * </p>
         * 
         * @param includeValue
         *        A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains
         *        the key value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeValue(Boolean includeValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String apiKey;

        private Boolean includeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApiKeyRequest model) {
            super(model);
            apiKey(model.apiKey);
            includeValue(model.includeValue);
        }

        public final String getApiKey() {
            return apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public final Boolean getIncludeValue() {
            return includeValue;
        }

        @Override
        public final Builder includeValue(Boolean includeValue) {
            this.includeValue = includeValue;
            return this;
        }

        public final void setIncludeValue(Boolean includeValue) {
            this.includeValue = includeValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApiKeyRequest build() {
            return new GetApiKeyRequest(this);
        }
    }
}
