/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to get information about the current <a>ApiKeys</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApiKeysRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetApiKeysRequest.Builder, GetApiKeysRequest> {
    private final String position;

    private final Integer limit;

    private final String nameQuery;

    private final String customerId;

    private final Boolean includeValues;

    private GetApiKeysRequest(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.limit = builder.limit;
        this.nameQuery = builder.nameQuery;
        this.customerId = builder.customerId;
        this.includeValues = builder.includeValues;
    }

    /**
     * <p>
     * The current pagination position in the paged result set.
     * </p>
     * 
     * @return The current pagination position in the paged result set.
     */
    public String position() {
        return position;
    }

    /**
     * <p>
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     * </p>
     * 
     * @return The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The name of queried API keys.
     * </p>
     * 
     * @return The name of queried API keys.
     */
    public String nameQuery() {
        return nameQuery;
    }

    /**
     * <p>
     * The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.
     * </p>
     * 
     * @return The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.
     */
    public String customerId() {
        return customerId;
    }

    /**
     * <p>
     * A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key values.
     * </p>
     * 
     * @return A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key
     *         values.
     */
    public Boolean includeValues() {
        return includeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nameQuery());
        hashCode = 31 * hashCode + Objects.hashCode(customerId());
        hashCode = 31 * hashCode + Objects.hashCode(includeValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApiKeysRequest)) {
            return false;
        }
        GetApiKeysRequest other = (GetApiKeysRequest) obj;
        return Objects.equals(position(), other.position()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nameQuery(), other.nameQuery()) && Objects.equals(customerId(), other.customerId())
                && Objects.equals(includeValues(), other.includeValues());
    }

    @Override
    public String toString() {
        return ToString.builder("GetApiKeysRequest").add("Position", position()).add("Limit", limit())
                .add("NameQuery", nameQuery()).add("CustomerId", customerId()).add("IncludeValues", includeValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "nameQuery":
            return Optional.ofNullable(clazz.cast(nameQuery()));
        case "customerId":
            return Optional.ofNullable(clazz.cast(customerId()));
        case "includeValues":
            return Optional.ofNullable(clazz.cast(includeValues()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, GetApiKeysRequest> {
        /**
         * <p>
         * The current pagination position in the paged result set.
         * </p>
         * 
         * @param position
         *        The current pagination position in the paged result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * </p>
         * 
         * @param limit
         *        The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The name of queried API keys.
         * </p>
         * 
         * @param nameQuery
         *        The name of queried API keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameQuery(String nameQuery);

        /**
         * <p>
         * The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.
         * </p>
         * 
         * @param customerId
         *        The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerId(String customerId);

        /**
         * <p>
         * A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key
         * values.
         * </p>
         * 
         * @param includeValues
         *        A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains
         *        key values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeValues(Boolean includeValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String position;

        private Integer limit;

        private String nameQuery;

        private String customerId;

        private Boolean includeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApiKeysRequest model) {
            super(model);
            position(model.position);
            limit(model.limit);
            nameQuery(model.nameQuery);
            customerId(model.customerId);
            includeValues(model.includeValues);
        }

        public final String getPosition() {
            return position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNameQuery() {
            return nameQuery;
        }

        @Override
        public final Builder nameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
            return this;
        }

        public final void setNameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
        }

        public final String getCustomerId() {
            return customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        public final Boolean getIncludeValues() {
            return includeValues;
        }

        @Override
        public final Builder includeValues(Boolean includeValues) {
            this.includeValues = includeValues;
            return this;
        }

        public final void setIncludeValues(Boolean includeValues) {
            this.includeValues = includeValues;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApiKeysRequest build() {
            return new GetApiKeysRequest(this);
        }
    }
}
