/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to describe a <a>BasePathMapping</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBasePathMappingRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetBasePathMappingRequest.Builder, GetBasePathMappingRequest> {
    private final String domainName;

    private final String basePath;

    private GetBasePathMappingRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.basePath = builder.basePath;
    }

    /**
     * <p>
     * [Required] The domain name of the <a>BasePathMapping</a> resource to be described.
     * </p>
     * 
     * @return [Required] The domain name of the <a>BasePathMapping</a> resource to be described.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * [Required] The base path name that callers of the API must provide as part of the URL after the domain name. This
     * value must be unique for all of the mappings across a single API. Leave this blank if you do not want callers to
     * specify any base path name after the domain name.
     * </p>
     * 
     * @return [Required] The base path name that callers of the API must provide as part of the URL after the domain
     *         name. This value must be unique for all of the mappings across a single API. Leave this blank if you do
     *         not want callers to specify any base path name after the domain name.
     */
    public String basePath() {
        return basePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(basePath());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBasePathMappingRequest)) {
            return false;
        }
        GetBasePathMappingRequest other = (GetBasePathMappingRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(basePath(), other.basePath());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBasePathMappingRequest").add("DomainName", domainName()).add("BasePath", basePath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "basePath":
            return Optional.ofNullable(clazz.cast(basePath()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, GetBasePathMappingRequest> {
        /**
         * <p>
         * [Required] The domain name of the <a>BasePathMapping</a> resource to be described.
         * </p>
         * 
         * @param domainName
         *        [Required] The domain name of the <a>BasePathMapping</a> resource to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * [Required] The base path name that callers of the API must provide as part of the URL after the domain name.
         * This value must be unique for all of the mappings across a single API. Leave this blank if you do not want
         * callers to specify any base path name after the domain name.
         * </p>
         * 
         * @param basePath
         *        [Required] The base path name that callers of the API must provide as part of the URL after the domain
         *        name. This value must be unique for all of the mappings across a single API. Leave this blank if you
         *        do not want callers to specify any base path name after the domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basePath(String basePath);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String domainName;

        private String basePath;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBasePathMappingRequest model) {
            super(model);
            domainName(model.domainName);
            basePath(model.basePath);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getBasePath() {
            return basePath;
        }

        @Override
        public final Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public final void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBasePathMappingRequest build() {
            return new GetBasePathMappingRequest(this);
        }
    }
}
