/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a collection resource that contains zero or more references to your existing deployments, and links that
 * guide you on how to interact with your collection. The collection offers a paginated view of the contained
 * deployments.
 * </p>
 * <div class="remarks">To create a new deployment of a <a>RestApi</a>, make a <code>POST</code> request against this
 * resource. To view, update, or delete an existing deployment, make a <code>GET</code>, <code>PATCH</code>, or
 * <code>DELETE</code> request, respectively, on a specified <a>Deployment</a> resource.</div> <div class="seeAlso"> <a
 * href="http://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html">Deploying an API</a>, <a
 * href="http://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html">AWS CLI</a>, <a
 * href="https://aws.amazon.com/tools/">AWS SDKs</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeploymentsResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetDeploymentsResponse.Builder, GetDeploymentsResponse> {
    private final String position;

    private final List<Deployment> items;

    private GetDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.items = builder.items;
    }

    /**
     * Returns the value of the Position property for this object.
     * 
     * @return The value of the Position property for this object.
     */
    public String position() {
        return position;
    }

    /**
     * <p>
     * The current page of elements from this collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The current page of elements from this collection.
     */
    public List<Deployment> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentsResponse)) {
            return false;
        }
        GetDeploymentsResponse other = (GetDeploymentsResponse) obj;
        return Objects.equals(position(), other.position()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDeploymentsResponse").add("Position", position()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayResponse.Builder, CopyableBuilder<Builder, GetDeploymentsResponse> {
        /**
         * Sets the value of the Position property for this object.
         *
         * @param position
         *        The new value for the Position property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param items
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<Deployment> items);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param items
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Deployment... items);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Deployment>.Builder} avoiding the need to
         * create one manually via {@link List<Deployment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Deployment>.Builder#build()} is called immediately and its
         * result is passed to {@link #items(List<Deployment>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<Deployment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<Deployment>)
         */
        Builder items(Consumer<Deployment.Builder>... items);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String position;

        private List<Deployment> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentsResponse model) {
            super(model);
            position(model.position);
            items(model.items);
        }

        public final String getPosition() {
            return position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Collection<Deployment.Builder> getItems() {
            return items != null ? items.stream().map(Deployment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<Deployment> items) {
            this.items = ListOfDeploymentCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Deployment... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<Deployment.Builder>... items) {
            items(Stream.of(items).map(c -> Deployment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<Deployment.BuilderImpl> items) {
            this.items = ListOfDeploymentCopier.copyFromBuilder(items);
        }

        @Override
        public GetDeploymentsResponse build() {
            return new GetDeploymentsResponse(this);
        }
    }
}
