/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A snapshot of the documentation of an API.
 * </p>
 * <div class="remarks">
 * <p>
 * Publishing API documentation involves creating a documentation version associated with an API stage and exporting the
 * versioned documentation to an external (e.g., Swagger) file.
 * </p>
 * </div> <div class="seeAlso"> <a
 * href="http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an
 * API</a>, <a>DocumentationPart</a>, <a>DocumentationVersions</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDocumentationVersionResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetDocumentationVersionResponse.Builder, GetDocumentationVersionResponse> {
    private final String version;

    private final Instant createdDate;

    private final String description;

    private GetDocumentationVersionResponse(BuilderImpl builder) {
        super(builder);
        this.version = builder.version;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
    }

    /**
     * <p>
     * The version identifier of the API documentation snapshot.
     * </p>
     * 
     * @return The version identifier of the API documentation snapshot.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The date when the API documentation snapshot is created.
     * </p>
     * 
     * @return The date when the API documentation snapshot is created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The description of the API documentation snapshot.
     * </p>
     * 
     * @return The description of the API documentation snapshot.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentationVersionResponse)) {
            return false;
        }
        GetDocumentationVersionResponse other = (GetDocumentationVersionResponse) obj;
        return Objects.equals(version(), other.version()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDocumentationVersionResponse").add("Version", version()).add("CreatedDate", createdDate())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayResponse.Builder, CopyableBuilder<Builder, GetDocumentationVersionResponse> {
        /**
         * <p>
         * The version identifier of the API documentation snapshot.
         * </p>
         * 
         * @param version
         *        The version identifier of the API documentation snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The date when the API documentation snapshot is created.
         * </p>
         * 
         * @param createdDate
         *        The date when the API documentation snapshot is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The description of the API documentation snapshot.
         * </p>
         * 
         * @param description
         *        The description of the API documentation snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String version;

        private Instant createdDate;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentationVersionResponse model) {
            super(model);
            version(model.version);
            createdDate(model.createdDate);
            description(model.description);
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public GetDocumentationVersionResponse build() {
            return new GetDocumentationVersionResponse(this);
        }
    }
}
