/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRequestValidatorRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetRequestValidatorRequest.Builder, GetRequestValidatorRequest> {
    private final String restApiId;

    private final String requestValidatorId;

    private GetRequestValidatorRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.requestValidatorId = builder.requestValidatorId;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The identifier of the <a>RequestValidator</a> to be retrieved.
     * </p>
     * 
     * @return [Required] The identifier of the <a>RequestValidator</a> to be retrieved.
     */
    public String requestValidatorId() {
        return requestValidatorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(requestValidatorId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRequestValidatorRequest)) {
            return false;
        }
        GetRequestValidatorRequest other = (GetRequestValidatorRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(requestValidatorId(), other.requestValidatorId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRequestValidatorRequest").add("RestApiId", restApiId())
                .add("RequestValidatorId", requestValidatorId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "requestValidatorId":
            return Optional.ofNullable(clazz.cast(requestValidatorId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, GetRequestValidatorRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The identifier of the <a>RequestValidator</a> to be retrieved.
         * </p>
         * 
         * @param requestValidatorId
         *        [Required] The identifier of the <a>RequestValidator</a> to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestValidatorId(String requestValidatorId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String requestValidatorId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRequestValidatorRequest model) {
            super(model);
            restApiId(model.restApiId);
            requestValidatorId(model.requestValidatorId);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getRequestValidatorId() {
            return requestValidatorId;
        }

        @Override
        public final Builder requestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
            return this;
        }

        public final void setRequestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRequestValidatorRequest build() {
            return new GetRequestValidatorRequest(this);
        }
    }
}
