/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GET request to get a usage plan key of a given key identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsagePlanKeyRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetUsagePlanKeyRequest.Builder, GetUsagePlanKeyRequest> {
    private final String usagePlanId;

    private final String keyId;

    private GetUsagePlanKeyRequest(BuilderImpl builder) {
        super(builder);
        this.usagePlanId = builder.usagePlanId;
        this.keyId = builder.keyId;
    }

    /**
     * <p>
     * [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved
     * <a>UsagePlanKey</a> resource representing a plan customer.
     * </p>
     * 
     * @return [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the
     *         to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.
     */
    public String usagePlanId() {
        return usagePlanId;
    }

    /**
     * <p>
     * [Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.
     * </p>
     * 
     * @return [Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.
     */
    public String keyId() {
        return keyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usagePlanId());
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsagePlanKeyRequest)) {
            return false;
        }
        GetUsagePlanKeyRequest other = (GetUsagePlanKeyRequest) obj;
        return Objects.equals(usagePlanId(), other.usagePlanId()) && Objects.equals(keyId(), other.keyId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetUsagePlanKeyRequest").add("UsagePlanId", usagePlanId()).add("KeyId", keyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usagePlanId":
            return Optional.ofNullable(clazz.cast(usagePlanId()));
        case "keyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, GetUsagePlanKeyRequest> {
        /**
         * <p>
         * [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved
         * <a>UsagePlanKey</a> resource representing a plan customer.
         * </p>
         * 
         * @param usagePlanId
         *        [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the
         *        to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePlanId(String usagePlanId);

        /**
         * <p>
         * [Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.
         * </p>
         * 
         * @param keyId
         *        [Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan
         *        customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String usagePlanId;

        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsagePlanKeyRequest model) {
            super(model);
            usagePlanId(model.usagePlanId);
            keyId(model.keyId);
        }

        public final String getUsagePlanId() {
            return usagePlanId;
        }

        @Override
        public final Builder usagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
            return this;
        }

        public final void setUsagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUsagePlanKeyRequest build() {
            return new GetUsagePlanKeyRequest(this);
        }
    }
}
