/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a usage plan key to identify a plan customer.
 * </p>
 * <div class="remarks">
 * <p>
 * To associate an API stage with a selected API key in a usage plan, you must create a UsagePlanKey resource to
 * represent the selected <a>ApiKey</a>.
 * </p>
 * </div>" <div class="seeAlso"> <a href="http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-
 * usage-plans.html">Create and Use Usage Plans</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsagePlanKeyResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetUsagePlanKeyResponse.Builder, GetUsagePlanKeyResponse> {
    private final String id;

    private final String type;

    private final String value;

    private final String name;

    private GetUsagePlanKeyResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.type = builder.type;
        this.value = builder.value;
        this.name = builder.name;
    }

    /**
     * <p>
     * The Id of a usage plan key.
     * </p>
     * 
     * @return The Id of a usage plan key.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.
     * </p>
     * 
     * @return The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The value of a usage plan key.
     * </p>
     * 
     * @return The value of a usage plan key.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The name of a usage plan key.
     * </p>
     * 
     * @return The name of a usage plan key.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsagePlanKeyResponse)) {
            return false;
        }
        GetUsagePlanKeyResponse other = (GetUsagePlanKeyResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(type(), other.type()) && Objects.equals(value(), other.value())
                && Objects.equals(name(), other.name());
    }

    @Override
    public String toString() {
        return ToString.builder("GetUsagePlanKeyResponse").add("Id", id()).add("Type", type()).add("Value", value())
                .add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayResponse.Builder, CopyableBuilder<Builder, GetUsagePlanKeyResponse> {
        /**
         * <p>
         * The Id of a usage plan key.
         * </p>
         * 
         * @param id
         *        The Id of a usage plan key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.
         * </p>
         * 
         * @param type
         *        The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The value of a usage plan key.
         * </p>
         * 
         * @param value
         *        The value of a usage plan key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The name of a usage plan key.
         * </p>
         * 
         * @param name
         *        The name of a usage plan key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private String type;

        private String value;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsagePlanKeyResponse model) {
            super(model);
            id(model.id);
            type(model.type);
            value(model.value);
            name(model.name);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public GetUsagePlanKeyResponse build() {
            return new GetUsagePlanKeyResponse(this);
        }
    }
}
